/*
 * Copyright 1997-2002 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_VIS_H
#define	_SYS_VIS_H

#pragma ident	"@(#)vis.h	1.2	02/06/21 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * This file is cpu dependent.
 */

#ifdef _KERNEL

#include <sys/asi.h>
#include <sys/machparam.h>

#ifdef _ASM
#ifdef STINGRAY
#define	BSTORE_FPREGS(FP, TEMP) \
	std	%f0, [FP]; \
	std	%f2, [FP + 8]; \
	std	%f4, [FP + 16]; \
	std	%f6, [FP + 24]; \
	std	%f8, [FP + 32]; \
	std	%f10, [FP + 40]; \
	std	%f12, [FP + 48]; \
	std	%f14, [FP + 56]; \
	std	%f16, [FP + 64]; \
	std	%f18, [FP + 72]; \
	std	%f20, [FP + 80]; \
	std	%f22, [FP + 88]; \
	std	%f24, [FP + 96]; \
	std	%f26, [FP + 104]; \
	std	%f28, [FP + 112]; \
	std	%f30, [FP + 120]; \
	std	%f32, [FP + 128]; \
	std	%f34, [FP + 136]; \
	std	%f36, [FP + 144]; \
	std	%f38, [FP + 152]; \
	std	%f40, [FP + 160]; \
	std	%f42, [FP + 168]; \
	std	%f44, [FP + 176]; \
	std	%f46, [FP + 184]; \
	std	%f48, [FP + 192]; \
	std	%f50, [FP + 200]; \
	std	%f52, [FP + 208]; \
	std	%f54, [FP + 216]; \
	std	%f56, [FP + 224]; \
	std	%f58, [FP + 232]; \
	std	%f60, [FP + 240]; \
	std	%f62, [FP + 248];

#define	BSTORE_V8_FPREGS(FP, TEMP) \
	std	%f0, [FP]; \
	std	%f2, [FP + 8]; \
	std	%f4, [FP + 16]; \
	std	%f6, [FP + 24]; \
	std	%f8, [FP + 32]; \
	std	%f10, [FP + 40]; \
	std	%f12, [FP + 48]; \
	std	%f14, [FP + 56]; \
	std	%f16, [FP + 64]; \
	std	%f18, [FP + 72]; \
	std	%f20, [FP + 80]; \
	std	%f22, [FP + 88]; \
	std	%f24, [FP + 96]; \
	std	%f26, [FP + 104]; \
	std	%f28, [FP + 112]; \
	std	%f30, [FP + 120];

#define	BSTORE_V8P_FPREGS(FP, TEMP) \
	std	%f32, [FP + 128]; \
	std	%f34, [FP + 136]; \
	std	%f36, [FP + 144]; \
	std	%f38, [FP + 152]; \
	std	%f40, [FP + 160]; \
	std	%f42, [FP + 168]; \
	std	%f44, [FP + 176]; \
	std	%f46, [FP + 184]; \
	std	%f48, [FP + 192]; \
	std	%f50, [FP + 200]; \
	std	%f52, [FP + 208]; \
	std	%f54, [FP + 216]; \
	std	%f56, [FP + 224]; \
	std	%f58, [FP + 232]; \
	std	%f60, [FP + 240]; \
	std	%f62, [FP + 248];

#define	BLOAD_FPREGS(FP, TEMP) \
	ldd	[FP], %f0; \
	ldd	[FP + 8], %f2; \
	ldd	[FP + 16], %f4; \
	ldd	[FP + 24], %f6; \
	ldd	[FP + 32], %f8; \
	ldd	[FP + 40], %f10; \
	ldd	[FP + 48], %f12; \
	ldd	[FP + 56], %f14; \
	ldd	[FP + 64], %f16; \
	ldd	[FP + 72], %f18; \
	ldd	[FP + 80], %f20; \
	ldd	[FP + 88], %f22; \
	ldd	[FP + 96], %f24; \
	ldd	[FP + 104], %f26; \
	ldd	[FP + 112], %f28; \
	ldd	[FP + 120], %f30; \
	ldd	[FP + 128], %f32; \
	ldd	[FP + 136], %f34; \
	ldd	[FP + 144], %f36; \
	ldd	[FP + 152], %f38; \
	ldd	[FP + 160], %f40; \
	ldd	[FP + 168], %f42; \
	ldd	[FP + 176], %f44; \
	ldd	[FP + 184], %f46; \
	ldd	[FP + 192], %f48; \
	ldd	[FP + 200], %f50; \
	ldd	[FP + 208], %f52; \
	ldd	[FP + 216], %f54; \
	ldd	[FP + 224], %f56; \
	ldd	[FP + 232], %f58; \
	ldd	[FP + 240], %f60; \
	ldd	[FP + 248], %f62;

#define	BLOAD_V8_FPREGS(FP, TEMP) \
	ldd	[FP], %f0; \
	ldd	[FP + 8], %f2; \
	ldd	[FP + 16], %f4; \
	ldd	[FP + 24], %f6; \
	ldd	[FP + 32], %f8; \
	ldd	[FP + 40], %f10; \
	ldd	[FP + 48], %f12; \
	ldd	[FP + 56], %f14; \
	ldd	[FP + 64], %f16; \
	ldd	[FP + 72], %f18; \
	ldd	[FP + 80], %f20; \
	ldd	[FP + 88], %f22; \
	ldd	[FP + 96], %f24; \
	ldd	[FP + 104], %f26; \
	ldd	[FP + 112], %f28; \
	ldd	[FP + 120], %f30;

#define	BLOAD_V8P_FPREGS(FP, TEMP) \
	ldd	[FP + 128], %f32; \
	ldd	[FP + 136], %f34; \
	ldd	[FP + 144], %f36; \
	ldd	[FP + 152], %f38; \
	ldd	[FP + 160], %f40; \
	ldd	[FP + 168], %f42; \
	ldd	[FP + 176], %f44; \
	ldd	[FP + 184], %f46; \
	ldd	[FP + 192], %f48; \
	ldd	[FP + 200], %f50; \
	ldd	[FP + 208], %f52; \
	ldd	[FP + 216], %f54; \
	ldd	[FP + 224], %f56; \
	ldd	[FP + 232], %f58; \
	ldd	[FP + 240], %f60; \
	ldd	[FP + 248], %f62;

#else

#define	BSTORE_FPREGS(FP, TEMP) \
	membar	#Sync; \
	stda	%d0, [FP]ASI_BLK_P; \
	add	FP, 64, TEMP; \
	stda	%d16, [TEMP]ASI_BLK_P; \
	add	FP, 128, TEMP; \
	stda	%d32, [TEMP]ASI_BLK_P; \
	add	FP, 192, TEMP; \
	stda	%d48, [TEMP]ASI_BLK_P; \
	membar	#Sync;

#define	BSTORE_V8_FPREGS(FP, TEMP) \
	membar	#Sync; \
	stda	%d0, [FP]ASI_BLK_P; \
	add	FP, 64, TEMP; \
	stda	%d16, [TEMP]ASI_BLK_P; \
	membar	#Sync;

#define	BSTORE_V8P_FPREGS(FP, TEMP) \
	membar	#Sync; \
	add	FP, 128, TEMP; \
	stda	%d32, [TEMP]ASI_BLK_P; \
	add	FP, 192, TEMP; \
	stda	%d48, [TEMP]ASI_BLK_P; \
	membar	#Sync;

#define	BLOAD_FPREGS(FP, TEMP) \
	membar	#Sync; \
	ldda	[FP]ASI_BLK_P, %d0; \
	add	FP, 64, TEMP; \
	ldda	[TEMP]ASI_BLK_P, %d16; \
	add	FP, 128, TEMP; \
	ldda	[TEMP]ASI_BLK_P, %d32; \
	add	FP, 192, TEMP; \
	ldda	[TEMP]ASI_BLK_P, %d48; \
	membar	#Sync;

#define	BLOAD_V8_FPREGS(FP, TEMP) \
	membar	#Sync; \
	ldda	[FP]ASI_BLK_P, %d0; \
	add	FP, 64, TEMP; \
	ldda	[TEMP]ASI_BLK_P, %d16; \
	membar	#Sync;

#define	BLOAD_V8P_FPREGS(FP, TEMP) \
	membar	#Sync; \
	add	FP, 128, TEMP; \
	ldda	[TEMP]ASI_BLK_P, %d32; \
	add	FP, 192, TEMP; \
	ldda	[TEMP]ASI_BLK_P, %d48; \
	membar	#Sync;

#endif /* STINGRAY */
#endif

#define	GSR_SIZE 8	/* Graphics Status Register size 64 bits */

#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_VIS_H */
