; ****************************************************************************
; cat386.s (Retro Unix 386 v1) - /bin/cat - concatenate files
; ----------------------------------------------------------------------------
;
; RETRO UNIX 386 (Retro Unix == Turkish Rational Unix)
; Operating System Project (v0.2) by ERDOGAN TAN (Beginning: 24/12/2013)
;
; Retro UNIX 8086 v1 - '/bin/cat' file
;
; Derived from 'Retro UNIX 8086 v1' source code by Erdogan Tan
; (v0.1 - Beginning: 11/07/2012)
;
; [ Last Modification: 28/12/2015 ]
;
; Derived from UNIX Operating System (v1.0 for PDP-11) 
; (Original) Source Code by Ken Thompson (Bell Laboratories, 1971-1972)
; ****************************************************************************
;
; cat386.s (17/10/2015, Retro UNIX 386 v1, NASM 2.11, 32 bit version)
; CAT2.ASM, 02/12/2013 - 16/07/2015 (Retro UNIX 8086 v1, MASM 6.11) 

; 17/10/2015

; UNIX v1 system calls
_rele 	equ 0
_exit 	equ 1
_fork 	equ 2
_read 	equ 3
_write	equ 4
_open	equ 5
_close 	equ 6
_wait 	equ 7
_creat 	equ 8
_link 	equ 9
_unlink	equ 10
_exec	equ 11
_chdir	equ 12
_time 	equ 13
_mkdir 	equ 14
_chmod	equ 15
_chown	equ 16
_break	equ 17
_stat	equ 18
_seek	equ 19
_tell 	equ 20
_mount	equ 21
_umount	equ 22
_setuid	equ 23
_getuid	equ 24
_stime	equ 25
_quit	equ 26	
_intr	equ 27
_fstat	equ 28
_emt 	equ 29
_mdate 	equ 30
_stty 	equ 31
_gtty	equ 32
_ilgins	equ 33
_sleep	equ 34 ; Retro UNIX 8086 v1 feature only !
_msg    equ 35 ; Retro UNIX 386 v1 feature only !

%macro sys 1-4
    ; 03/09/2015	
    ; 13/04/2015
    ; Retro UNIX 386 v1 system call.		
    %if %0 >= 2   
        mov ebx, %2
        %if %0 >= 3    
            mov ecx, %3
            %if %0 = 4
               mov edx, %4   
            %endif
        %endif
    %endif
    mov eax, %1
    int 30h	   
%endmacro

; Retro UNIX 386 v1 system call format:
; sys systemcall (eax) <arg1 (ebx)>, <arg2 (ecx)>, <arg3 (edx)>

[BITS 32] ; We need 32-bit intructions for protected mode

[ORG 0] 

START_CODE:
	;; / cat -- concatenate files

	sys	_write, 1, nl, 2

	pop	ebp
	pop	edx
	mov	esi, fin
        ;mov    edi, obuf
	;EAX = 2 (written byte count)
	xor	al, al ; 0
        dec     ebp
	jz	short cat_3
		;;mov	(sp)+,r5
		;;tst	(sp)+
		;;mov	$obuf,r2
		;;cmp	r5,$1
		;;beq	3f
cat_0:	
	pop	ebx
	cmp	byte [ebx], '-'
	je	short cat_2
		;;dec	r5
		;;ble	done
		;;mov	(sp)+,r0
		;;cmpb	(r0),$'-
		;;bne	2f
		;;clr	fin
		;;br	3f
cat_1:
	;;2:
	; ebx = file name offset
	xor 	ecx, ecx ; 0
	sys 	_open
	jc	short cat_7
cat_2:
	mov	[esi], ax
		;;mov	r0,0f
		;;sys	open; 0:..; 0
		;;bes	loop
		;;mov	r0,fin
cat_3:
	;;3:
        sys     _read, eax, iobuf, 512 ; 16/07/2015
	;sys 	_read, eax, ibuf, 512 
	jc	short cat_6
	; NOTE: If input file is a tty (keyboard)
	;	only 1 byte will be read, by ignoring
	;	byte count (512).
	;	Retro UNIX 8086 v1 kernel ('rtty')
	;	has been modified fot that.
	;       Erdogan Tan (16/07/2015)
	;
	and	eax, eax ; EAX = 1 for tty (keyboard)
	jz	short cat_6
;	push	esi
	;mov	esi, ibuf
;	mov	esi, ecx ; offset ibuf
;	mov	ecx, eax
		;;mov	fin,r0
		;;sys	read; ibuf; 512.
		;;bes	3f
		;;mov	r0,r4
		;;beq	3f
		;;mov	$ibuf,r3
	 ; 16/07/2015
;	mov	edx, eax
;	;add	edx, obuf
;cat_4:
;	;;4:
;	lodsb
	;call	putc
	; 16/07/2015
	sys 	_write, 1, iobuf, eax
	jc	short cat_6
	;
;	loop	cat_4
;	pop	esi
cat_5:
	mov	ax, [esi]
	jmp	short cat_3
		;;movb	(r3)+,r0
		;;jsr	pc,putc
		;;dec	r4
		;;bne	4b
		;;br	3b
cat_6:
	;;3:
	movzx	ebx, word [esi]
	or	ebx, ebx
	jz	short cat_7
	sys 	_close
		;;mov	fin,r0
		;;beq	loop
		;;sys	close
		;;br	loop
cat_7:	
	;;loop:
	dec	ebp
	;jz	short cat_8
	; 28/12/2015
	jg	short cat_0
	sys	_exit
here:
	nop
	jmp short here
	;;
;cat_8:
;	;;done:
;	sub	di, obuf
;	jz	short cat_9
;	sys	_write, 1, obuf, di 
		;;sub	$obuf,r2
		;;beq	1f
		;;mov	r2,0f
		;;mov	$1,r0
		;;sys	write; obuf; 0:..
;cat_9:	
;	;;1:
;	sys	_exit
		;;sys	exit
	;;
;putc:	
;	;;putc:
;	stosb
;	cmp	di, dx ; 16/07/2015
	;cmp	di, obuf + 512
;	jb	short cat_10
;	push	cx
	 ; 16/07/2015
;	mov	di, obuf
;	sub	dx, di ; byte (char) count
	; 
;	sys 	_write, 1, obuf
	;sys 	_write, 1, obuf, 512
	;mov	di, obuf
		;;movb	r0,(r2)+
		;;cmp	r2,$obuf+512.
		;;blo	1f
		;;mov	$1,r0
		;;sys	write; obuf; 512.
		;;mov	$obuf,r2
;	pop	cx
;cat_10:	
	;;1:
;	retn
		;;rts	pc

nl:	db 0Dh, 0Ah, 0

align 4

bss_start:

ABSOLUTE bss_start

iobuf:  resb 512
;ibuf:	resb 512
;obuf:	resb 512
fin:	resw 1
		;;.bss
		;;ibuf:	.=.+512.
		;;obuf:	.=.+512.
		;;fin:	.=.+2
		;;.text
;bss_end: