#
# NAME:
#
#   	svcinstall.sh installs all the TrueType fonts
#
# SYNOPSIS:	
#
#	svcinstall.sh NeXT_root_directory major_version minor_version 
#				Windows_root_directory
#
#
# DESCRIPTION:
#
#	svcinstall.sh is a Bourne shell script used to 
#	install the machd and nmserver services into the registry.
#
#  EXAMPLES:
#
#	>svcinstall.sh $(NEXT_ROOT) 4 0 $(WINDIR)
#

# Check arguments 
if test $# -lt 1
then
	echo "svcinstall.sh : usage";
	echo "      svcinstall.sh NeXT_root_directory";
	echo "      		  major_version";
	echo "      		  minor_version";
	echo "     		  Windows_root_directory";
	exit 1
fi
echo "Number of parameters okay"

PATH=$1/NextLibrary/Executables\;$PATH
export PATH
echo $PATH

MACHD_EXE=$1/NextLibrary/System/machd.exe
NMSERVER_EXE=$1/NextLibrary/System/nmserver.exe

#sleep 2
# Check Next root directory
if test ! -d $1
then
	echo "svcinstall : invalid NeXT root directory" $1
	exit 1
fi
echo "Next Root okay"

# Makesure that the executables exist before installing
if test ! -f $MACHD_EXE
then
	echo "svcinstall : Can't find machd.exe" $1
	exit 1
fi
echo "machd okay"

if test ! -f $NMSERVER_EXE
then
	echo "svcinstall : Can't find nmserver.exe" $1
	exit 1
fi
echo "nmserver okay"


$MACHD_EXE -install
$NMSERVER_EXE -install

