#
# NAME:
#
#   	truetype_font_install installs all the TrueType fonts
#
# SYNOPSIS:	
#
#	truetype_font_install NeXT_root_directory major_version minor_version 
#				Windows_root_directory
#
#
# DESCRIPTION:
#
#	truetype_font_install is a Bourne shell script used to 
#	convert all the .ttf font files in the window root directory 
#	and places the resultant .font files in the next root directory
#
#  EXAMPLES:
#
#	>truetype_font_install $(NEXT_ROOT) 4 0 $(WINDIR)
#
WINFONTDIR=""
NEXTFONTDIR=""

# Check argumens 
case $# in
	4 )
		;;
	* )
		echo "truetype_font_install : usage";
		echo "      truetype_font_install NeXT_root_directory";
		echo "      			  major_version";
		echo "      			  minor_version";
		echo "     		          Windows_root_directory";;
esac
echo "Number of parameters okay"
PATH=$1/NextLibrary/Executables\;$PATH
export PATH
echo $PATH
#sleep 2
# Check Next root directory
if test ! -d $1
then
	echo "truetype_font_install : invalid NeXT root directory" $1
#sleep 10
	exit 1
fi
echo "Next Root okay"
#sleep 10

# Check window root directory
if test ! -d $4
then
	echo "truetype_font_install : invalid Windows root directory" $4
#sleep 10
	exit 1
fi

echo "window root okay"
# Make Windows and next font directory based on major revision number 
case $2 in
	*"4")
		NEXTFONTDIR=$1"/NextLibrary/Fonts";
		WINFONTDIR=$4"/Fonts";;
	*"3")
		NEXTFONTDIR=$1"/NextLibrary/Fonts";
		WINFONTDIR=$4"/system";;
	* )
		echo "truetype_font_install : incorrect major version";;
esac
#sleep 10
echo "got the windoews font okay"

# Test existance of window font directory
if test ! -d $WINFONTDIR
then
	echo "truetype_font_install : invalid Windows font directory" $WINFONTDIR
#sleep 10
	exit 1
fi
echo "the windoews font directory okay"
if test ! -d $NEXTFONTDIR
then
	echo "truetype_font_install : invalid NeXt font directory" $NEXTFONTDIR
#sleep 10
	exit 1
fi
echo "the next font directory okay"

echo "truetype_font_install : installing True Type fonts"

for file in $WINFONTDIR/*.ttf $WINFONTDIR/*.TTF
do
	if test -f $file
	then
		ttf2font -o $NEXTFONTDIR -q $file
	fi
done
#sleep 10
