/* ni_propval.c */

#define MAINDEF 1

/* Originally from conf.c of sendmail.8.6.9 distribution */

#define LOCAL_NETINFO_DOMAIN    "."
#define PARENT_NETINFO_DOMAIN   ".."
#define DEF_PORT_NUMBER		9100


/*
**  NI_PROPVAL -- netinfo property value lookup routine
**
**	Parameters:
**		directory -- the Netinfo directory name.
**		propname -- the Netinfo property name.
**
**	Returns:
**		NULL -- if:
**			1. the directory is not found
**			2. the property name is not found
**			3. the property contains multiple values
**			4. some error occured
**		else -- the location of the config file.
**
**	Notes:
**      	Caller should free the return value of ni_proval
*/

#include <netinfo/ni.h>
#include <stdlib.h>
#include <stdio.h>

#define LOCAL_NETINFO_DOMAIN    "."
#define PARENT_NETINFO_DOMAIN   ".."
#define MAX_NI_LEVELS           256

char *ni_propval(char *directory, char *propname)
{
	char *propval = NULL;
	int i;
	void *ni = NULL;
	void *lastni = NULL;
	ni_status nis;
	ni_id nid;
	ni_namelist ninl;

	/*
	**  If the passed directory and property name are found
	**  in one of netinfo domains we need to search (starting
	**  from the local domain moving all the way back to the
	**  root domain) set propval to the property's value
	**  and return it.
	*/

	for (i = 0; i < MAX_NI_LEVELS; ++i)
	{
		if (i == 0)
		{
			nis = ni_open(NULL, LOCAL_NETINFO_DOMAIN, &ni);
		}
		else
		{
			if (lastni != NULL)
				ni_free(lastni);
			lastni = ni;
			nis = ni_open(lastni, PARENT_NETINFO_DOMAIN, &ni);
		}

		/*
		**  Don't bother if we didn't get a handle on a
		**  proper domain.  This is not necessarily an error.
		**  We would get a positive ni_status if, for instance
		**  we never found the directory or property and tried
		**  to open the parent of the root domain!
		*/

		if (nis != 0)
			break;

		/*
		**  Find the path to the server information.
		*/

		if (ni_pathsearch(ni, &nid, directory) != 0)
			continue;

		/*
		**  Find "host" information.
		*/

		if (ni_lookupprop(ni, &nid, propname, &ninl) != 0)
			continue;

		/*
		**  If there's only one name in
		**  the list, assume we've got
		**  what we want.
		*/

		if (ninl.ni_namelist_len == 1)
		{
			propval = ni_name_dup(ninl.ni_namelist_val[0]);
			break;
		}
	}

	/*
	**  Clean up.
	*/

	if (ni != NULL)
		ni_free(ni);
	if (lastni != NULL && ni != lastni)
		ni_free(lastni);

	return propval;
}

char *ni_printer_config(char *printer_name, char *hostname, int *port)
{
    extern char *ni_propval();
    char nipathbuf[256];
    char *portptr;

    sprintf(nipathbuf, "/printers/%s/Comm", printer_name);
    hostname = ni_propval(nipathbuf, "HostName");
    portptr = ni_propval(nipathbuf, "PortNumber");
    if(portptr)
	*port = atoi(portptr);
    else
	*port = DEF_PORT_NUMBER;
    return hostname;
}


#ifdef MAINDEF

void main(void)
{
char hostname[64], *pp;
int port;

	pp = ni_printer_config("hp_DJ1200", hostname, &port);
	if(pp) strcpy(hostname, pp);
	else   strcpy(hostname, "none");
	printf("hp_DJ1200 is host: %s, and port #: %d\n", hostname, port);



}



#endif

