#define MEMDEV 0
#define DISK1 1
#define DISK2 2
#define DISK3 3
#define DISK4 4
#define DISK5 5
#define DISK6 6
#define DISK7 7
#define DISK8 8
#define DISK9 9
#define PDISK1 10
#define PDISK2 11
#define PDISK3 12
#define PDISK4 13
#define PDISK5 14
#define PDISK6 15
#define PDISK7 16
#define PDISK8 17
#define PDISK9 18

#define CONDEV 20
#define SERPOR1 21
#define SERPOR2	22
#define LPT1	50
#define LPT2	51
#define LPT3	52

#define DSIDEV 129
#define EXITDEV 255

#define ReadTY 'R'
#define WritTY 'W'
#define InitTY 'I'
#define ProcTY 'P'
#define CompTY 'C'

struct PB {
    char rt;
    unsigned char id;
    unsigned long src,dst,cnt,dt1;
    unsigned short int dt2;
};

static struct PBQ {
    struct PB pb;
    struct PBQ *next;
};

#define NUMSER 2
#define SERBUF 256

struct BUGFIX {
/* Note: This structure is required due to a bug in Aztec C.
*/

    UWORD   cd:1,	/* Carrier Detect */
	    ri:1,	/* Ring Indicator */
	    dsr:1,	/* Data Set Ready */
	    cts:1,	/* Clear to Send */
	    drlsd:1,	/* Delta Rx Line Signal Detect (CD) */
	    teri:1,	/* Trailing Edge Ring Indicate */
	    ddsr:1,	/* Delta Data Set Ready */
	    dcts:1,	/* Delta Clear to Send */

	    xx:1,	/* always zero */
	    tsre:1,	/* TX shift register empty */
	    thre:1,	/* TX holding register empty */
	    bi:1,	/* BREAK interrupt */
	    fe:1,	/* Framing error */
	    pe:1,	/* Parity error */
	    ore:1,	/* Overrun error */
	    dr:1;	/* Data available (should always be zero) */
};

struct SERIAL {
    int baud;
    UWORD   dlab:1,	/* Divisor latch bit. Should be zero */
	    brk:1,	/* Break bit. 1 to enable send of break */
	    stkpar:1,	/* 'sticky' parity bit. 1 is force parity */
	    eps:1,	/* Even parity enable. 1 to set even parity */
	    pen:1,	/* Parity enable. 1 to enable parity */
	    stb:1,	/* number of stop bits. 0 is one, 1 is two */
	    wlsb:2,	/* word length. 0 = 5, 1 = 6, 2 = 7, 3 = 8 bits */

	    xx1:1,xx2:1,xx3:1,	/* Unused, always zero */
	    loop:1,		/* Loopback mode enabled */
	    xx4:1,xx5:1,	/* out2 and out1 bits, out2 forced to 1 */
	    rts:1,		/* Request to send */
	    dtr:1;		/* Data Terminal Ready */
    union { 
	UWORD errbyte;
	struct BUGFIX errbit;
    } status; 

    int icnt,ocnt;
    int headi,heado;
    int taili,tailo;
    char ibuf[SERBUF],obuf[SERBUF];
} Serial[NUMSER];

    
    
