;
;
;Serial Port driver routine
;Dave Rand
;72 Longfellow St.
;Thousand Oaks, CA  91360
;805-493-1987
;
;Note that if struct Serial in UNIXDEV.H is changed, code in here MUST be
;changed as well, or horrible things will happen.
;It currently looks like this:
;#define NUMSER 2
;#define SERBUF 256

;struct BUGFIX {
;/* Note: This structure is required due to a bug in Aztec C.
;*/
;
;    UWORD   cd:1,	/* Carrier Detect */
;	    ri:1,	/* Ring Indicator */
;	    dsr:1,	/* Data Set Ready */
;	    cts:1,	/* Clear to Send */
;	    drlsd:1,	/* Delta Rx Line Signal Detect (CD) */
;	    teri:1,	/* Trailing Edge Ring Indicate */
;	    ddsr:1,	/* Delta Data Set Ready */
;	    dcts:1,	/* Delta Clear to Send */
;
;	    xx:1,	/* always zero */
;	    tsre:1,	/* TX shift register empty */
;	    thre:1,	/* TX holding register empty */
;	    bi:1,	/* BREAK interrupt */
;	    fe:1,	/* Framing error */
;	    pe:1,	/* Parity error */
;	    ore:1,	/* Overrun error */
;	    dr:1;	/* Data available (should always be zero) */
;};
;
;struct SERIAL {
;    int baud;
;    UWORD   dlab:1,	/* Divisor latch bit. Should be zero */
;	    brk:1,	/* Break bit. 1 to enable send of break */
;	    stkpar:1,	/* 'sticky' parity bit. 1 is force parity */
;	    eps:1,	/* Even parity enable. 1 to set even parity */
;	    pen:1,	/* Parity enable. 1 to enable parity */
;	    stb:1,	/* number of stop bits. 0 is one, 1 is two */
;	    wlsb:2,	/* word length. 0 = 5, 1 = 6, 2 = 7, 3 = 8 bits */
;
;	    xx1:1,xx2:1,xx3:1,	/* Unused, always zero */
;	    loop:1,		/* Loopback mode enabled */
;	    xx4:1,xx5:1,	/* out2 and out1 bits, out2 forced to 1 */
;	    rts:1,		/* Request to send */
;	    dtr:1;		/* Data Terminal Ready */
;    union { 
;	UWORD errbyte;
;	struct BUGFIX errbit;
;    } status; 
;
;    int icnt,ocnt;
;    int headi,heado;
;    int taili,tailo;
;    char ibuf[SERBUF],obuf[SERBUF];
;} Serial[NUMSER];

	SERBUF	equ	256
    
	PORT0	equ	03f8h		;Primary adapter address
	PORT0i	equ	04		;Primary adapter interrupt number
	PORT1	equ	02f8h		;Alternate adapter address
	PORT1i	equ	03		;Alternate adapter interrupt number

dataseg	segment public word 'data'
isave1	db	4 dup (0)	;Interrupt save 1
isave0	db	4 dup (0)	;Interrupt save 0
ssave1	dw	0		;offset of struct serial[1]
	dw	0		;spacer
ssave0	dw	0		;offset of struct serial[0]
imask	db	0		;Mask register
dataseg	ends


codeseg	segment public word 'code'
	assume	cs:codeseg,ds:dataseg,es:dataseg

dsval	dw	0

	public	DoSerInit_,DoSerOut_,DoSerUn

DoSerInit_	proc	near
	push	bp
	mov	bp,sp
	push	si
	push	di			;set up environment
	mov	dsval,ds		;save our current DS
	mov	si,4[bp]		;get pointer to serial structure
	mov	bx,6[bp]		;get port number
	or	bx,bx			;is this the primary adapter
	mov	di,PORT0		;assume so
	jz	init1			;it is
	mov	di,PORT1		;it is the alternate adapter
init1:	shl	bx,1			;multiply port number by 4
	shl	bx,1			;so we can use as a pointer
	cmp	word ptr isave0[bx],0	;is this port initialized already?
	jnz	initok			;yes, go ahead
	cli				;no interrupts for a bit
	push	es			;save extra segment
	xor	ax,ax			;address segment zero
	mov	es,ax
	neg	bx			;for this code, we negate bx
	mov	ssave0[bx],si		;save address of struct serial
	mov	ax,es:30h[bx]		;get offset of existing interrupt
	mov	word ptr isave0[bx],ax	;save in temp storage
	mov	ax,es:32h[bx]		;get segment of interrupt
	mov	word ptr isave0[bx+2],ax;save in temp storage
	mov	es:32h[bx],cs		;save codeseg value
	or	bx,bx			;are we doing port 0?
	mov	ax,offset intsv0	;port zero service routine
	mov	cl,0efh			;mask for interrupt 4
	jz	init2			;yes, this is it
	mov	ax,offset intsv1	;port 1 service routine
	mov	cl,0f7h			;mask for interrupt 3
init2:	mov	es:30h[bx],ax		;save interrupt service address
	in	al,21h			;read current interrupt mask
	cmp	imask,0			;is imask zero?
	jnz	init3			;no, already been here
	mov	imask,al		;else save old imask
init3:	and	al,cl			;mask off appropriate interrupt
	out	21h,al			;send out mask
	pop	es
	sti				;interrupts OK now
initok:	xor	al,al			;disable interrupts for a while
	lea	dx,1[di]		;point to Interrupt Enable Register
	out	dx,al
	mov	al,3[si]		;get line control register value
	or	al,128			;set dlab
	lea	dx,3[di]		;point to lcr port
	out	dx,al			;we now are set up to output baud
	mov	dx,di			;point to LSB of divisor
	mov	al,0[si]		;get first part of baud rate
	out	dx,al			;send it out
	inc	dx			;point to MSB of divisor
	mov	al,1[si]		;get second part of baud rate
	out	dx,al			;send it out
	mov	al,3[si]		;get back lcr values
	and	al,127			;mask off dlab
	lea	dx,3[di]		;point to lcr
	out	dx,al			;and send it out
	mov	al,2[si]		;get Modem Control Register values
	or	al,8			;set OUT2 to enable interrupts
	inc	dx			;point to MCR
	out	dx,al			;and send it out
	inc	dx			;point to Line Status Register
	in	al,dx			;get LSR
	mov	5[si],al		;save in structure
	inc	dx			;point to Modem Status Register
	in	al,dx			;read MSR
	or	al,8			;indicate DRSLD to cause transfer
	mov	4[si],al		;save in structure
	xor	ax,ax			;prepare to zero bytes in structure
	mov	6[si],ax		;icnt
	mov	8[si],ax		;ocnt
	mov	10[si],ax		;headi
	mov	12[si],ax		;heado
	mov	14[si],ax		;taili
	mov	16[si],ax		;tailo
	mov	al,0dh			;set interrupts to DAV, RLSI & MSI
	lea	dx,1[di]		;point to IER
	out	dx,al			;and interrupts on
	pop	di
	pop	si			;restore the world
	pop	bp
	ret
DoSerInit_	endp

DoSerOut_	proc	near
	push	bp
	mov	bp,sp
	push	si
	push	di			;set up environment
	mov	si,4[bp]		;get pointer to serial structure
	mov	bx,6[bp]		;get port number
	or	bx,bx			;is this the primary adapter
	mov	di,PORT0		;assume so
	jz	out1			;it is
	mov	di,PORT1		;it is the alternate adapter
out1:	lea	dx,5[di]		;point to LSR
	in	al,dx			;get the data
	test	al,20h			;is holding register empty?
	jz	outx			;no, exit now
	dec	word ptr 8[si]		;ocnt --
	mov	bx,16[si]		;get tailo
	mov	al,SERBUF[18+bx+si]	;get data byte
	mov	dx,di			;point to port
	out	dx,al			;send it out
	inc	bx			;next byte
	cmp	bx,SERBUF		;are we bigger than buffer?
	jb	out2			;no, continue
	xor	bx,bx			;else restart from zero
out2:	mov	16[si],bx		;save back tailo
outx:	pop	di
	pop	si
	pop	bp
	ret
DoSerOut_	endp

DoSerUn	proc	near
	push	si
	push	di
	cli
	push	es
	xor	ax,ax
	mov	es,ax
	mov	si,offset isave1		;point to save area
	mov	di,2ch				;point to interrupt location
	lodsw					;get save stuff
	mov	bx,ax				;save offset
	lodsw					;get segment
	or	ax,ax				;if it is zero
	jz	un1				;we didn't inititialize
	mov	es:[di],bx			;else put back what we took
	mov	es:2[di],ax
	xor	al,al
	mov	dx,PORT1 + 1			;zap interrupts
	out	dx,al
un1:	add	di,4				;point to next location
	lodsw					;get save stuff
	mov	bx,ax				;save offset
	lodsw					;get segment
	or	ax,ax				;if it is zero
	jz	unx				;we didn't inititialize
	mov	es:[di],bx			;else put back what we took
	mov	es:2[di],ax
	xor	al,al
	mov	dx,PORT0 + 1			;zap interrupts
	out	dx,al
unx:	mov	al,imask			;if this is non-zero
	or	al,al
	jz	unx1				;no initialize. skip it
	out	21h,al				;else reset 8259
unx1:	pop	es
	sti
	pop	di
	pop	si
	ret
DoSerUn	endp

intsv0	proc	far
	push	ds		;save current ds
	mov	ds,dsval	;address current DS
	push	si
	push	dx
	push	ax		;save registers we need
	mov	si,ssave0	;point to struct serial
intsv0l:
	mov	dx,PORT0 + 2	;point to Interrupt Identification Register
	in	al,dx		;read port
	test	al,1		;did interrupt happen?
	jnz	intsv0x		;no, exit now
	cmp	al,6		;RLS interrupt?
	jz	intsv01		;yes, go
	cmp	al,4		;RDAVAIL interrupt?
	jz	intsv02		;yes, go
	or	al,al		;MODEM STATUS interrupt
	jnz	intsv0x		;no, exit now
	mov	dx,PORT0 + 6	;point to MSR
	in	al,dx		;read it
	mov	4[si],al	;save it in structure
	jmp	intsv0l		;back for more

intsv01:mov	dx,PORT0 + 5	;point to LSR
	in	al,dx		;read it
	mov	5[si],al	;save it in structure
	jmp	intsv0l		;back for more

intsv02:mov	dx,PORT0	;point to data port
	in	al,dx		;read the data
	cmp	word ptr 6[si],SERBUF	;are we over max? (icnt)
	jae	intsv0l		;yes, back for more
	push	bx		;save a temp register
	inc	word ptr 6[si]	;icnt++
	mov	bx,14[si]	;read taili
	mov	18[bx+si],al	;save in input buffer
	inc	bx		;taili++
	cmp	bx,SERBUF	;are we over end
	jb	intsv02a	;no, continue
	xor	bx,bx		;else start at begin
intsv02a:mov	14[si],bx	;save taili
	pop	bx
	jmp	intsv0l		;back for more

intsv0x:mov	al,20h		;non-specific EOI
	out	20h,al
	pop	ax
	pop	dx
	pop	si
	pop	ds		;restore environment
	sti			;interrupts on
	iret			;back from interrupt
intsv0	endp

intsv1	proc	far
	push	ds		;save current ds
	mov	ds,dsval	;address current DS
	push	si
	push	dx
	push	ax		;save registers we need
	mov	si,ssave1	;point to struct serial
intsv1l:
	mov	dx,PORT1 + 2	;point to Interrupt Identification Register
	in	al,dx		;read port
	test	al,1		;did interrupt happen?
	jnz	intsv1x		;no, exit now
	cmp	al,6		;RLS interrupt?
	jz	intsv11		;yes, go
	cmp	al,4		;RDAVAIL interrupt?
	jz	intsv12		;yes, go
	or	al,al		;MODEM STATUS interrupt
	jnz	intsv1x		;no, exit now
	mov	dx,PORT1 + 6	;point to MSR
	in	al,dx		;read it
	mov	4[si],al	;save it in structure
	jmp	intsv1l		;back for more

intsv11:mov	dx,PORT1 + 5	;point to LSR
	in	al,dx		;read it
	mov	5[si],al	;save it in structure
	jmp	intsv1l		;back for more

intsv12:mov	dx,PORT1	;point to data port
	in	al,dx		;read the data
	cmp	word ptr 6[si],SERBUF	;are we over max? (icnt)
	jae	intsv1l		;yes, back for more
	push	bx		;save a temp register
	inc	word ptr 6[si]	;icnt++
	mov	bx,14[si]	;read taili
	mov	18[bx+si],al	;save in input buffer
	inc	bx		;taili++
	cmp	bx,SERBUF	;are we over end
	jb	intsv12a	;no, continue
	xor	bx,bx		;else start at begin
intsv12a:mov	14[si],bx	;save taili
	pop	bx
	jmp	intsv1l		;back for more

intsv1x:mov	al,20h		;non-specific EOI
	out	20h,al
	pop	ax
	pop	dx
	pop	si
	pop	ds		;restore environment
	sti			;interrupts on
	iret			;back from interrupt
intsv1	endp

codeseg	ends
	end

