#include <stdio.h>
#include <ctype.h>
/*
    Dave Rand
    72 Longfellow St
    Thousand Oaks, CA  91360
    805-493-1987
    
    Version 0.9  Thu Jul 17 19:07:54 1986
    
    This program does a full read of a disk, and creates a file from it.
    
*/

main(argc,argv)
int argc;
char **argv;
{
    int drive = 0;
    int fo,creat();
    int cyl,head,sector,nsec,maxc,maxs;
    char *buf,*malloc();
   
    if (argc < 2) {
	printf("Usage: RDFLOP filename [drive]");
	exit(1);
    }
    if (argc > 2)
	sscanf(argv[2],"%d",&drive);
	
    if (drive < 0 || drive > 3) {
	printf("Invalid drive supplied: %d",drive);
	exit(1);
    }
    
    if ((buf = malloc(15 * 512)) == NULL) {
	printf("Can't get memory.");
	exit(1);
    }
    if (phgetp(drive,&nsec)) {
	printf("Can't figure out disk.");
	exit(1);
    }
    if ((fo = creat(argv[1],0644)) == -1) {
	printf("Can't create file %s",argv[1]);
	exit(1);
    }
    maxc = (nsec == 9) ? 40 : 80;
    maxs = nsec;
    for (cyl=0; cyl < maxc; cyl++) {
	for (head=0; head<2; head++) {
/*   for (sector=1; sector <= nsec; sector++) { */

		if (phread(drive,cyl,head,1,nsec,buf)) {
		    printf("Read failed.");
		    exit(1);
		}
		write(fo,buf,512*nsec);
/*   } */
	}
    }
    close(fo);
    exit(0);
}
    


    
phread(drive,cyl,head,sector,nsec,buf)
int drive,cyl,head,sector,nsec;
char *buf;
{
    int ret=1,retry;
    sector |= (cyl >> 2) & 0xc0;	/* Convert big cylinders */
top:
    for (retry=0; retry < 10 && ret; retry++) {
#asm
	mov	dl,4[bp]	;drive number
	mov	ch,6[bp]	;cylinder number
	mov	dh,8[bp]	;head number
	mov	cl,10[bp]	;sector number
    	mov	al,12[bp]	;read xx sectors
	mov	ah,02h		;read data
	mov	bx,14[bp]	;get buffer address
	int	13h		;do the i/o
	jc	error		;did we error?
	xor	ax,ax		;no, zero return
error:	mov	-2[bp],ax	;store error return
	jnc	err1		;if no error, just return
	mov	ah,0		;do a drive reset
	int	13h
	mov	bl,12[bp]	;get EOT value
	cmp	bl,8		;is it bigger than 8?
	jc	err1		;no, skip it
	push	ds		;save our ds for a second
	push	si		;and si
	xor	ax,ax		;point to zero segment
	mov	ds,ax
	lds	si,dword ptr [78h]	;get the stuff at 78
	mov	4[si],bl	;stuff new EOT in
	pop	si
	pop	ds

err1:
#endasm
    }
    if (ret) {
	printf("\nRead error: Cyl %d, hd %d, sec %d. Retry? ",cyl,head,sector);
	if ((ret=toupper(bdos(1,0)))=='Y')
	    goto top;
	if (ret == 'I')
	    ret = 0;
    }
    return(ret);
}

phwrite(drive,cyl,head,sector,nsec,buf)
int drive,cyl,head,sector,nsec;
char *buf;
{
    int ret=1,retry;
    sector |= (cyl >> 2) & 0xc0;	/* Convert big cylinders */
    for (retry=0; retry < 10 && ret; retry++) {
#asm
	mov	dl,4[bp]	;drive number
	mov	ch,6[bp]	;cylinder number
	mov	dh,8[bp]	;head number
	mov	cl,10[bp]	;sector number
    	mov	al,12[bp]	;write xx sectors
	mov	ah,03h		;write one sector
	mov	bx,14[bp]	;get buffer address
	int	13h		;do the i/o
	jc	errorw		;did we error?
	xor	ax,ax		;no, zero return
errorw:	mov	-2[bp],ax	;store error return
	jnc	errw1		;no error
	mov	ah,0		;do a drive reset
	int	13h
	mov	bl,12[bp]	;get EOT value
	cmp	bl,8		;is it bigger than 8?
	jc	errw1		;no, skip it
	push	ds		;save our ds for a second
	push	si		;and si
	xor	ax,ax		;point to zero segment
	mov	ds,ax
	lds	si,dword ptr [78h]	;get the stuff at 78
	mov	4[si],bl	;stuff new EOT in
	pop	si
	pop	ds

errw1:
#endasm
    }
    return(ret);
}

phgetp(drive,spt)
int drive,*spt;
{
    char temp[512];
    int retry=0;
    
    do {
	if (phread(drive,0,0,1,1,temp) == 0) {
	    if (phread(drive,0,1,15,1,temp) == 0) 
		*spt = 15;
	    else
		*spt = 9;
	    return(0);		/* We found it... */
	}
#asm
    mov	dl,4[bp]		;get drive number
    xor	ax,ax			;do a reset command
    int	13h
#endasm
    } while (retry++ < 3);
    *spt = 1;			/* Unknown format/unreadable */
return(-1);
}
