#include <stdio.h>
#include <portab.h>
#include <time.h>

/* 
    Dave Rand
    72 Longfellow St.
    Thousand Oaks, CA  91360
    805-493-1987
    
    Version 1.3  Tue Jul  8 13:10:10 1986
    
    This module does the channel 129 emulation. It is not asynchronous,
    since the original interface was not.
*/


struct IOREQ {
    char rt;
    unsigned char id;
    ULONG r0,r1,r2,r3;
    UWORD ex;
} RETURN;

static Rawmode = FALSE;

dodsi(REQ)
struct IOREQ *REQ;
{
    char fname1[80],fname2[80],*tq1;
    UWORD tq,myalloc();
    ULONG lseek(),temp,arg[4];
    int ret,x;
    extern UWORD _dsval;
    struct tm curtime;
	
    ret = 0;

#ifdef DEBUG
printf("DSIREQ #%d, r1=%lx, r2=%lx, r3=%lx\n",(UWORD)(REQ->r0),REQ->r1,
	REQ->r2,REQ->r3);
#endif
    switch((UWORD)(REQ->r0)) {
	
	case 1:
	    REQ->r0 = (ULONG)bdos((UWORD)REQ->r1,(UWORD)REQ->r2);
	    break;
	
	case 5:
	    getdat(REQ->r1,fname1,80);
	    REQ->r0 = open(fname1,(UWORD)REQ->r2 & 0x3);
	    break;
	
	case 6:
	    REQ->r0 = close((UWORD)REQ->r1);
	    break;
	    
	case 7:
	    getdat(REQ->r1,fname1,80);
	    REQ->r0 = creat(fname1);
	    break;
	
	case 8:
	    tq = myalloc((UWORD)REQ->r3);
    	    REQ->r0 = read((UWORD)REQ->r1,tq,(UWORD)REQ->r3);
	    putdat(tq,REQ->r2,(UWORD)REQ->r3);
	    free(tq);
	    break;
	    
	case 9:
	    tq = myalloc((UWORD)REQ->r3);
	    getdat(REQ->r2,tq,(UWORD)REQ->r3);
	    if (Rawmode && (UWORD)REQ->r1 == 1) {
		x = REQ->r3;
		tq1 = (char *)tq;
		while (x--)
		    bdos(6,*tq1++);
		REQ->r0 = REQ->r3;
	    } else
		REQ->r0 = write((UWORD)REQ->r1,tq,(UWORD)REQ->r3);
	    free(tq);
	    break;
	    
	case 10:
	    getdat(REQ->r1,fname1,80);
	    REQ->r0 = unlink(fname1);
	    break;
	
	case 11:
	    getdat(REQ->r1,fname1,80);
	    getdat(REQ->r2,fname2,80);
	    REQ->r0 = rename(fname1,fname2);
	    break;
	
	case 12:
	    REQ->r0 = lseek((UWORD)REQ->r1,REQ->r2,(UWORD)REQ->r3);
	    break;
	    
	case 13:
	    REQ->r0 = lseek((UWORD)REQ->r1,0L,1);
	    break;
	    
	case 14:
	    arg[0] = 1L;
	    arg[1] = REQ->r2 + 8L;
	    arg[2] = 0L;
	    putdat(arg,REQ->r2,12);
	    break;
	    
	case 15:
	    ret = 1;
	    break;
	    
	case 16:
	case 17:
	case 18:
	case 19:
	    abort("Memory/memory move?");
	    break;
	    
	case 20:
	    REQ->r0 = INPUT((UWORD)REQ->r1);
	    break;
	    
	case 21:
	    OUTPUT((UWORD)REQ->r1,(UWORD)REQ->r2);
	    break;
	    
	case 23:
	    temp = _dsval;
	    temp <= 16;
	    REQ->r0 = (temp | myalloc((UWORD)REQ->r1));
	    break;
	    
	case 24:
	    REQ->r0 = free((UWORD)REQ->r1);
	    break;
	
	case 25:
	    abort("Do 8086 interrupt?");
	    
	case 27:
	    dostime(&curtime);
	    putdat(&curtime,REQ->r1,sizeof(curtime));
	    break;
	    
	case 28:
	    abort("Get environment?");
	
	case 29:
	    tq = myalloc(256);
	    getdat(REQ->r1,tq,256);	/* Get command line */
	    REQ->r0 = system(tq);	/* Do it */
	    free(tq);
	    break;
	    
	case 31:
	    Rawmode = TRUE;	/* Set to raw i/o */
/*
	    signal(1,1); /* Disable control C */
	    break;
	    
	
	default:
	    abort("Sorry, we can't emulate function %d.",REQ->r0);
	    
    }
    return(ret);
}

	   
UWORD myalloc(len)
int len;
{
    UWORD malloc(),t;
    
    if ((t = malloc(len)) == 0)
	abort("Can't allocate memory for %d bytes.",len);
    
    return(t);
}

    
