
	;
	; Original code bye:	Bob Smith	May 1985
	;			Qualitas, Inc.
	;			8314 Thoreau Dr.
	;			Bethesda MD  20817
	;
	;As printed in  April 1986 PC Tech Journal
	;
ARG_STR	struc
ARG_BP	dw	?	;Caller's BP
ARG_OFF	dw	?	;Caller's offset
ARG_SEG	dw	?	;	  segment
ARG_FLG	dw	?	;	  flags
ARG_STR	ends

;Record to define bits in CPU and NDP flag registers

CPUFLAGS record	R0:1,NT:1,IOPL:1,OF:1,DF:1,IntF:1,TF:1,SF:1,ZF:1,R1:1,AF:1,R2:1,PF:1,R3:1,CF:1

NDPFLAGS record	R4:3,IC:1,RC:2,PC:2,IEM:1,R5:1,PM:1,UM:1,OM:1,ZM:1,DM:1,IM:1

FLG	record	RSVD:9,FLG_NERR:1,FLG_CERR:1,FLG_NDP:2,FLG_CPU:3

;CPU related flags
FLG_PIQL	equ	001b shl FLG_CPU	;Pre-fetch q length
FLG_08		equ	000b shl FLG_CPU	;Intel 808x
FLG_NEC		equ	010b shl FLG_CPU	;NEC V20 or V30
FLG_18		equ	100b shl FLG_CPU	;Intel 8018x
FLG_28		equ	110b shl FLG_CPU	;Intel 8028x

FLG_8088	equ	FLG_08
FLG_8086	equ	FLG_08 or FLG_PIQL
FLG_V20		equ	FLG_NEC
FLG_V30		equ	FLG_NEC or FLG_PIQL
FLG_80188	equ	FLG_18
FLG_80186	equ	FLG_18 or FLG_PIQL
FLG_80286	equ	FLG_28 or FLG_PIQL

;NDP related flags
;			00b shl FLG_NDP
FLG_87		equ	01b shl FLG_NDP
FLG_287		equ	10b shl FLG_NDP

BEL	equ	7
LF	equ	10
CR	equ	13
EOS	equ	'$'

POPFF	macro
	local	L1,L2
	jmp	short L2	; Skip over IRET
L1:
	iret			; Pop the CS and IP pushed below along
				; with the flags - original purpose
L2:
	push	cs		; Prep. for the IRET by pushing CS
	call	L1		; Push IP jmp to IRET
	endm			; end of POPFF macro



I11_REC	record	I11_PRN:2,I11_RSV1:2,I22_COMM:3,I11_RSV2:1,I11_DISK:2,I11_VID:2,I11_RSV3:2,I11_NDP:1,I11_IPL:1

dataseg	segment byte public 'data'
	assume	ds:dataseg

OLDINT01_VEC	label dword	; Save area for orginal INT 01 handler
OLDINT01_OFF	dw	?
OLDINT01_SEG	dw	?

NDP_CW	label	word		; Save area for NDP control word
	db	?
NDP_CW_HI	db	0	; High byte of control word
NDP_ENV	dw	7 dup (?)	; Save area for NDP environment

dataseg	ends

codeseg	segment byte public 'prog'
	assume	cs:codeseg,ds:dataseg,es:dataseg

	public	CPUID_
CPUID_	proc	near
	assume	cs:codeseg,ds:dataseg,es:dataseg

	irp	XX,<ax,cx,di,ds,es>	;save registers
	push 	XX
	endm

; Test for 80286  -- this CPU executs PUSH SP by storing SP first, then
; decrementing stack.
	mov	bx,FLG_28
	push	sp
	pop	ax
	cmp	ax,sp		;check for same
	je	CHECK_PIQL	;They are, so it is a 286

;Test for 186/188 -- 18x and 286 mask shift/rotate mod 32

	mov	bx,FLG_18	;Assume it's a 18x
	mov	cl,32+1		; 18x mask shit counts mod 32
	mov	al,0ffh		;start with all bits set
	shl	al,cl		;shit only one position if 18x
	jnz	CHECK_PIQL	;some bits still on, is a 18x. Check PIQL

	mov	bx,FLG_NEC	;Assume it's a NEV V-series CPU
	call	CHECK_NEC	;is it?
	jcxz	CHECK_PIQL	;it is. Check PIQL

	mov	bx,FLG_08	; it must be a 808x

CHECK_PIQL:
	call	PIQL_SUB	;subroutine to do it
	jcxz	CHECK_ERR	;if CX is 0, INC was not done
	or	bx,FLG_PIQL	;PIQ length is 4
CHECK_ERR:
	xor	ax,ax		;prepare to addess int. vector segment
	mov	ds,ax
	cli			;nobody move while we swap
	assume	ds:nothing
	mov	ax,offset cs:INT01 ;point to our handler
	xchg	ax,ds:[4]	;get and swap offset
	mov	OLDINT01_OFF,ax	;save to restore later
	mov	ax,cs		;get our segment
	xchg	ax,ds:[6]	;get and swap segment
	mov	OLDINT01_SEG,ax	;save old one

; Note we continue with interrupts disable to avoid
; an external interrupt occuring during this test.
	mov	cx,1		;initialize a register
	push	ss		;save SS to store back itself
	pushf			;move flags into ax
	pop	ax
	or	ax,mask	TF	;set trap flag
	push	ax		;place on stack
	POPFF			;and then into effect.
	nop		;some CPUs don't enable interrupts till next inst.
POST_NOP:
	pop	ss		;change the stack segment register
				; (to itself)
	dec	cx		;Normal CPUS execute this instruction.

	hlt			;we should never get here.

INT01:
; Note IF=TF=0
; If we're stopped at or before POST_NOP, continue.
	push	bp
	mov	bp,sp		;address the stack
	cmp	[bp].ARG_OFF,offset cs:POST_NOP	;check offset
	pop	bp		;restore
	ja	INT01_DONE	;we're done.
	iret
INT01_DONE:
	add	sp,3*2		;Stript IP CS and flags from stack
; Restore old INT 01 handler
INT01_OK:
	push	es
	les	ax,OLDINT01_VEC	;ES:AX old int01 handler
	assume	es:nothing	;Tell the assembler
	mov	ds:[4],ax	;restore offset
	mov	ds:[6],es	;and segment
	sti			;allow interrupts again
	pop	es
	push	es		;setup ds for code below
	pop	ds
	assume	ds:dataseg	;tell the assembler
	jcxz	CHECK_NDP	;if CX is 0, the CPU is ok
	or	bx,mask FLG_CERR ;tell the world it is a bad chip

CHECK_NDP:
	cli			;Protect FNSTENV	
	esc	0eh,NDP_ENV	;(fstenv)If NDP is present, save environment
	mov	cx,50/7		;Cycle for a bit
id1:	loop	id1		;to allow environment to be saved
	sti			;allow interrupts
	esc	1ch,bx		;(fninit) init NDP to known state
	jmp	short id2	;wait for init
id2:	esc	0fh,NDP_CW	;(fnstcw) save the control word
	jmp	short id3
id3:	jmp	short id4	;wait for result
id4:	cmp	NDP_CW_HI,03h	;is it there?
	jne	CPUID_EXIT	;no NDP installed
	int	11h		;get equipment status
	test	ax,mask I11_NDP	;is the right switch set?
	jnz	CHECK_NDP1	;it is.
	or	bx,mask FLG_NERR ;mark as error
CHECK_NDP1:
	and	NDP_CW,not mask IEM	;enable interrupts
	wait
	esc	0dh,NDP_CW	;(fldcw) reload control word
	wait
	esc	1ch,cx		;(fdisi) disable interrupts (ignored by 287)
	wait
	esc	0fh,NDP_CW	;(fstcw) save control word
	wait
	esc	0ch,NDP_ENV	;(fldenv) restore original NDP environment
	test	NDP_CW,mask IEM	;check interrupt enable mask
	jnz	CPUID_8087	;it changed, hence NDP is 8087
	or	bx,FLG_287	;NDP is a 287
	jmp	short CPUID_EXIT
CPUID_8087:
	or	bx,FLG_87	;NDP is an 8087
CPUID_EXIT:
	irp	XX,<es,ds,di,cx,ax>	;restore registers
	pop	XX
	endm
	mov	ax,bx
	assume	ds:nothing,es:nothing
	ret
CPUID_	endp

CHECK_NEC proc	near
	mov	cx,0ffffh	;move a lot of data
	sti			;ensure timer enabled
;execute multi-prefix instruction
	push	ax
	push	si
	xor	si,si
	rep lods	byte ptr es:[si]
	pop	si
	pop	ax
;on exit if CX is zero, it is a NEC.
	ret
CHECK_NEC endp
	subttl	Pre-fetch instruction queue subroutine
	page
PIQL_SUB proc	near
	assume	ds:dataseg,es:codeseg
@REP	equ	3		;repeat the store this many times
	push	es		;save extra segment value
	push	cs		;point es to cs
	pop	es		;to allow serial reusablity, restore INC CX
	mov	cs:LAB_INC,41h	;41h is an INC CX
	std
	mov	di,offset es:LAB_INC+@REP-1	;change the instruction es:di
	mov	al,cs:LAB_STI
	mov	cx,@REP
	cli				;disable interrupts
	rep stosb
	cld
	nop
	nop
	nop
;The followin is beyond a 4 byte PIQ, but with a 6 byte PIQ
LAB_INC	label byte
	inc	cx
LAB_STI	label byte
	rept	@REP-1
	sti
	endm
	pop	es		;restore extra segment
	assume	es:dataseg
	ret
	assume	ds:nothing,es:nothing
PIQL_SUB endp
codeseg	ends


	




