/*
 *	elks/arch/i86/drivers/char/bell.c
 *
 *	Copyright 1999 Greg Haerr <greg@censoft.com>
 *
 *	This file rings the PC speaker at a specified frequency.
 */

#include <arch/io.h>

/*
 * Turn PC speaker on at specified frequency.
 */
static void sound(unsigned freq)
{
    int es;
#ifndef S_SPLINT_S
#asm
	mov	bx, [bp+.sound.freq]	! frequency
	mov	ax, #$34dd
	mov	dx, #$0012
	cmp	dx, bx
	jnb	none
	div	bx
	mov	bx, ax
	in	al, $61
	test	al, #3
	jne	j1
	or	al, #3
	out	$61, al

j1:
	mov	al, #$b6
	out	$43, al
	mov	al, bl
	out	$42, al
	mov	al, bh
	out	$42, al

none:

#endasm
#endif
}

/*
 * Turn PC speaker off.
 */
static void nosound(void)
{
#ifndef S_SPLINT_S
#asm
	in	al, $61
	and	al, #$fc
	out	$61, al
#endasm
#endif
}

/*
 * Actually sound the speaker.
 */
void bell(void)
{
    register char *pi = (char *) 60000U;

    sound(800);
	while (--pi)
	/* Do nothing */ ;
    nosound();
}
