/*
 * WETEXE.C
 */
#include <windows.h>
#include "wet.h"

/*
For a DES example you could use the following code but you must link in:
WETDES16.LIB/WETDES32.LIB or dynamically load WETDES16.DLL/WETDES32.DLL.
void DES_Example(void)
{

  unsigned char work_string[100];
  unsigned char use_key[8]={'0','1','2','3','4','5','6','7'};
  lstrcpy(work_string,"This is a test 0123456789");
  MessageBox(NULL,work_string,"DES Encryption test - Clear Text",MB_ICONEXCLAMATION);
  DESKeyloadEncrypt(use_key);
  EncryptDESBlockCBC(work_string,16);
  MessageBox(NULL,work_string,"DES Encryption test - DES Encrypted (1st 16 char)",MB_ICONEXCLAMATION);
  DESKeyloadDecrypt(use_key);
  DecryptDESBlockCBC(work_string,16);
  MessageBox(NULL,work_string,"DES Encryption test - Decrypted",MB_ICONEXCLAMATION);
}
*/


int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
        LPSTR lpCmdLine, int cCmdShow)
{  
   char block[255]; 
   char key[]="The encryption key can be any phrase like - my dog is brown."; /* use any phrase as the key */
   char message[] = "This is the sensitive data we are protecting.  WET can be used with any type of data."; /* You can use WET with binary data also! */
   strcpy(block,message);
   MessageBox(NULL, block, "WET v2.0 encryption demo:  Message to protect!", MB_OK);
   EncryptXORBlock(block, strlen(message), key);           /* apply the first layer of encryption */
   EncryptSubstitutionBlock(block, strlen(message), key);  /* apply a second layer of encryption */
   EncryptTranspositionBlock(block, strlen(message), key); /* apply a third layer of encryption */
   block[strlen(message)]=0; /* terminate encrypted block at the end of the data section for display purposes */
   MessageBox(NULL, block, "Protected (encrypted) message!",MB_OK);
   EncryptTranspositionBlock(block, strlen(message), key); /* remove the third layer of encryption */
   EncryptSubstitutionBlock(block, strlen(message), key);  /* remove the second layer of encryption */
   EncryptXORBlock(block, strlen(message), key);           /* remove the first layer of encryption */
   MessageBox(NULL, block, "Restored (decrypted) message!", MB_OK);
   /*
     DES_Example();
   */
   return 1;
}
