/*
 * WET.H
 */
#if !defined (_WIN32)
#   define EXPORT __export
#   define EXPORT32
#else
#   define EXPORT
#   if defined DLL
#      define EXPORT32 __declspec(dllexport)
#   else
#      define EXPORT32 __declspec(dllimport)
#   endif
#endif
 

/* Standard version of the DLL */
extern EXPORT32 int EXPORT EncryptXORBlock(unsigned char far *block, int block_length, unsigned char far *code_key);
extern EXPORT32 int EXPORT EncryptSubstitutionBlock(unsigned char far *block, int block_length, unsigned char far *code); /* Generates key of prime length between 1024 and 2028 bytes.*/
extern EXPORT32 int EXPORT EncryptTranspositionBlock(unsigned char far *block, int block_length, unsigned char far *code);
extern EXPORT32 unsigned int EXPORT CRCBlock(unsigned char far *block,int block_length);
extern EXPORT32 unsigned int EXPORT GetVersionWETSTD(void);

/* DES version of the DLL */
extern EXPORT32 int EXPORT CryptDES(unsigned char far *datablock);
extern EXPORT32 int EXPORT DESKeyloadEncrypt(unsigned char far *key);
extern EXPORT32 int EXPORT DESKeyloadDecrypt(unsigned char far *key);
extern EXPORT32 int EXPORT EncryptDESBlock(unsigned char far *block,int block_length);
extern EXPORT32 int EXPORT DecryptDESBlock(unsigned char far *block,int block_length);
extern EXPORT32 int EXPORT EncryptDESBlockCBC(unsigned char far *block,int block_length);
extern EXPORT32 int EXPORT DecryptDESBlockCBC(unsigned char far *block,int block_length);
extern EXPORT32 unsigned int EXPORT GetVersionWETDES(void);

