Option Explicit

Global Curr_File_Changed As Integer ' Global flag used when changing fields
Global NewDictPath As String ' global.. for use when loading dicts. from another directory


' note, as vb does not accept "$" in a declaration
' I have changed all "$" into "D"

' ********************************************************************************
' This is the structure of the FILE.DDF RecLen 97 bytes
'
' keys are as follows :
' Key  0  Part  0   Unique    XfDid     Position  1   len  2     Ascending (int)
' Key  1  Part  0   Non-Uniq  XfDName   Position  3   len 20     Ascending (string)
Type XDFile_def
  XFDid As Integer                          ' File ID Starting from 1 (Unique)
  XFDName As String * 20                    ' FileName
  XFDLocation As String * 64                ' File Location i.e. Full Path
  XFDFlags As String * 1 ' (1 byte int)     ' Bit 4=1 for Dict Files, 0 For User
  XFDReserved As String * 10                ' Reserved
End Type


Type XDFileKey0_def
  XFDid As Integer                          ' File ID Starting from 1 (Unique)
End Type

' ********************************************************************************
' This is the structure of the FILED.DDF RecLen 32 bytes
'
' keys are as follows :
' Key  0  Part  0   Unique    XeDid     Position  1   len  2     Ascending (int)
' Key  1  Part  0   Non-Uniq  XeDFile   Position  3   len  2     Ascending (int)
' Key  2  Part  0   Non-Uniq  XeDName   Position  5   len  20    Ascending (string)
' Key  3  Part  0   Unique    XeDFile   Position  3   len  2     Ascending (int) - CONT
' Key  3  Part  1   Unique    XeDName   Position  5   len  20    Ascending (string)


Type XDFieldKey1_def
  XeDFile As Integer
End Type


Type XDField_def
  XeDid As Integer                          ' Field ID Starting from 1 (Unique)
  XeDFile As Integer                        ' File ID (XfDid in  FILE.DDF Above)
  XeDName As String * 20                    ' Field Name (May have duplicates)
  XeDDataType As String * 1 ' (1 byte int)  ' Field Type (0-13) See Below
  XeDOffset As Integer                      ' Field Offset starting from 0
  XeDSize As Integer                        ' Field Size
  XedDec As String * 1 ' (1 byte int)       ' Decimal places (for Decimal Types)
  XeDFlags As Integer                       ' Reserved
End Type


' ********************************************************************************
' This is the structure of the INDEX.DDF RecLen 10 bytes
'
' keys are as follows :
' Key  0  Part  0   Non_uniq  XiDFile    Position  1   len  2     Ascending (int)
' Key  1  Part  0   Non-Uniq  XiDField   Position  3   len  2     Ascending (int)

Type XDIndexKey0_def
  XiDFile As Integer
End Type


Type XDIndex_def
  XiDFile As Integer                        ' File ID (XfDid in  FILE.DDF Above)
  XidField As Integer                       ' Filed ID (XeDid in FILED.DFF above)
  XidNumber As Integer                      ' Key Number (0-->)
  XiDPart As Integer                        ' Key Part (Segment of above, from 0-->)
  XiDFlags As Integer                       ' Flags of Key
End Type

' XiDFlags can be :
'   K_DUP = 1
'   K_MOD = 2
'   K_BIN = 4
'   K_NUL = 8
'   K_SEG = 16
'   K_SEQ = 32
'   K_DEC = 64
'   K_SUP = 128
'   K_EXT = 256
'   K_MAN = 512

Type TempField_Def
   FieldID As Integer
   Position As Integer
   Length As Integer
   Type As Integer
End Type

Function AddRecordToFieldDDF (PosBlk As PosBlkDef, XeDFile As Integer, XeDName As String, XeDDataType As Integer, XeDOffset As Integer, XeDSize As Integer, XedDec As Integer, XeDFlags As Integer) As Integer
  
  Dim Keybuf As KeyBufDef
  Dim KeyBufLen As Integer
  Dim XDField As XDField_def
  Dim BufLen As Integer
  Dim stat As Integer
  Dim NextID As Integer

  KeyBufLen = Len(Keybuf)
  BufLen = Len(XDField)
  
  
  stat = btrcall(B_GETHI, PosBlk, XDField, BufLen, Keybuf, KeyBufLen, 0)
  If stat <> 0 Then
    If stat = 9 Then
      NextID = 1
    Else
      MsgBox "Btrieve Error Inserting Record in FILE file " & Chr(10) & stat & " " & BtErr(stat)
      AddRecordToFieldDDF = False
      stat = btrcall(B_CLOSE, PosBlk, XDField, BufLen, Keybuf, KeyBufLen, 0)
      Exit Function
    End If
  Else
    NextID = XDField.XeDid + 1
  End If
  status "ADDING TO FIELD.DDF WITH ID " & NextID
  
  
  XDField.XeDid = NextID
  XDField.XeDFile = XeDFile
  XDField.XeDName = XeDName
  XDField.XeDDataType = Chr(XeDDataType)
  XDField.XeDOffset = XeDOffset
  XDField.XeDSize = XeDSize
  XDField.XedDec = Chr(XedDec)
  XDField.XeDFlags = XeDFlags
  
  KeyBufLen = Len(Keybuf)
  BufLen = Len(XDField)
  
  stat = btrcall(B_INSERT, PosBlk, XDField, BufLen, Keybuf, KeyBufLen, 0)
  If stat <> 0 Then
    MsgBox "Btrieve Error Inserting Record in FIELD file " & Chr(10) & stat & " " & BtErr(stat)
    AddRecordToFieldDDF = False
    stat = btrcall(B_CLOSE, PosBlk, XDField, BufLen, Keybuf, KeyBufLen, 0)
    Exit Function
  End If
  
  AddRecordToFieldDDF = True


  

End Function

Function AddRecordToFileDDF (XFDid As Integer, PosBlk As PosBlkDef, XFDName As String, XFDLocation As String, XFDFlags As Integer, XFDReserved As String) As Integer
  Dim Keybuf As KeyBufDef
  Dim KeyBufLen As Integer
  Dim XDfile As XDFile_def
  Dim BufLen As Integer
  Dim stat As Integer
  Dim NextID As Integer
  Dim XDFileKey0 As XDFileKey0_def

  KeyBufLen = Len(Keybuf)
  BufLen = Len(XDfile)
  
  
  ' First Find the last record used on key=0, XF$ID
  If XFDid = -1 Then
    BufLen = Len(XDfile): KeyBufLen = Len(Keybuf)
    stat = btrcall(B_GETHI, PosBlk, XDfile, BufLen, Keybuf, KeyBufLen, 0)
    If stat <> 0 Then
      If stat = 9 Then
        NextID = 1
      Else
        MsgBox "Btrieve Error Inserting Record in FILE file " & Chr(10) & stat & " " & BtErr(stat)
        AddRecordToFileDDF = False
        stat = btrcall(B_CLOSE, PosBlk, XDfile, BufLen, Keybuf, KeyBufLen, 0)
        Exit Function
      End If
    Else
      NextID = XDfile.XFDid + 1
    End If
    status "ADDING TO FILE.DDF WITH ID " & NextID
  Else
    XDFileKey0.XFDid = XFDid
    BufLen = Len(XDfile): KeyBufLen = Len(XDFileKey0)
    stat = btrcall(B_GETEQ, PosBlk, XDfile, BufLen, XDFileKey0, KeyBufLen, 0)
    If stat <> 0 Then
      MsgBox "Btrieve Error Inserting Record in FILE file " & Chr(10) & stat & " " & BtErr(stat)
      AddRecordToFileDDF = False
      stat = btrcall(B_CLOSE, PosBlk, XDfile, BufLen, Keybuf, KeyBufLen, 0)
      Exit Function
    Else
      NextID = XFDid
      status "UPDATING TO FILE.DDF WITH ID " & NextID
    End If
  
  End If
  
  XDfile.XFDid = NextID
  XDfile.XFDName = XFDName
  XDfile.XFDLocation = XFDLocation
  XDfile.XFDFlags = Chr(XFDFlags)
  XDfile.XFDReserved = XFDReserved
  KeyBufLen = Len(Keybuf)
  BufLen = Len(XDfile)
  
  If XFDid = -1 Then
    stat = btrcall(B_INSERT, PosBlk, XDfile, BufLen, Keybuf, KeyBufLen, 0)
  Else
    stat = btrcall(B_UPDATE, PosBlk, XDfile, BufLen, Keybuf, KeyBufLen, 0)
  End If
  
  If stat <> 0 Then
    MsgBox "Btrieve Error Inserting/Updating Record in FILE file " & Chr(10) & stat & " " & BtErr(stat)
    AddRecordToFileDDF = False
    stat = btrcall(B_CLOSE, PosBlk, XDfile, BufLen, Keybuf, KeyBufLen, 0)
    Exit Function
  End If
  
  AddRecordToFileDDF = True

End Function

Function AddRecordToIndexDDF (PosBlk As PosBlkDef, XiDFile As Integer, XidField As Integer, XidNumber As Integer, XiDPart As Integer, XiDFlags As Integer) As Integer
  Dim Keybuf As KeyBufDef
  Dim KeyBufLen As Integer
  Dim XDindex As XDIndex_def
  Dim BufLen As Integer
  Dim stat As Integer



' XiDFile As Integer,
' XiDField As Ingeger,
' XiDNumber As Integer,
' XiDPart As Integer,
' XiDFlags As Integer
  
  KeyBufLen = Len(Keybuf)
  BufLen = Len(XDindex)
  XDindex.XiDFile = XiDFile
  XDindex.XidField = XidField
  XDindex.XidNumber = XidNumber
  XDindex.XiDPart = XiDPart
  XDindex.XiDFlags = XiDFlags
  
  stat = btrcall(B_INSERT, PosBlk, XDindex, BufLen, Keybuf, KeyBufLen, 0)
  If stat <> 0 Then
    MsgBox "Btrieve Error Inserting Record in Index file" & Chr(10) & stat & " " & BtErr(stat)
    AddRecordToIndexDDF = False
    stat = btrcall(B_CLOSE, PosBlk, XDindex, BufLen, Keybuf, KeyBufLen, 0)
    Exit Function
  End If
  
  AddRecordToIndexDDF = True



End Function

Function BtrDate (YY As Long, MM As Long, DD As Long) As Long
  ' converts YYMMDD into Btrieve Date type

  BtrDate = YY * 65536 + MM * 256 + DD

End Function

Function BtrTime (hh As Long, MM As Long, SS As Long) As Long
  BtrTime = hh * 16777216 + MM * 65536 + SS * 256
End Function

Sub Create_btrfile (XPath As String, Location As String, FileID As Integer)
  
  Dim stat As Integer
  
  Dim Keybuf As KeyBufDef
  Dim KeyBufLen As Integer
  Dim BufLen As Integer
  Dim FileBuf As FileBufDef
  Dim KeyNum As Integer
  Dim PosBlk As PosBlkDef
  Dim FileFullPath As String
  Dim i As Integer

  Dim XDField As XDField_def
  Dim XDFieldKey1 As XDFieldKey1_def
  Dim FileSize As Integer

  Dim XDindex As XDIndex_def
  Dim XDIndexKey0 As XDIndexKey0_def
  Dim IndexLast As Integer

  Dim TempField() As TempField_Def
  Dim FieldLast As Integer

' I need an array to store the Field information as follows :
'    FieldID .. so we can look it up with the key
'    Position = ' (Start From 1 and then add length of previous field !
'    Length = '


' **************************************************************************************************
' first I have to work out the total length of the file by looking up its fields in FIELD.DDF
' **************************************************************************************************

  KeyBufLen = Len(Keybuf)
  BufLen = Len(XDField)

  ' first open the file
  FileFullPath = XPath & "Field.DDF"
  Keybuf.kb = FileFullPath
  KeyBufLen = Len(Keybuf)
  BufLen = 0
  
  stat = btrcall(B_OPEN, PosBlk, XDField, BufLen, Keybuf, KeyBufLen, 0)
  If stat <> 0 Then
    MsgBox "Btrieve Error Opening file " & FileFullPath & Chr(10) & stat & " " & BtErr(stat)
    Exit Sub
  End If


  KeyBufLen = Len(XDFieldKey1): BufLen = Len(XDField)
  XDFieldKey1.XeDFile = FileID
  
  stat = btrcall(B_GETGE, PosBlk, XDField, BufLen, XDFieldKey1, KeyBufLen, 1)
  FieldLast = 0
  FileSize = 0
  Do
    If stat <> 0 Then Exit Do
    If XDField.XeDFile <> FileID Then Exit Do
    ReDim Preserve TempField(FieldLast)
    TempField(FieldLast).FieldID = XDField.XeDid
    TempField(FieldLast).Position = FileSize + 1
    TempField(FieldLast).Length = XDField.XeDSize
    TempField(FieldLast).Type = Asc(XDField.XeDDataType)
    
    FileSize = FileSize + XDField.XeDOffset
    FieldLast = FieldLast + 1

    KeyBufLen = Len(XDFieldKey1): BufLen = Len(XDField)
    stat = btrcall(B_GETNX, PosBlk, XDField, BufLen, XDFieldKey1, KeyBufLen, 1)
  
  Loop

  If (stat <> 9 And stat <> 0) Then MsgBox "Btrieve Error Retrieving Record in FILE file " & Chr(10) & stat & " " & BtErr(stat)
  stat = btrcall(B_CLOSE, PosBlk, XDField, BufLen, Keybuf, KeyBufLen, 0)

  If FieldLast = 0 Then
    MsgBox "File has NO fields.. It CANNOT be Created !", , "Create File"
    Exit Sub
  End If

' **************************************************************************************************
' now I have to work my way through INDEX.DDF to set up the indexes
' **************************************************************************************************
  

  
'Type XDIndexKey0_def
'  XiDFile As Integer
'End Type
  

  KeyBufLen = Len(Keybuf)
  BufLen = Len(XDindex)

  ' first open the file
  FileFullPath = XPath & "Index.DDF"
  Keybuf.kb = FileFullPath
  KeyBufLen = Len(Keybuf)
  BufLen = 0
  
  stat = btrcall(B_OPEN, PosBlk, XDindex, BufLen, Keybuf, KeyBufLen, 0)
  If stat <> 0 Then
    MsgBox "Btrieve Error Opening file " & FileFullPath & Chr(10) & stat & " " & BtErr(stat)
    Exit Sub
  End If


  KeyBufLen = Len(XDIndexKey0): BufLen = Len(XDindex)
  XDIndexKey0.XiDFile = FileID
  IndexLast = 0
  stat = btrcall(B_GETGE, PosBlk, XDindex, BufLen, XDIndexKey0, KeyBufLen, 0)
  Do
    If stat <> 0 Then Exit Do
    If XDindex.XiDFile <> FileID Then Exit Do
  
    For i = 0 To FieldLast - 1
      If TempField(i).FieldID = XDindex.XidField Then
        FileBuf.KeySpec(IndexLast).Position = TempField(i).Position
        FileBuf.KeySpec(IndexLast).Length = TempField(i).Length
        FileBuf.KeySpec(IndexLast).Flags = XDindex.XiDFlags
        FileBuf.KeySpec(IndexLast).Type = TempField(i).Type
        Exit For
      End If
    Next i
    IndexLast = IndexLast + 1
   
    KeyBufLen = Len(XDIndexKey0): BufLen = Len(XDindex)
    stat = btrcall(B_GETNX, PosBlk, XDindex, BufLen, XDIndexKey0, KeyBufLen, 0)
  
  Loop

  If (stat <> 9 And stat <> 0) Then MsgBox "Btrieve Error Retrieving Record in FILE file " & Chr(10) & stat & " " & BtErr(stat)
  stat = btrcall(B_CLOSE, PosBlk, XDindex, BufLen, Keybuf, KeyBufLen, 0)
  

' **************************************************************************************************
' Now I can Finally Create the file !
' **************************************************************************************************
  
  FileBuf.RecLen = FileSize
  FileBuf.PageSize = 1024
  FileBuf.IndxCnt = IndexLast
  FileBuf.FileFlags = 0

  Keybuf.kb = Location
  
  status "Creating  file " & Location


  KeyBufLen = Len(Keybuf)
  KeyNum = 0
  

  stat = btrcall(B_CREATE, PosBlk, FileBuf, Len(FileBuf), Keybuf, Len(Keybuf), KeyNum)

  If stat <> 0 Then
    MsgBox "Btrieve Error Creating file " & Keybuf.kb & Chr(10) & stat & " " & BtErr(stat)
    Exit Sub
  End If
  
  MsgBox "File Creation OK !", , "Create File"
  status ""
End Sub

Sub CreateDummyFile ()
  ' This Function SHOULD create new Dictionary Files FILE.DDF and FIELD.DDF
  ' and add the first records to them

  ' *** TO DO
  ' Check if File Exists
  ' Initialize btrieve

  Dim i As Integer
  Dim XPath As String
  XPath = "C:\VB\"

  Dim stat As Integer
  
  Dim Keybuf As KeyBufDef
  Dim KeyBufLen As Integer
  
  Dim FileBuf As FileBufDef
  
  Dim KeyNum As Integer
  Dim PosBlk As PosBlkDef
  
  Dim XDfile As XDFile_def
  Dim XDField As XDField_def
  Dim XDindex As XDIndex_def

  
' This is a dummy, just to create a file with all possible data type indexes

  
  FileBuf.RecLen = 40
  FileBuf.PageSize = 1024
  FileBuf.IndxCnt = 16
  FileBuf.FileFlags = 0


  FileBuf.KeySpec(0).Position = 1
  FileBuf.KeySpec(1).Position = 3
  FileBuf.KeySpec(2).Position = 5
  FileBuf.KeySpec(3).Position = 7
  FileBuf.KeySpec(4).Position = 9
  FileBuf.KeySpec(5).Position = 11
  FileBuf.KeySpec(6).Position = 13
  FileBuf.KeySpec(7).Position = 15
  FileBuf.KeySpec(8).Position = 17
  FileBuf.KeySpec(9).Position = 19
  FileBuf.KeySpec(10).Position = 21
  FileBuf.KeySpec(11).Position = 23
  FileBuf.KeySpec(12).Position = 25
  FileBuf.KeySpec(13).Position = 27
  FileBuf.KeySpec(14).Position = 29
  FileBuf.KeySpec(15).Position = 31
  
  FileBuf.KeySpec(0).Length = 2
  FileBuf.KeySpec(1).Length = 2
  FileBuf.KeySpec(2).Length = 2
  FileBuf.KeySpec(3).Length = 2
  FileBuf.KeySpec(4).Length = 2
  FileBuf.KeySpec(5).Length = 2
  FileBuf.KeySpec(6).Length = 2
  FileBuf.KeySpec(7).Length = 2
  FileBuf.KeySpec(8).Length = 2
  FileBuf.KeySpec(9).Length = 2
  FileBuf.KeySpec(10).Length = 2
  FileBuf.KeySpec(11).Length = 2
  FileBuf.KeySpec(12).Length = 2
  FileBuf.KeySpec(13).Length = 2
  FileBuf.KeySpec(14).Length = 2
  FileBuf.KeySpec(15).Length = 2


  FileBuf.KeySpec(0).Flags = K_EXT
  FileBuf.KeySpec(1).Flags = K_EXT
  FileBuf.KeySpec(2).Flags = K_EXT
  FileBuf.KeySpec(3).Flags = K_EXT
  FileBuf.KeySpec(4).Flags = K_EXT
  FileBuf.KeySpec(5).Flags = K_EXT
  FileBuf.KeySpec(6).Flags = K_EXT
  FileBuf.KeySpec(7).Flags = K_EXT
  FileBuf.KeySpec(8).Flags = K_EXT
  FileBuf.KeySpec(9).Flags = K_EXT
  FileBuf.KeySpec(10).Flags = K_EXT
  FileBuf.KeySpec(11).Flags = K_EXT
  FileBuf.KeySpec(12).Flags = K_EXT
  FileBuf.KeySpec(13).Flags = K_EXT
  FileBuf.KeySpec(14).Flags = K_EXT
  FileBuf.KeySpec(15).Flags = K_EXT


  For i = 0 To 15
    FileBuf.KeySpec(i).Type = 0
  Next i


  FileBuf.KeySpec(0).Type = 0
  FileBuf.KeySpec(1).Type = 1
  FileBuf.KeySpec(2).Type = 2
  FileBuf.KeySpec(3).Type = 3
  FileBuf.KeySpec(4).Type = 4
  FileBuf.KeySpec(5).Type = 5
  FileBuf.KeySpec(6).Type = 6
  FileBuf.KeySpec(7).Type = 7
  FileBuf.KeySpec(8).Type = 8
  FileBuf.KeySpec(9).Type = 9
  FileBuf.KeySpec(10).Type = 10
  FileBuf.KeySpec(11).Type = 11
 ' FileBuf.KeySpec(12).Type = 12
 ' FileBuf.KeySpec(13).Type = 13
  FileBuf.KeySpec(14).Type = 14
  FileBuf.KeySpec(15).Type = 15
 

  





  Keybuf.kb = XPath & "TEST.DDF"
  KeyBufLen = Len(Keybuf)
  KeyNum = 0
  
  
  status "Creating  file " & Keybuf.kb

  stat = btrcall(B_CREATE, PosBlk, FileBuf, Len(FileBuf), Keybuf, Len(Keybuf), KeyNum)

  If stat <> 0 Then
    MsgBox "Btrieve Error Creating file " & Keybuf.kb & Chr(10) & stat & " " & BtErr(stat)
    
    Exit Sub
  End If

  Debug.Print "DUMMY FILE CREATED !"
  

End Sub

Sub DictionaryCreate (XPath As String)
  Dim X As Integer

  X = NewDictCreateFiles(XPath)
  If X <> True Then
    Exit Sub
  End If

  X = NewDictInitFiles(XPath)
  If X <> True Then
    Exit Sub
  End If

  status ""

End Sub

Sub Fields_Remove (XPath As String, XFDid As Integer)
  ' Remove all Field references for the current file XfDid
  ' XPath & Field.ddf

  Dim stat As Integer
  Dim KeyNum As Integer
  Dim PosBlk As PosBlkDef
  Dim Keybuf As KeyBufDef
  Dim KeyBufLen As Integer
  Dim BufLen As Integer
  Dim FileFullPath As String
  Dim XDField As XDField_def
  Dim XDFieldKey1 As XDFieldKey1_def
  
' Curr_XFDid
' ************************************************************************************
' Now we remove records to the FIELD.DDF file
' ************************************************************************************

  FileFullPath = XPath & "FIELD.DDF"
  Keybuf.kb = FileFullPath
  KeyBufLen = Len(Keybuf)
  BufLen = 0

  
  status "Removing Fields from file " & FileFullPath
  
  stat = btrcall(B_OPEN, PosBlk, XDField, BufLen, Keybuf, KeyBufLen, 0)
  If stat <> 0 Then
    MsgBox "Btrieve Error Opening file " & FileFullPath & Chr(10) & stat & " " & BtErr(stat)
    Exit Sub
  End If

  
  Do
    XDFieldKey1.XeDFile = XFDid
    BufLen = Len(XDField): KeyBufLen = Len(XDFieldKey1)
    stat = btrcall(B_GETEQ, PosBlk, XDField, BufLen, XDFieldKey1, KeyBufLen, 1)
    If stat > 0 Then Exit Do
    stat = btrcall(B_DEL, PosBlk, XDField, BufLen, XDFieldKey1, KeyBufLen, 1)
    Debug.Print "Status "; stat
  Loop
  
  stat = btrcall(B_CLOSE, PosBlk, XDField, BufLen, Keybuf, KeyBufLen, 0)
  
  status ""
End Sub

Sub File_Remove (XPath As String, XFDid As Integer)
    

  Dim Keybuf As KeyBufDef
  Dim KeyBufLen As Integer
  Dim XDfile As XDFile_def
  Dim XDFileKey0  As XDFileKey0_def
  Dim BufLen As Integer
  Dim stat As Integer
  Dim PosBlk As PosBlkDef
  Dim FileFullPath As String
  Dim X As Integer
  Dim WhosFile As String

  

  KeyBufLen = Len(Keybuf)
  BufLen = Len(XDfile)

  ' first open the file
  FileFullPath = XPath & "FILE.DDF"
  Keybuf.kb = FileFullPath
  KeyBufLen = Len(Keybuf)
  BufLen = 0
  
  stat = btrcall(B_OPEN, PosBlk, XDfile, BufLen, Keybuf, KeyBufLen, 0)
  If stat <> 0 Then
    MsgBox "Btrieve Error Opening file " & FileFullPath & Chr(10) & stat & " " & BtErr(stat)
    Exit Sub
  End If


  XDFileKey0.XFDid = XFDid
  KeyBufLen = Len(XDFileKey0): BufLen = Len(XDfile)
  stat = btrcall(B_GETEQ, PosBlk, XDfile, BufLen, XDFileKey0, KeyBufLen, 0)
  If stat Then
    MsgBox "Error Finding Record " & BtErr(stat)
    Exit Sub
  End If
  stat = btrcall(B_DEL, PosBlk, XDfile, BufLen, XDFileKey0, KeyBufLen, 0)
  If stat Then
    MsgBox "Error Deleting Record " & BtErr(stat)
    Exit Sub
  End If
  
  stat = btrcall(B_CLOSE, PosBlk, XDfile, BufLen, Keybuf, KeyBufLen, 0)
  
  Fields_Remove XPath, XFDid

End Sub

Function FileExist (Fullpath As String) As Integer
  On Error GoTo NotExist

  Open Fullpath For Input As #1
  Close #1
  FileExist = True
  Exit Function

NotExist:
  FileExist = False
  Exit Function


End Function

Sub Indexes_Remove (XPath As String, XFDid As Integer)
  ' Remove all Index references for the current file XfDid
  ' XPath & Index.ddf

  Dim stat As Integer
  Dim KeyNum As Integer
  Dim PosBlk As PosBlkDef
  Dim Keybuf As KeyBufDef
  Dim KeyBufLen As Integer
  Dim BufLen As Integer
  Dim FileFullPath As String
  Dim XDindex As XDIndex_def
  Dim XDIndexKey0 As XDIndexKey0_def
  
' Curr_XFDid
' ************************************************************************************
' Now we remove records to the Index.DDF file
' ************************************************************************************

  FileFullPath = XPath & "Index.DDF"
  Keybuf.kb = FileFullPath
  KeyBufLen = Len(Keybuf)
  BufLen = 0

  
  status "Removing Indexes from file " & FileFullPath
  
  stat = btrcall(B_OPEN, PosBlk, XDindex, BufLen, Keybuf, KeyBufLen, 0)
  If stat <> 0 Then
    MsgBox "Btrieve Error Opening file " & FileFullPath & Chr(10) & stat & " " & BtErr(stat)
    Exit Sub
  End If

  
  Do
    XDIndexKey0.XiDFile = XFDid
    BufLen = Len(XDindex): KeyBufLen = Len(XDIndexKey0)
    stat = btrcall(B_GETEQ, PosBlk, XDindex, BufLen, XDIndexKey0, KeyBufLen, 0)
    If stat > 0 Then Exit Do
    stat = btrcall(B_DEL, PosBlk, XDindex, BufLen, XDIndexKey0, KeyBufLen, 0)
    Debug.Print "Status "; stat
  Loop
  
  stat = btrcall(B_CLOSE, PosBlk, XDindex, BufLen, Keybuf, KeyBufLen, 0)
  
  status ""

End Sub

Sub Main ()
  

  Load MainForm
  MainForm.Caption = "DDF Creator"
  MainForm.Show




'  DictionaryCreate "C:\VB\"
'  FileDDFEdit "C:\VB\"
'  FieldDDFEdit "C:\VB\"
  
  
End Sub

Function NewDictCreateFiles (XPath As String) As Integer
  ' This Function SHOULD create new Dictionary Files FILE.DDF and FIELD.DDF
  ' and add the first records to them

  ' *** TO DO
  ' Check if File Exists
  ' Initialize btrieve

  
  Dim stat As Integer
  
  Dim Keybuf As KeyBufDef
  Dim KeyBufLen As Integer
  
  Dim FileBuf As FileBufDef
  
  Dim KeyNum As Integer
  Dim PosBlk As PosBlkDef
  
  Dim XDfile As XDFile_def
  Dim XDField As XDField_def
  Dim XDindex As XDIndex_def

  
  status "Creating new dictionary files in " & XPath

' ************************************************************************************
' First Create the FILE.DDF RecLen 97 bytes
' ************************************************************************************
  

  FileBuf.RecLen = Len(XDfile)
  FileBuf.PageSize = 1024
  FileBuf.IndxCnt = 2
  FileBuf.FileFlags = 0

' Key  0  Part  0   Unique    XfDid     Position  1   len  2     Ascending
  FileBuf.KeySpec(0).Position = 1
  FileBuf.KeySpec(0).Length = 2
  FileBuf.KeySpec(0).Flags = K_MOD + K_EXT
  FileBuf.KeySpec(0).Type = K_T_NUM

' Key  1  Part  0   Non-Uniq  XfDName   Position  3   len 20     Ascending
  FileBuf.KeySpec(1).Position = 3
  FileBuf.KeySpec(1).Length = 20
  FileBuf.KeySpec(1).Flags = K_MOD + K_EXT
  FileBuf.KeySpec(1).Type = K_T_STR


  Keybuf.kb = XPath & "FILE.DDF"
  
  status "Creating  file " & Keybuf.kb


  KeyBufLen = Len(Keybuf)
  KeyNum = 0
  

  stat = btrcall(B_CREATE, PosBlk, FileBuf, Len(FileBuf), Keybuf, Len(Keybuf), KeyNum)

  If stat <> 0 Then
    MsgBox "Btrieve Error Creating file " & Keybuf.kb & Chr(10) & stat & " " & BtErr(stat)
    NewDictCreateFiles = False
    Exit Function
  End If
  

' ************************************************************************************
' Now Create the  FIELD.DDF RecLen 32 bytes
' ************************************************************************************
  
  FileBuf.RecLen = Len(XDField)
  FileBuf.PageSize = 1024
  FileBuf.IndxCnt = 4
  FileBuf.FileFlags = 0



' Key  0  Part  0   Unique    XeDid     Position  1   len  2     Ascending (int)
  FileBuf.KeySpec(0).Position = 1
  FileBuf.KeySpec(0).Length = 2
  FileBuf.KeySpec(0).Flags = K_EXT
  FileBuf.KeySpec(0).Type = K_T_BIN

' Key  1  Part  0   Non-Uniq  XeDFile   Position  3   len  2     Ascending (int)
  FileBuf.KeySpec(1).Position = 3
  FileBuf.KeySpec(1).Length = 2
  FileBuf.KeySpec(1).Flags = K_DUP + K_EXT
  FileBuf.KeySpec(1).Type = K_T_BIN
  
  
' Key  2  Part  0   Non-Uniq  XeDName   Position  5   len  20    Ascending (string)
  FileBuf.KeySpec(2).Position = 5
  FileBuf.KeySpec(2).Length = 20
  FileBuf.KeySpec(2).Flags = K_DUP + K_EXT
  FileBuf.KeySpec(2).Type = K_T_STR


' Key  3  Part  0   Unique    XeDFile   Position  3   len  2     Ascending (int) - CONT
  FileBuf.KeySpec(3).Position = 3
  FileBuf.KeySpec(3).Length = 2
  FileBuf.KeySpec(3).Flags = K_SEG + K_EXT
  FileBuf.KeySpec(3).Type = K_T_BIN


' Key  3  Part  1   Unique    XeDName   Position  5   len  20    Ascending (string)
  FileBuf.KeySpec(4).Position = 5
  FileBuf.KeySpec(4).Length = 20
  FileBuf.KeySpec(4).Flags = K_EXT
  FileBuf.KeySpec(4).Type = K_T_STR
  


  
  Keybuf.kb = XPath & "FIELD.DDF"
  KeyBufLen = Len(Keybuf)
  KeyNum = 0
  
  
  status "Creating  file " & Keybuf.kb

  stat = btrcall(B_CREATE, PosBlk, FileBuf, Len(FileBuf), Keybuf, Len(Keybuf), KeyNum)
                    
  If stat <> 0 Then
    MsgBox "Btrieve Error Creating file " & Keybuf.kb & Chr(10) & stat & " " & BtErr(stat)
    NewDictCreateFiles = False
    Exit Function
  End If
  
  
  
' ************************************************************************************
' Now Create the  INDEX.DDF RecLen 10 bytes
' ************************************************************************************
  
  FileBuf.RecLen = Len(XDindex)
  FileBuf.PageSize = 1024
  FileBuf.IndxCnt = 2
  FileBuf.FileFlags = 0

' Key  0  Part  0   Non_uniq  XiDFile    Position  1   len  2     Ascending (int)


  FileBuf.KeySpec(0).Position = 1
  FileBuf.KeySpec(0).Length = 2
  FileBuf.KeySpec(0).Flags = K_DUP + K_EXT
  FileBuf.KeySpec(0).Type = K_T_BIN

' Key  1  Part  0   Non-Uniq  XiDField   Position  3   len  2     Ascending (int)
  FileBuf.KeySpec(1).Position = 3
  FileBuf.KeySpec(1).Length = 2
  FileBuf.KeySpec(1).Flags = K_DUP + K_EXT
  FileBuf.KeySpec(1).Type = K_T_BIN
  
  Keybuf.kb = XPath & "INDEX.DDF"
  KeyBufLen = Len(Keybuf)
  KeyNum = 0
  
  
  status "Creating  file " & Keybuf.kb

  stat = btrcall(B_CREATE, PosBlk, FileBuf, Len(FileBuf), Keybuf, Len(Keybuf), KeyNum)

  If stat <> 0 Then
    MsgBox "Btrieve Error Creating file " & Keybuf.kb & Chr(10) & stat & " " & BtErr(stat)
    NewDictCreateFiles = False
    Exit Function
  End If
  


  NewDictCreateFiles = True

End Function

Function NewDictInitFiles (XPath As String) As Integer
  Dim stat As Integer
  
  Dim KeyNum As Integer
  Dim PosBlk As PosBlkDef
  Dim Keybuf As KeyBufDef
  Dim KeyBufLen As Integer
  Dim BufLen As Integer
  Dim FileFullPath As String

  Dim XDfile As XDFile_def
  Dim XDField As XDField_def
  

' ************************************************************************************
' First Add Fields to the FILE.DDF file
' ************************************************************************************

  
  FileFullPath = XPath & "FILE.DDF"
  Keybuf.kb = FileFullPath
  KeyBufLen = Len(Keybuf)
  BufLen = 0

  
  status "Adding Fields to file " & FileFullPath
  
  stat = btrcall(B_OPEN, PosBlk, XDfile, BufLen, Keybuf, KeyBufLen, 0)
  If stat <> 0 Then
    MsgBox "Btrieve Error Opening file " & FileFullPath & Chr(10) & stat & " " & BtErr(stat)
    NewDictInitFiles = False
    Exit Function
  End If


  If AddRecordToFileDDF(-1, PosBlk, "X$File", XPath & "FILE.DDF", 16, "") = False Then
    NewDictInitFiles = False
    Exit Function
  End If
  
  If AddRecordToFileDDF(-1, PosBlk, "X$Field", XPath & "FIELD.DDF", 16, "") = False Then
    NewDictInitFiles = False
    Exit Function
  End If

  If AddRecordToFileDDF(-1, PosBlk, "X$Index", XPath & "INDEX.DDF", 16, "") = False Then
    NewDictInitFiles = False
    Exit Function
  End If
  
  stat = btrcall(B_CLOSE, PosBlk, XDfile, BufLen, Keybuf, KeyBufLen, 0)



' ************************************************************************************
' Now we add records to the FIELD.DDF file
' ************************************************************************************

  FileFullPath = XPath & "FIELD.DDF"
  Keybuf.kb = FileFullPath
  KeyBufLen = Len(Keybuf)
  BufLen = 0

  
  status "Adding Fields to file " & FileFullPath
  
  
  
  stat = btrcall(B_OPEN, PosBlk, XDField, BufLen, Keybuf, KeyBufLen, 0)
  If stat <> 0 Then
    MsgBox "Btrieve Error Opening file " & FileFullPath & Chr(10) & stat & " " & BtErr(stat)
    NewDictInitFiles = False
    Exit Function
  End If

  ' Records for FILE.DDF

  If AddRecordToFieldDDF(PosBlk, 1, "Xf$id", 1, 0, 2, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If
  

  If AddRecordToFieldDDF(PosBlk, 1, "Xf$Name", 0, 2, 20, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If

  If AddRecordToFieldDDF(PosBlk, 1, "Xf$Loc", 0, 22, 64, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If
  
  If AddRecordToFieldDDF(PosBlk, 1, "Xf$Flags", 1, 86, 1, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If
  

  ' Records for FIELD.DDF
  
  If AddRecordToFieldDDF(PosBlk, 2, "Xe$Id", 1, 0, 2, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If

  If AddRecordToFieldDDF(PosBlk, 2, "Xe$File", 1, 2, 2, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If

  If AddRecordToFieldDDF(PosBlk, 2, "Xe$Name", 0, 4, 20, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If

  If AddRecordToFieldDDF(PosBlk, 2, "Xe$DataType", 1, 24, 1, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If


  If AddRecordToFieldDDF(PosBlk, 2, "Xe$OffSet", 1, 25, 2, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If

  If AddRecordToFieldDDF(PosBlk, 2, "Xe$Size", 1, 27, 2, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If

  If AddRecordToFieldDDF(PosBlk, 2, "Xe$Dec", 1, 29, 1, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If

  If AddRecordToFieldDDF(PosBlk, 2, "Xe$Flags", 1, 30, 2, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If

  ' Records For INDEX.DDF

  If AddRecordToFieldDDF(PosBlk, 3, "Xi$File", 1, 0, 2, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If
  
  If AddRecordToFieldDDF(PosBlk, 3, "Xi$Field", 1, 2, 2, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If
  
  If AddRecordToFieldDDF(PosBlk, 3, "Xi$Number", 1, 4, 2, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If
  
  If AddRecordToFieldDDF(PosBlk, 3, "Xi$Part", 1, 6, 2, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If
  
  If AddRecordToFieldDDF(PosBlk, 3, "Xi$Flags", 1, 8, 2, 0, 0) = False Then
    NewDictInitFiles = False
    Exit Function
  End If
  
  
  stat = btrcall(B_CLOSE, PosBlk, XDField, BufLen, Keybuf, KeyBufLen, 0)



  NewDictInitFiles = True
End Function

Sub status (s As String)
  If s <> "" Then
    MainForm.PanMain.Caption = " STATUS : " & s
  Else
    MainForm.PanMain.Caption = ""
  End If
End Sub

