Option Explicit


Global Const B_OPEN = 0
Global Const B_CLOSE = 1
Global Const B_INSERT = 2
Global Const B_UPDATE = 3
Global Const B_DEL = 4
Global Const B_GETEQ = 5
Global Const B_GETNX = 6
Global Const B_GETPR = 7
Global Const B_GETGT = 8
Global Const B_GETGE = 9
Global Const B_GETLT = 10
Global Const B_GETLE = 11
Global Const B_GETLW = 12
Global Const B_GETHI = 13
Global Const B_CREATE = 14
Global Const B_STAT = 15
Global Const B_EXTEND = 16
Global Const B_SET_DIR = 17
Global Const B_GET_DIR = 18
Global Const B_BEGIN = 19
Global Const B_END = 20
Global Const B_ABORT = 21
Global Const B_GETPOS = 22
Global Const B_GETDRC = 23
Global Const B_STEPNXT = 24
Global Const B_STOP = 25
Global Const B_VERSION = 26
Global Const B_UNLOCK = 27
Global Const B_RESET = 28
Global Const B_SETOWNR = 29
Global Const B_CLROWNR = 30
Global Const B_CRTSIDX = 31
Global Const B_DRPSIDX = 32
Global Const B_STEPFST = 33
Global Const B_STEPLST = 34
Global Const B_STEPPRV = 35
                       
Global Const bxGetNext = 36
Global Const bxinsert = 40

Rem Key Flag%

Global Const K_DUP = 1
Global Const K_MOD = 2
Global Const K_BIN = 4
Global Const K_NUL = 8
Global Const K_SEG = 16
Global Const K_SEQ = 32
Global Const K_DEC = 64
Global Const K_SUP = 128
Global Const K_EXT = 256
Global Const K_MAN = 512







Global Const K_T_STR = 0
Global Const K_T_BIN = 1
Global Const K_T_FLOAT = 2
Global Const K_T_DATE = 3
Global Const K_T_TIME = 4
Global Const K_T_DEC = 5
Global Const K_T_MONEY = 6
Global Const K_T_LOGICAL = 7
Global Const K_T_NUM = 8
Global Const K_T_BFLOAT = 9
Global Const K_T_LSTR = 10
Global Const K_T_ZSTR = 11
Global Const K_T_UNSIGN = 14
Global Const K_T_AUTOINC = 15



' ********************************************************************************
' These are the various FieldType constants.
' note : as the FieldType (XeDDataType) is actually a 1 char string we will have
'        to assign it using, for example XeDDataType=CHR(FieldType_Integer)

Global Const FieldType_String = 0
Global Const FieldType_Integer = 1
Global Const FieldType_Float = 2
Global Const FieldType_Date = 3
Global Const FieldType_Time = 4
Global Const FieldType_Decimal = 5
Global Const FieldType_Money = 6
Global Const FieldType_Logical = 7
Global Const FieldType_Numeric = 8
Global Const FieldType_Bfload = 9
Global Const FieldType_Lstring = 10
Global Const FieldType_Zstring = 11
Global Const FieldType_Note = 12
Global Const FieldType_Lvar = 13
Global Const FieldType_Unsigned = 14
Global Const FieldType_AutoInc = 15


Global Const MAXKEYS = 9

Type PosBlkDef
    pb As String * 128
End Type

Type KeyBufDef
    kb As String * 64
End Type

Type DummyBuffDef
  dummy As String * 256
End Type



Type KeySpecDef
    Position As Integer
    Length As Integer
    Flags As Integer
    Tot As Long
    Type As Integer
    Reserved As String * 4
End Type

Type FileBufDef
    RecLen As Integer
    PageSize As Integer
    IndxCnt As Integer
    NotUsed As String * 4
    FileFlags As Integer
    Reserved As String * 2
    Allocation As Integer
    KeySpec(20) As KeySpecDef
End Type
    
Type VerBuffDef
  MainVer As Integer
  SUbVer As Integer
  Type As String * 1
End Type

Global BtErr(140) As String




Declare Function wbtrvinit Lib "wbtrcall.dll" (init As Any) As Integer
Declare Function wbtrvstop Lib "wbtrcall.dll" () As Integer
Declare Function btrcall Lib "wbtrcall.dll" (ByVal op As Integer, pb As PosBlkDef, db As Any, Dl As Integer, kb As Any, ByVal Klen As Integer, ByVal Knum As Integer) As Integer

'Declare Function wbtrvinit Lib "wbtrlocl.dll" (init As Any) As Integer
'Declare Function wbtrvstop Lib "wbtrlocl.dll" () As Integer
'Declare Function btrcall Lib "wbtrlocl.dll" (ByVal op As Integer, pb As PosBlkDef, db As Any, Dl As Integer, kb As Any, ByVal Klen As Integer, ByVal Knum As Integer) As Integer

Sub BtrComErr (e As Integer)
  MsgBox "" & e & "-" & BtErr(e), , "BTRIEVE STATUS"
End Sub

Function BtrInit (Version As String)
  Dim KeyBufLen As Integer
  Dim Buflen As Integer
  Dim stat As Integer
  Dim x As Long, y As Single
  Dim init As String * 64
  Dim VerBuff As VerBuffDef
  Dim KeyBuf As KeyBufDef
  Dim PosBlk As PosBlkDef

  KeyBufLen = Len(KeyBuf)
  Buflen = Len(VerBuff)
  

  BtErr(0) = "Operation OK"
  BtErr(1) = "Operation Parameter Invalid"
  BtErr(2) = "Application Encountered an I/O error"
  BtErr(3) = "File Not Open"
  BtErr(4) = "Key Value Not Found"
  BtErr(5) = "Duplicate Key"
  BtErr(6) = "Key Number parameter Invalid"
  BtErr(7) = "Key number has changed"
  BtErr(8) = "Current Positioning Invalid"
  BtErr(9) = "End of File Reached"
  BtErr(10) = "Attempt to modify Non-Modifiable Key"
  BtErr(11) = "File Name Specified Invalid"
  BtErr(12) = "File Not found"
  BtErr(13) = "Extension File not found"
  BtErr(14) = "Failed to open PreImage File"
  BtErr(15) = "I/O Error during PreImaging"
  BtErr(16) = "Expansion Error"
  BtErr(17) = "Close Error"
  BtErr(18) = "Disk is Full"
  BtErr(19) = "Unrecoverable Error"
  BtErr(20) = "Microkernel or Requestor Inactive"
  BtErr(21) = "Key buffer parameter too short"
  BtErr(22) = "Data Buffer parameter too short"
  BtErr(23) = "Position block length not 128 bytes"
  BtErr(24) = "Invalid Page/DataBuffer size"
  BtErr(25) = "Cannot Create specified file"
  BtErr(26) = "Invalid number of keys specified"
  BtErr(27) = "Invalid Key Position"
  BtErr(28) = "Invalid Record Length"
  BtErr(29) = "Invalid Key Length"
  BtErr(30) = "File Specified is NOT a Btrieve file"
  BtErr(31) = "File is Already Extended"
  BtErr(32) = "File Cannot be Extended"
  BtErr(33) = "Microkernel cannot Unload"
  BtErr(34) = "Invalid Extension Name"
  BtErr(35) = "Directory/Path Error"
  BtErr(36) = "Transaction Error"
  BtErr(37) = "Another Transaction is active"
  BtErr(38) = "Transaction Control File I/O Error"
  BtErr(39) = "End/Abort Transaction Specified BEFORE Begin"
  BtErr(40) = "Exceeded Maximum number of files allowed"
  BtErr(41) = "Attempted operation not allowed"
  BtErr(42) = "File Opened in Accelerated mode was not closed"
  BtErr(43) = "Invalid Record address"
  BtErr(44) = "Invalid Key Path"
  BtErr(45) = "Invalid Key Flags"
  BtErr(46) = "Access to Specified File Denied"
  BtErr(47) = "Number of Files opened exceeds maximum"
  BtErr(48) = "Invalid Alternate collating sequence"
  BtErr(49) = "Invalid Extended Key Type"
  BtErr(50) = "Owner is already set"
  BtErr(51) = "Invalid Owner Name"
  BtErr(52) = "**UNDEFINED ERROR"
  BtErr(53) = "Language Interface Version Invalid"
  BtErr(54) = "Variable part of record is corrupt"
  BtErr(55) = "Invalid Attribute for AutoInc Key"
  BtErr(56) = "Index is incomplete"
  BtErr(57) = "**UNDEFINED ERROR"
  BtErr(58) = "Compression buffer length too Short"
  BtErr(59) = "File Already Exists"
  BtErr(60) = "Reached Reject count Specified"
  BtErr(61) = "Work Space too small"
  BtErr(62) = "Incorrect Descriptor"
  BtErr(63) = "Invalid Data Buffer Parameter in Insert Extended"
  BtErr(64) = "Filter Limit has been reached"
  BtErr(65) = "Incorrect Filed Offset"
  BtErr(66) = "Maximum number of open Databases exceeded"
  BtErr(67) = "MicroKernel cannot open SQL data dictionary"
  BtErr(68) = "MicroKernel Cannot perform RI Delete Cascade Operation"
  BtErr(69) = "Delete Operation specified a damaged fie"
  BtErr(70) = "**UNDEFINED ERROR"
  BtErr(71) = "Violation of RI Rules"
  BtErr(72) = "MicroKernel cannot open the RI Reference file"
  BtErr(73) = "RI Definition is out of sync."
  BtErr(74) = "MicroKernel Aborted Transaction"
  BtErr(75) = "**UNDEFINED ERROR"
  BtErr(76) = "Conflict in Reference File"
  BtErr(77) = "Application encountered a wait error"
  BtErr(78) = "MicroKernel detected a DeadLock condition"
  BtErr(79) = "**UNDEFINED ERROR"
  BtErr(80) = "MicroKernel encountered a record-level conflict"
  BtErr(81) = "MicroKernel encountered a Lock Error"
  BtErr(82) = "MicroKernel Lost positioning"
  BtErr(83) = "MicroKernel attempted to read a record outside transaction"
  BtErr(84) = "Record or Page is Locked"
  BtErr(85) = "File is Locked"
  BtErr(86) = "File Table is full"
  BtErr(87) = "Handle Table is full"
  BtErr(88) = "Incompatible mode error"
  BtErr(89) = "**UNDEFINED ERROR"
  BtErr(90) = "Redirected device table full"
  BtErr(91) = "Server Error"
  BtErr(92) = "Transaction table is full"
  BtErr(93) = "Record lock types are incompatible"
  BtErr(94) = "Permission Error"
  BtErr(95) = "Session is no longer valid"
  BtErr(96) = "Communications error"
  BtErr(97) = "Data buffer too small"
  BtErr(98) = "MicroKernel detected internal transaction error"
  BtErr(99) = "Btrieve request unable to access Runtime server"
  BtErr(100) = "No Cache buffers available"
  BtErr(101) = "Insufficient operating system memory"
  BtErr(102) = "Insufficient stack space"
  BtErr(103) = "Chunk offset too big"
  BtErr(104) = "MicroKernel does not recognize the locale"
  BtErr(105) = "File cannot be crated with variable-tail Allocation records (VATs)"
  BtErr(106) = "Chunk cannot perform a Get Next Operation"
  BtErr(107) = "Attempted Chunk operation on a Pre v6.0 file"
  BtErr(108) = "**UNDEFINED ERROR"
  BtErr(109) = "Trasaction too complex"
  BtErr(110) = "**UNDEFINED ERROR"
  BtErr(111) = "**UNDEFINED ERROR"
  BtErr(112) = "**UNDEFINED ERROR"
  BtErr(113) = "**UNDEFINED ERROR"
  BtErr(114) = "**UNDEFINED ERROR"
  BtErr(115) = "**UNDEFINED ERROR"
  BtErr(116) = "**UNDEFINED ERROR"
  BtErr(117) = "**UNDEFINED ERROR"
  BtErr(118) = "**UNDEFINED ERROR"
  BtErr(119) = "**UNDEFINED ERROR"
  BtErr(120) = "**UNDEFINED ERROR"
  BtErr(121) = "**UNDEFINED ERROR"
  BtErr(122) = "**UNDEFINED ERROR"
  BtErr(123) = "**UNDEFINED ERROR"
  BtErr(124) = "**UNDEFINED ERROR"
  BtErr(125) = "**UNDEFINED ERROR"
  BtErr(126) = "**UNDEFINED ERROR"
  BtErr(127) = "**UNDEFINED ERROR"
  BtErr(128) = "**UNDEFINED ERROR"
  BtErr(129) = "**UNDEFINED ERROR"
  BtErr(130) = "MicroKernel exhausted system locks"
  BtErr(131) = "**UNDEFINED ERROR"
  BtErr(132) = "**UNDEFINED ERROR"
  BtErr(133) = "More than 5 Users on file"
  

  'Option Description                Required value
  '------ -----------                --------------
  '/m     Memory size                At least 38
  '/p     Page size                  4096
  '/b     Pre-image buffer size      16
  '/f     Open files                 At least 4
  '/l     Multiple locks             At least double the setting for
  '                                    the Open Files option (/f)
  '/n     Files in a transaction     At least 4
  '/t     Transaction file name      Valid path to a .TRN file;
  '                                    in a multiuser environment,
  '                                    network path to the .TRN
  '                                    file shared by all users
  '/u     Compression buffer size    If your Btrieve data files are
  '                                    compressed, at least the length
  '                                    (in kilobytes) of the longest
  '                                    record in your data files
  '/i     Pre-image file drive
  '/c     Index compaction
  '/a     Activate logging
  '/s     Discard unneeded segments
  
  init = "/m:64 /p:4096 /b:16 /f:20 /l:40 /n:12 /t:C:\ACCESS\BTRIEVE.TRN"
  x = wbtrvinit(init)
  


  stat = btrcall(B_VERSION, PosBlk, VerBuff, Buflen, KeyBuf, KeyBufLen, 0)

  
  If stat = 0 Then
    Version = Trim(Str(VerBuff.MainVer)) & "." & Trim(Str(VerBuff.SUbVer)) & " " & VerBuff.Type
  Else
    Version = ""
  End If
  
  BtrInit = stat

End Function

Sub BtrStart ()
  Dim KeyBuff As KeyBufDef
  Dim KeyBuffLen As Integer
  Dim DataBUff As DummyBuffDef
  Dim DataBuffLen As Integer
  Dim DummyPos As PosBlkDef
  Dim stat As Integer
  Dim Version As String
  
  stat = BtrInit(Version)
  If stat = 0 Then
    MsgBox "Version " & Version, , "BTRIEVE LOADED"
    ' debug.Print "Btrieve Version " & Version
    stat = btrcall(B_RESET, DummyPos, DataBUff, DataBuffLen, KeyBuff, KeyBuffLen, 0)
    
  Else
    BtrComErr (stat)
    End
  End If
  
End Sub

Sub BtrStop ()
  Dim KeyBuff As KeyBufDef
  Dim KeyBuffLen As Integer
  Dim DataBUff As DummyBuffDef
  Dim DataBuffLen As Integer
  Dim DummyPos As PosBlkDef
  Dim stat As Integer
  

  stat = btrcall(B_RESET, DummyPos, DataBUff, DataBuffLen, KeyBuff, KeyBuffLen, 0)
  stat = btrcall(B_STOP, DummyPos, DataBUff, DataBuffLen, KeyBuff, KeyBuffLen, 0)
  stat = wbtrvstop()

End Sub

