/*************************************************************************/
/*                               ALERT Source                            */
/*                                                                       */
/*                                 M\Cooper                              */
/*                          3425 Chestnut Ridge Rd.                      */
/*                        Grantsville, MD 21536-9801                     */
/*************************************************************************/


#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <stdlib.h>
#include "alert.h"



void main( int argc, char **argv )
{

   
   time_t starting_time;

   clock_t t_start,
	   t_end,
	   t_tot,
	   hrs,
	   min,
	   sec;

      SoundFlag = ON;

      if( argc > 1 )
	 if( *argv[1] == 's' )
	     SoundFlag = OFF;


      t_start = clock() / CLK_TCK;
      starting_time = time( NULL );

      graphics_setup( SETUP_COLOR );

      while( !( kbhit() && getch() == EXITVALUE ) )  // Press EXITVALUE (in alert.h file) to exit.
	 FlashCycle();

      closegraph();

      t_end = clock() / CLK_TCK;

      t_tot = t_end- t_start;
      hrs = t_tot / 3600L;
      t_tot = t_tot - ( hrs * 3600L );
      min = t_tot / 60L;
      t_tot = t_tot - ( min * 60L );
      sec = t_tot;

      textcolor( LIGHTRED );
      cprintf( "\nALERT has been active since " );
      cprintf( ctime( &starting_time ) ); 

      textcolor( LIGHTBLUE );
      cprintf( "                            " );
      cprintf( "ALERT has been running for " );

      if( hrs )
	 if( hrs > 1 )
	    cprintf( "%ld hours, ",  hrs );
	 else
	    cprintf( "%ld hour, ", hrs );

      if( min )
	 if( min > 1 )
	    cprintf( "%ld minutes, ", min );
	 else
	    cprintf( "%ld minute, ", min );
	    
      if( sec )
	 if( sec > 1 )
	    cprintf( "%ld seconds.\n\n\n", sec );
	 else
	    cprintf( "%ld second.\n\n\n", sec );
			

}


/*************************************************************************/
/*                    GENERIC VGA GRAPHICS SETUP                         */
/*************************************************************************/

void graphics_setup( int background_color )
{
   int grdriver = VGA,
       grmode = VGAHI;

       registerfarbgidriver( EGAVGA_driver_far );
       registerfarbgifont( triplex_font_far );
       initgraph( &grdriver, &grmode, "" );

       if( graphresult() )  //Error in opening graphics mode..
          {
          closegraph();
          exit ( GR_ERROR );
          puts( "Error in opening graphics systems!" );
          }

       setbkcolor( background_color );
       setcolor( PIXEL_COLOR );

       return;

}

void write_text( int x_coord, int y_coord, int type_size, char* text )
{
      settextstyle( TRIPLEX_FONT, HORIZ_DIR, type_size);
      outtextxy( x_coord, y_coord, text );

      return;
}

void FlashCycle()
{

    static char *txt1,
		*txt2;
   int y_ht,
       line1color,
       count = -1;

      randomize();

      txt1 = Msg1;
      txt2 = Msg2;

      switch ( random ( RANDOM + 1 ) )
	 {
	 case 0:
	    setbkcolor( LIGHTBLUE );
	    line1color = YELLOW;
	    break;
	 case 1:
	    setbkcolor( WHITE );
	    line1color = DARKGRAY;
	    break;
	 case 2:
	    setbkcolor( LIGHTGREEN );
	    line1color = BLUE;
	    break;
	 default:
	    setbkcolor( YELLOW );
	    line1color = RED;
	  }

      y_ht = random( MAXYHT );
      WRITE_LINE1;

      while( !kbhit() && ++count < MAXCYCLECOUNT )
	 {
	 delay( DELAY ); 
	 ERASE_LINE1;
	 WRITE_LINE2;

	 if( random( MAXCYCLECOUNT ) >= DIALPHONE && SoundFlag == ON )
	    if( !random( RANDOM ) )
	       warble();
	    else
	       dial();

	 delay( DELAY );           
	 ERASE_LINE2;
	 WRITE_LINE1; 
	 }
      cleardevice();

      return;
}
