/*** TERM_IO.C ***/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pcl4c.h"
#include "term_io.h"
#include "ascii.h"
#include "dos_io.h"
#include "win_io.h"

#define FALSE 0
#define TRUE !FALSE

static int EchoFlag = FALSE;
static char EnterMsg[] = "Enter Filename:";

static  char Temp[80];

static int TraceFlag = FALSE;
static FILE *TraceID;
static char TraceBuf[2];


/* turn I/O tracing ON or OFF */

void SetIOtrace(int Flag)
{TraceFlag = Flag;
 if(TraceFlag) TraceID = fopen("TRACE.BIN","wb");
 else if(TraceID) fclose(TraceID);
}

void MsgEcho(int Flag)
{EchoFlag = Flag;
}

/* write message to right status line */

void WriteMsg(char *MsgPtr)
{if(EchoFlag)
   {WinPutString(SCR_WIN,MsgPtr);
    WinPutChar(SCR_WIN,'\n');
   }
 WinClear(RGT_WIN);
 WinPutChar(RGT_WIN,' ');
 WinPutString(RGT_WIN,MsgPtr);
 WinGetPos(SCR_WIN,NULL,NULL);
}

/*** write message + integer parm */

void WriteIntMsg(char *MsgPtr, int Parm)
{char Temp[50];
 sprintf(Temp,"%s %d", MsgPtr, Parm);
 WriteMsg(Temp);
}

/*** write message + hexidecimal parm */

void WriteHexMsg(char *MsgPtr, int Parm)
{char Temp[50];
 sprintf(Temp,"%s 0x%x", MsgPtr, Parm);
 WriteMsg(Temp);
}

/*** write message + long parm */

void WriteLongMsg(char *MsgPtr, long Parm)
{char Temp[50];
 sprintf(Temp,"%s %ld", MsgPtr, Parm);
 WriteMsg(Temp);
}

/*** read message */

void ReadMsg(char *Buffer,int Length,int StartCol)
{WinSetPos(RGT_WIN,0,StartCol);
 WinGetString(RGT_WIN,Buffer,Length);
 WinGetPos(SCR_WIN,NULL,NULL);
}

/*** display the error text ***/

void SayError(int Port, char *ptr)
{sprintf(Temp,"ERROR! COM%d : %s",1+Port,ptr);
 WriteMsg(Temp);
 /* cancel remote */
 CharPut(Port,CAN);
 CharPut(Port,CAN);
 CharPut(Port,CAN);
} /* end SayError */

/*** test DSR ***/

int TestDSR(int Port)
{int ThisDSR;
 static LastDSR = 0;
 ThisDSR = SioDSR(Port);
 /* report if DSR status changed */
 if(ThisDSR!=LastDSR)
     {if(ThisDSR) sprintf(Temp,"DSR is up\n");
      else sprintf(Temp,"DSR dropped\n");
      WinPutString(SCR_WIN,Temp);
      LastDSR = ThisDSR;
     }
 return ThisDSR;
}

/*** output character to serial port ***/

int CharPut(int Port, char ch)
{int i, rc;
 int n;
 if(!TestDSR(Port)) return DSR_DROPPED;
 /* transmit character [avoiding TX buffer overflow] */
 while((rc=SioPutc(Port,ch))==-1);
 if(rc<-1)
   {sprintf(Temp,"SioPutc Error: COM%d: ",1+Port);
    WinPutString(SCR_WIN,Temp);
    SioError(rc);
    SioDone(Port);
    exit(1);
   }
 if(TraceFlag) if(rc>-1)
   {TraceBuf[0] = 1;
    TraceBuf[1] = ch;
    n = fwrite(TraceBuf,2,1,TraceID);
   }
 return(rc);
}

/*** receive character from serial port ***/

int CharGet(int Port, int Timeout)
{int rc;
 int n;
 if(!TestDSR(Port)) return DSR_DROPPED;
 rc = SioGetc(Port,Timeout);
 if(rc<-1)
     {sprintf(Temp,"SioGetc Error: COM%d: ",1+Port);
      WinPutString(SCR_WIN,Temp);
      SioError(rc);
      SioDone(Port);
      exit(1);
     }
 if(TraceFlag) if(rc>-1)
   {TraceBuf[0] = 2;
    TraceBuf[1] = (char)rc;
    n = fwrite(TraceBuf,2,1,TraceID);
   }
 return(rc);
}

/*** fetch name from user if Filespec[] is empty ***/

int FetchName(char *FileName)
{/* already have filename ? */
 if(strlen(FileName) > 0) return TRUE;
 /* get filename from user */
 WriteMsg(EnterMsg);
 ReadMsg(FileName,20,1+strlen(EnterMsg));
 /* got non-NULL name ? */
 if(strlen(FileName)>0) return TRUE;
 else return FALSE;
}

/* display CPS */

void WriteCPS(long StartTics,long FileBytes,char *Filename,int Skipped)
{int  CPS;
 long Tics;
 long Secs;
 char Temp[80];
 if(*Filename=='\0') return;
 if(!Skipped)
   {Secs = (SioTimer() - StartTics) / 18;
    if(Secs>0) CPS = (int)(FileBytes / Secs);
    else Skipped = TRUE;
   }
 if(Skipped) sprintf(Temp,"%s skipped (%ld bytes)\n",Filename,FileBytes);
 else sprintf(Temp,"%s transferred @ %d CPS (%ld bytes)\n",Filename,CPS,FileBytes);
 WinPutString(SCR_WIN,Temp);
 }

