#!/usr/bin/perl
##
## vi:ts=4
##
##---------------------------------------------------------------------------##
##  Author:
##      Markus F.X.J. Oberhumer         markus.oberhumer@jk.uni-linz.ac.at
##  Copyright:
##      Copyright (C) 1995, 1996 Markus F.X.J. Oberhumer
##      For conditions of distribution and use, see copyright notice in kb.h 
##  Description:
##      Select files for tar/zip distribution
##---------------------------------------------------------------------------##

@Files = (
	'bin/kbtstdos.exe',
	'bin/kbtstlnx.out',
	'bin/kbtstnt.exe',
	'bin/kbtstos2.exe',
	'readme*',
	'copying*',
	'makefile*',
	'*.bat',
	'*.btm',
	'*.c',
	'*.diz',
	'*.doc',
	'*.h',
	'*.hh',
	'*.log',
	'*.lsm',
	'*.pl',
	'*.sdi',
);

# config
$dirsep  = $ENV{'COMSPEC'} ? '\\' : '/';		# directory separator
$dirsep_ = '\\' . $dirsep;						# useable in a regexp

# get dirname
$dirname = shift;			
$dirname .= $dirsep if $dirname;	# add trailing '/'

# make a Perl regexp
$Files = '(^|[\\\/])((' . join(')|(', @Files) . '))$';
$Files =~ s/\./\\\./g;				# quote all '.'
$Files =~ s/\*/\.\*/g;				# change all '*' to '.*'

# process files or stdin
$i = 0;
while (<>) {
	next if /^\s*$/;				# skip empty lines
	next if /^\s*\#/;				# skip comment lines

	next if /^\.{1,2}$/;			# skip '.' and '..'

	s/\\/\//g;

	## s/^(\.\.\/)+//;				# remove leading '../'
	s/^(\.\/)+//;					# remove leading './'

	next unless (/$Files/io);		# ignore case

	s/\//$dirsep/g;
	print "${dirname}$_"; 
	$i++;
}

# print info message
print STDERR "$0: $i files\n";
exit(0);
