/* uuencode [input] output uuencode-produced-file
 * Encode a file so it can be mailed to a remote system.
 */
/*last modified by boris@innonyc.com
*/
#include <stdio.h>
#include <stdlib.h>
#include <stdlib.h>
#include <string.h>

/* ENC is the basic 1-character encoding function to make a char printing */
#define ENC(c) ((c) ? ((c) & 077) + ' ': '`')
void outdec(char * p, FILE * f);
void encode(FILE *in,FILE *out);
void main(int argc, char ** argv)
{
	FILE *out, *in;
	if ((argc != 2)&&(argc != 4)){
		fprintf(stderr, "Usage: %s [infile] remotefile [uufile]\n",argv[0]);
		exit(2);
	}

if((!strcmp(argv[1],"-?"))||(!strcmp(argv[1],"-h"))
||(!strcmp(argv[1],"/?"))||(!strcmp(argv[1],"/h")) ){
printf("Program performs uucode on a file.\nTo use type %s [infile] \
remotefile [uufile]\nWhen activated without first and third arguments uses \
standart input and output\n",argv[0]);
exit(0);
}

	/* optional 1st argument */
	if (argc == 4) {
		if ((in = fopen(argv[1], "rb")) == NULL) {
			perror(argv[1]);
			exit(1);
		}
		if ((out = fopen(argv[3], "w")) == NULL) {
		 perror(argv[3]);fclose (in);
		 exit(4);
		}

	} else
	 {in = stdin;out=stdout;
	 }
/* mandatory 3rd argument is name of uuencoded file */

	fprintf(out, "begin %o %s\n", 0755, argv[1]);

	encode(in, out);

	fprintf(out, "end\n");fclose (in);fclose (out);
	exit(0);
}

/*
 * copy from in to out, encoding as you go along.
 */
void encode(FILE *in,FILE *out)
{
	char buf[80];
	register int i, n;

	for (;;) {
		/* 1 (up to) 45 character line */
		n = fread(buf, 1, 45, in);
		putc(ENC(n), out);

		for (i=0; i<n; i += 3)
			outdec(&buf[i], out);

		putc('\n', out);
		if (n <= 0)
			break;
	}
}

/*
 * output one group of 3 bytes, pointed at by p, on file f.
 */
void outdec(char * p, FILE * f)
{
	register int c1, c2, c3, c4;

	c1 = *p >> 2;
	c2 = (*p << 4) & 060 | (p[1] >> 4) & 017;
	c3 = (p[1] << 2) & 074 | (p[2] >> 6) & 03;
	c4 = p[2] & 077;
	putc(ENC(c1), f);putc(ENC(c2), f);
	putc(ENC(c3), f);putc(ENC(c4), f);
}
