/*****************************************************************
*
* PROJECT:        Swiss Perfect 3
*
*                 Copyright (C) 1996 Robert Rozycki
*                 SwissPerfect General Public Licence
*
* FILE:           sp3rrpar.h
*
* DESCRIPTION:    round-robin pairing classes declarations
*
* AUTHOR:         Robert Rozycki     rozycki@perth.dialix.oz.au
*
* PORTABILITY:    ANSI C++
*
* $Revision: 1.1 $
*
* $Date: 1996/02/19 11:24:30 $
*
*******************************************************************/
#ifndef _SP3RRPAR_H
#define _SP3RRPAR_H

#include "l_types.h"

typedef struct {
  int white;
  int black;
} RRPair_t;


class RoundRobinPair_c
{
public:
   RoundRobinPair_c();
   int GetPairing( int *table, int players_count, int round, int multi = 1 );

protected:

   RRPair_t *pCurrRound;

   virtual void GenerateRound ( int,       // round number
                                int,       // number of tables,
                                int,       // is number of players odd
                                int = 1 )  // which multi round
      {};
};



class Rutsch_c : public RoundRobinPair_c
{
public:
	Rutsch_c( );

protected:
   void GenerateRound ( int round, int pair_count, int odd, int multi );
   void AdjustPairing( int round, int tables, int multi );
};



class StandardRR_c : public RoundRobinPair_c
{
public:
	StandardRR_c( );

protected:
   void GenerateRound ( int round, int pair_count, int odd, int multi );
   void FixLastPair( int tables, int round, boolean odd_player, int multi );
};

#endif

