/* cmdshl.cmd - an improved cmd shell                          960222 */
/* (c) martin lafaix 1994 - 1996                                      */

/* user dependant values */
insertState = 1
cmdQueue = 1
impCD = 1
nl = '0d0a'x
defHelp = 'Use the DEFINE command to (re)define keyboard keys'nl||nl||,
          'SYNTAX:    DEF key [value]'nl||,
          '        DEFINE key [value]'nl||nl||,
          '         key    The name of the key to be redefined.'nl||,
          '         value  The new key value. It can be an internal command,'nl||,
          '                OSNowait xxx or TEXT yyy.'nl||nl||,
          'Examples:'nl||,
          '         DEF F12 TEXT dir /w'nl||,
          '      DEFINE F3  OSNOWAIT exit'nl||,
          '         DEF F12'
aliasHelp = 'Use the ALIAS command to view, add or remove an alias'nl||nl||,
            'SYNTAX: ALIAS [LIST|alias=[string]|@file]'nl||nl||,
            '         LIST    View all currently defined aliases.'nl||,
            '         alias   An alias name (case sensitive).'nl||,
            '         string  The new value for alias.'nl||,
            '         file    A file containing one (or more) alias definitions.'nl||nl||,
            'In an alias definition, %n[*] denotes command line parameters.'
cmdHelp = 'Use the CMDSHL command to enhance your command shell.'nl||nl||,
          'SYNTAX: CMDSHL [/I|/O] [/P profile] [/C cmd|/K cmd]'nl||nl||,
          '         /I    Insert mode is the default.'nl||,
          '         /O    Overstrike mode is the default.'nl||,
          '         /P    Use the specified profile file.'nl||,
          '         /C    Execute cmd and exit CMDSHL.'nl||,
          '         /K    Execute cmd without exiting CMDSHL.'nl||nl||,
          'By default, Insert mode is on and PROFILE.SHL is used as profile'nl||,
          'file if it exists along the path specified by the DPATH environment'nl||,
          'variable.'
cdHelp = 'Enter CD -     To go back to the previous current directory'
/* nothing to translate beyond this point */

/*====================================================================
 * The Main Loop.
 *====================================================================*/
'@echo off'; trace off

call init

if arg() then
   call doarg arg(1)

call profile

loop:
do forever
   call charout ,print()

   line = getline()

   if (eval(line) = 0) then
      leave
end /* do */

call terminate

exit

/*====================================================================  
 * A cmd.exe-like Command Prompt.
 *====================================================================*/
print:             
   prompt = value('PROMPT',,'OS2ENVIRONMENT')
   if (prompt == '') then
      prompt = '[$p]'

   str = ''

   do i = 1 to length(prompt)
      key = substr(prompt,i,1)
      if (key = '$') then
         do
         i = i+1; key = translate(substr(prompt,i,1))
         select                               
            when key = '$' then str = str||'$'
            when key = 'A' then str = str||'&'
            when key = 'B' then str = str||'|'
            when key = 'C' then str = str||'(' 
            when key = 'D' then str = str||date()
            when key = 'E' then str = str||'1b'x
            when key = 'F' then str = str||')' 
            when key = 'G' then str = str||'>'                                                                      
            when key = 'H' then str = str||'08'x                                                                            
            when key = 'I' then str = str||'1b'x'[s'||'1b'x'[0;0H'helpColor1'1b'x'[K'helpstring||helpColor2'1b'x'[u'
            when key = 'L' then str = str||'<'
            when key = 'N' then str = str||filespec("d",directory())
            when key = 'P' then str = str||directory()
            when key = 'Q' then str = str||'='
            when key = 'R' then str = str||rc
            when key = 'S' then str = str||' '
            when key = 'T' then str = str||time()
            when key = 'V' then str = str||verString
            when key = '_' then str = str||'0d0a'x
         otherwise
         end  /* select */
         end
      else     
         str = str||key
   end /* do */
   return str

/*====================================================================  
 * A cmd.exe-like Command Shell, w/ Filename Completion.
 *====================================================================*/
init:
   if RxFuncQuery("SysLoadFuncs") then                       
      do
      call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
      call SysLoadFuncs
      end

   if RxFuncQuery("VioLoadFuncs") then
      if RxFuncAdd('VioLoadFuncs','RexxVIO','VioLoadFuncs') then
         call RxFuncDrop('VioLoadFuncs')
      else
         call VioLoadFuncs

   vioPresent = (RxFuncQuery("VioGetCurType") = 0)

   if vioPresent then                                              
      oldCur = VioGetCurType()

   insertMode = '-80 -90'
   overwriteMode = '0 -100'   

   fileSeparator = ' =;<>|()'

   prevLine.0 = 0

   cmdList = 'CALL CD CHCP CHDIR CLS COPY DATE DETACH DIR DPATH ECHO',
             'ERASE DEL EXIT FOR IF KEYS MD MKDIR MOVE PATH PAUSE REM',
             'REN RENAME RD RMDIR SET START TIME TYPE VER VERIFY VOL'
                                                        
   shlList = 'ALIAS CD DEF DEFI DEFIN DEFINE KEYS QUIT RX'
                                                          
   invalidCmd = "call SysCurPos origRow + xlen % col, xlen // col;",
                "call charout 'STDOUT:', '1b'x'[1;31m'||xline'1b'x'[0m';",
                "xOfs = currOfs + 1"                      
                  
   helpColor1 = '1b'x'[34;47m'
   helpColor2 = '1b'x'[0m'                           
                                                     
   A_F10 = '0071'x                                     
   BKSP = '08'x;                    key._08   = 'backsp'
   CURD = '0050'x;                  key._0050 = 'cdown'
   CURL = '004b'x;                  key._004B = 'cleft'
   CURR = '004d'x;                  key._004D = 'cright'
   CURU = '0048'x;                  key._0048 = 'cup'
   C_CURL = '0073'x;                key._0073 = "ctrlleft"
   C_CURR = '0074'x;                key._0074 = "ctrlright"
   C_END = '0075'x;                 key._0075 = "ctrlend"
   C_HOME = '0077'x;                key._0077 = "ctrlhome"
   C_PGDN = '0076'x
   C_PGUP = '0084'x
   DEL = '0053'x;                   key._0053 = 'del'
   END = '004F'x;                   key._004F = 'end'
   ENTER = '0d'x;                   key._0D   = 'enter'
   ESC = '1b'x;                     key._1B   = 'esc'
   F1 = '003b'x;                    key._003B = 'f1'
   F10 = '0044'x
   F11 = '0085'x 
   F12 = '0086'x                                     
   F2 = '003c'x                                        
   F3 = '003d'x
   F4 = '003e'x   
   F5 = '003f'x               
   F6 = '0040'x
   F7 = '0041'x
   F8 = '0042'x
   F9 = '0043'x
   HOME = '0047'x;                  key._0047 = 'home'
   INS = '0052'x;                   key._0052 = 'ins'
   PGDN = '0051'x                                              
   PGUP = '0049'x                        
   S_TAB = '000F'x;                 key._000F = 'backtab'
   TAB = '09'x;                     key._09   = 'tab'
   SPACE = '20'x;                   key._20   = 'space'                     
                                              
   aliasNames = ''
   profileName = 'profile.shl'
        
   oldDir = directory()               
   secondaryPrompt = SysGetMessage(1093)
   helpString = SysGetMessage(1492)

   parse value SysOS2Ver() with osmajor "." osminor       
   if osmajor = '2' & osminor = '30' then /* Warp kludge :-) */
      parse value '3.00' with osmajor "." osminor
   verString = SysGetMessage(1090,,osmajor,osminor)
                                 
   global = 'helpString profileName profileFile verString aliasNames oldDir',
            'cmdList impCD shlList invalidCmd interactive helpColor1 helpColor2',
            'vioPresent insertMode overwriteMode fileSeparator'
   return                                  

terminate:
   if vioPresent then
      call VioSetCurType word(oldCur,1),word(oldCur,2),word(oldCur,3),word(oldCur,4)
   return

profile:
   interactive = 0                    
   profileFile = SysSearchPath('DPATH',profileName)
   if profileFile \= '' then do             
      do while lines(profileFile) > 0
         line = linein(profileFile)                       
         do while lines(profileFile) > 0 & right(line,1) = ','
            line = left(line,length(line)-1) linein(profileFile)
         end /* do */                              
         if left(line,1) = "'" | left(line,1) = '"' then
            interpret 'call eval' line
         else
            interpret line
      end /* do */                         
      call stream profileFile, 'c', 'close'
      end
   interactive = 1
   return

getline:                   
   procedure expose prevLine. key. insertState cmdQueue secondaryPrompt (global)

   parse value SysCurPos() with origRow origCol .
   parse value SysTextScreenSize() with row col

   parse value origRow origCol '1 0 0 0 0 0' insertState,
         with currRow currCol firstCup currOfs currTab len olen xOfs insert key line

   if vioPresent then
      if insert then
         call VioSetCurType word(insertMode,1), word(insertMode,2)
      else
         call VioSetCurType word(overwriteMode,1), word(overwriteMode,2)

   if arg(1) \= '' then
      do                           
      line = arg(1)         
      len = length(line)
      call charout "STDOUT:", left(line,max(len,olen))
      if origRow + (origCol + len) % col >= row then
         origRow = row - (origCol + len) % col - 1
      olen = len
      call SysCurPos origRow + (origCol + currOfs) % col, (origCol + currOfs) // col
      end                         

   currLine = prevLine.0   
                                
   do while (key <> "enter")
      lastKey = key              
      key = getKey()
      oline = line
                                    
      select
         when (length(key) = 1) then
            do                             
            if (insert) then
               line = insert(key,line,currOfs)
            else
               line = overlay(key,line,currOfs+1)

            currOfs = currOfs + 1
            end                    

         when (key = "backsp") then     
            do
            if (currOfs <= 0) then
               iterate
            line = delstr(line,currOfs,1)
            currOfs = currOfs - 1
            end                   

         when (key = "space") then                                                       
            do                                                  
            if (insert) then
               line = insert(' ',line,currOfs)              
            else
               line = overlay(' ',line,currOfs+1)
            if line \== oline then
               do                                            
               len = length(line)   
               if len > 0 & currOfs > 1 & currOfs > xOfs then   
                  if left(line,currOfs) == left(oline,currOfs) then
                     call charout "STDOUT:", substr(left(line,max(len,olen)),currOfs+1)
                  else                                     
                     do                                             
                     call SysCurPos origRow, origCol                
                     call charout "STDOUT:", left(line,max(len,olen))
                     end                                            
               else
                  do                    
                  call SysCurPos origRow, origCol
                  call charout "STDOUT:", left(line,max(len,olen))
                  end           
               if origRow + (origCol + len) % col >= row then
                  origRow = row - (origCol + len) % col - 1
               olen = len; oline = line
               end                                                                       
                                                                
            xOfs = 0; xline = translate(left(line,currOfs),'  ','()'); xlen = lastpos('&',xline)
            if lastpos('|',xline) > xlen then xlen = lastpos('|',xline)
            if xlen > 0 then 
               if verify(reverse(substr(xline,1,xlen-1)),"^") // 2 = 1 then
                  xline = substr(xline,xlen+1)
               else                                          
                  xline = ''                                                                         
            xlen = origCol + currOfs - length(strip(xline,'L')); xline = strip(xline)
            if xline \= '' & pos(' ',xline) = 0 then
               if impCD = 0 | SysSearchPath('CDPATH',xline) = '' then     
                  if wordpos(xline,aliasNames) = 0 then    
                     if wordpos(translate(xline),cmdList shlList) = 0 then
                        if left(xline,1) = '/' | left(xline,1) = '\' | substr(xline,2,1) = ':' then do
                           if stream(xline,'c','query exist') = '' then
                              if stream(xline'.exe','c','query exist') = '' then
                              if stream(xline'.cmd','c','query exist') = '' then
                              if stream(xline'.bat','c','query exist') = '' then
                              if stream(xline'.com','c','query exist') = '' then
                                 interpret invalidCmd
                           end
                        else
                           if SysSearchPath('PATH',xline) = '' then    
                              if SysSearchPath('PATH',xline'.exe') = '' then
                              if SysSearchPath('PATH',xline'.cmd') = '' then
                              if SysSearchPath('PATH',xline'.bat') = '' then
                              if SysSearchPath('PATH',xline'.com') = '' then
                                 interpret invalidCmd
            currOfs = currOfs + 1
            end                 

         when (key = "tab") then
            do                                
            if (currOfs <= 0) then
               iterate
            if (currTab \= 0) then
               do
               if (currTab = tree.0) then
                  currTab = 1
               else
                  currTab = currTab+1
               end
            else                                                                                     
               do         
               file = translate(space(translate(getFileSpec(left(line,currOfs)),' "','" '),0),' ','"')
               if (pos('*',file) = 0) then                                
                  file = file'*'
               call SysFileTree expand(translate(file,'\','/')),'tree','O','**-*-'
               if (tree.0 = 0) then
                  iterate
               if (tree.0 = 1 & tree.1'*' = expand(translate(file,'\','/'))) then
                  iterate
               currTab = 1
               end                                                 
                                                         
            newf = filespec("d",file)filespec("p",file)filespec("n",tree.currTab)
            if (pos(' ',newf) > 0) then newf = '"'newf'"'
            subl = left(line,currOfs-length(getFileSpec(left(line,currOfs))))newf
            line = subl||substr(line,currOfs+1)
            currOfs = length(subl)                
            end                               

         when (key = "backtab") then          
            do
            if (currOfs <= 0) then
               iterate
            if (currTab \= 0) then
               do
               if (currTab = 1) then
                  currTab = tree.0
               else
                  currTab = currTab-1
               end
            else                   
               do
               file = translate(space(translate(getFileSpec(left(line,currOfs)),' "','" '),0),' ','"')
               if (pos('*',file) = 0) then
                  file = file'*'
               call SysFileTree expand(translate(file,'\','/')),'tree','O','**-*-'
               if (tree.0 = 0) then
                  iterate
               if (tree.0 = 1 & tree.1'*' = expand(translate(file,'\','/'))) then
                  iterate
               currTab = tree.0   
               end

            newf = filespec("d",file)filespec("p",file)filespec("n",tree.currTab)
            if (pos(' ',newf) > 0) then newf = '"'newf'"'
            subl = left(line,currOfs-length(getFileSpec(left(line,currOfs))))newf
            line = subl||substr(line,currOfs+1)   
            currOfs = length(subl)
            end
                                
         when (key = "f1") & (line \= "") then
            do prevLine.0  
               currLine = currLine-1
               if (currLine <= 0) then
                  currLine = prevLine.0

               if (left(prevLine.currLine,currOfs) = left(line,currOfs)) then
                  do
                  line = prevLine.currLine
                  leave
                  end
            end                      

         when (key = "cright") then
            do
            if (currOfs < len) then
               currOfs = currOfs + 1
            end                                      

         when (key = "cleft") then
            do                        
            if (currOfs > 0) then
               currOfs = currOfs - 1
            end
                                 
         when (key = "cup") | (key = "cdown") then
            do
            if (prevLine.0 = 0) then
               iterate          

            if (key = "cup") then
               do
               if (firstCup) then
                  firstCup = 0                                  
               else                 
                  currLine = currLine - 1
               end                                  
            else                     
               currLine = currLine + 1
                                     
            if (currLine <= 0) then
               currLine = prevLine.0

            if (currLine > prevLine.0) then          
               currLine = 1
                                                     
            line = prevLine.currLine  
            currOfs = length(line)
            end                       

         when (key = "del") then
            line = delstr(line,currOfs+1,1)

         when (key = "home") then
            currOfs = 0
                                
         when (key = "end") then
            currOfs = len
                                     
         when (key = "esc") then                                
            do
            line    = ""                                        
            currOfs = 0                             
            end
                                                    
         when (key = "ctrlend") then
            line = left(line,currOfs)
                                  
         when (key = "ctrlhome") then
            do
            line = substr(line,currOfs+1)
            currOfs = 0
            end

         when (key = "ctrlleft") & (currOfs > 0) then
            currOfs = wordindex(line,words(left(line,currOfs)))-1
                      
         when (key = "ctrlright") then                       
            do        
            currTab = wordindex(line,words(left(line,currOfs+1))+1)-1
            if (currTab >= 0) then
               currOfs = currTab
            end

         when (key = "ins") then                              
            do
            insert = \ insert
            if vioPresent then
               if insert then
                  call VioSetCurType word(insertMode,1), word(insertMode,2)
               else         
                  call VioSetCurType word(overwriteMode,1), word(overwriteMode,2)
            iterate
            end                      

         when (abbrev('OSNOWAIT',translate(word(key,1)),3)) then
            call eval subword(key,2)        

         when (translate(word(key,1)) = 'TEXT') then
            do
            if (insert) then      
               line = insert(subword(key,2),line,currOfs)
            else
               line = overlay(subword(key,2),line,currOfs+1)

            currOfs = currOfs + length(subword(key,2))
            end                                                       
            
         otherwise                                           
            nop
      end                                                    
                          
      if (key \= "tab" & key \= "backtab") then
         currTab = 0                                         

      if (line \== oline) then                                
         do
         len = length(line)                                   
         if len > 0 & currOfs > 1 & currOfs > xOfs & length(key) = 1 then
            if left(line,currOfs-1) == left(oline,currOfs-1) then
               call charout "STDOUT:", substr(left(line,max(len,olen)),currOfs)
            else            
               do 
               call SysCurPos origRow, origCol                        
               call charout "STDOUT:", left(line,max(len,olen))
               end
         else
            do                              
            call SysCurPos origRow, origCol
            call charout "STDOUT:", left(line,max(len,olen))
            end
         if origRow + (origCol + len) % col >= row then
            origRow = row - (origCol + len) % col - 1                 
         olen = len               
         end                               

      call SysCurPos origRow + (origCol + currOfs) % col, (origCol + currOfs) // col
   end                                                                
                                                                      
   if (line <> "") & (lastKey <> "cup") & (lastKey <> "cdown") then   
      do    
      o = prevLine.0 + 1         
      prevLine.0 = o      
      prevLine.o = line                       
      end                                                    
   else                                       
   if (cmdQueue = 1) & ((lastKey = "cup") | (lastKey = "cdown")) then
      do
      do i = currLine to prevLine.0 - 1                               
         j = i + 1
         prevLine.i = prevLine.j
      end /* do */
      call value 'prevLine.'prevLine.0, line
      end
                                                                        
   call SysCurPos origRow + (origCol + len) % col, (origCol + len) // col
   say                                                                
       
   if (line \= "" & verify(reverse(line),"^") // 2 = 0) then
      do
      call charout "STDOUT:", secondaryPrompt
      line = left(line,len-1) getLine()
      end                                       
                                                                      
   return line                    
                                                                      
/*------------------------------------------------------------------
 * get file spec                           
 *------------------------------------------------------------------*/
getFileSpec:                                                          
   l = length(arg(1))
   do forever                                                         
      select                                    
         when (l < 1) then do; l = 0; leave; end
         when pos(substr(arg(1),l,1), fileSeparator) > 0 then leave
         when (substr(arg(1),l,1) = '"') then l = lastpos('"',arg(1),l-1)
      otherwise                                 
         nop
      end
      l = l - 1                                                       
   end 
   return substr(arg(1),l+1)
                       
/*------------------------------------------------------------------
 * get key     
 *------------------------------------------------------------------*/  
getKey:
   call on halt name ignore                                             
      
   key  = SysGetKey("NOECHO")
   ckey = c2x(key)                                                      
                         
   /*---------------------------------------------------------------
    * get second 'key' if needed                
    *---------------------------------------------------------------*/
   if (ckey = "E0") | (ckey = "00") then        
      ckey = "00" || c2x(SysGetKey("NOECHO"))   
                                
   /*---------------------------------------------------------------
    * look it up                                
    *---------------------------------------------------------------*/
   ckey = "_"ckey                               

   if (symbol("key."ckey) = "LIT") then         
      return key
   else                                         
      return key.ckey
                                                
/*------------------------------------------------------------------
 * handle break                                 
 *------------------------------------------------------------------*/
ignore:           
   return ""
                       
/*====================================================================
 * Interpret Command-line Arguments.
 *====================================================================*/
doarg:         
   lineArg = arg(1)       

   do while lineArg \= ''
      parse value lineArg with switch lineArg                           
     
      select                                                            
         when switch = '/O' | switch = '/o' then insertState = 0
         when switch = '/I' | switch = '/i' then insertState = 1            
         when switch = '/?' then do
            say cmdHelp         
            exit
            end                             
         when switch = '/C' | switch = '/c' then do
            call eval lineArg         
            exit                      
            end     
         when switch = '/K' | switch = '/k' then do
            call eval lineArg
            leave      
            end                          
         when switch = '/P' | switch = '/p' then do
            parse value lineArg with profileName lineArg
            end        
      otherwise                            
         say SysGetMessage(1003) 
         exit 1
      end  /* select */
                                                
   end /* do */
                  
   return                      
                          
/*====================================================================
 * A cmd.exe-like Command Evaluator.
 *====================================================================*/
eval:                                                         
   cmdLine = strip(arg(1),'L')                           
   needcr = 1; xlen = length(cmdLine); xpos = 1
                                                                            
   do while xpos <= xlen
      /* parsing command line */                                            
      inStr = 0; inSub = 0; xcur = xpos
      do while xpos <= xlen                 
         ch = substr(cmdLine,xpos,1); xpos = xpos + 1
                                            
         if ch = '"' then inStr = inStr && 1
         else                           
         if \inStr then do            
            if ch = '^' then xpos = xpos + 1
            else                                                  
            if ch = '&' & inSub = 0 then leave
            else                        
            if ch = '(' then inSub = inSub + 1
            else                        
            if ch = ')' then inSub = inSub - 1
            end                  
      end /* do */                         
      parse value substr(cmdLine,xcur,xpos-xcur) with cmd args
                                                
      if right(args,1) = '&' & right(args,2) \= '^&' then
         args = left(args,length(args)-1)       
                               
      ucmd = translate(cmd)    
                               
      if args = '' & impCD = 1 then do
         curDir = directory()
         if dir(cmd) \= '' then do                            
            oldDir = curDir                              
            iterate                                           
            end                                                         
         end                                                                

      select                   
         when (wordpos(cmd,arg(2)) = 0) & (wordpos(cmd,aliasNames) > 0) then do
            call eval substitute(aliasStem.cmd,cmd args), arg(2) cmd
            needcr = 0                     
            end                       
         when wordpos(ucmd,shlList) > 0 then
            select
               when (ucmd = 'CD') then call cd args
               when (ucmd = 'RX') then do                         
                  signal on syntax name error
                  interpret args                                  
                  needcr = 0            
                  end                        
               when (ucmd = 'ALIAS') then call alias args
               when (ucmd = 'KEYS') then   
                  if translate(args) = 'LIST' then
                     do key = 1 to prevLine.0
                        say right(key,5)':' prevLine.key
                     end /* do */               
                  else
                     ''cmd args   
               when abbrev('DEFINE',ucmd,3) then do
                  needcr = 0  
                  parse value args with key rest
                  if key = '/?' then do
                     say defHelp
                     iterate                                  
                     end                                 
                  if length(key) > 1 then                               
                     if symbol(translate(key,'_','-')) = 'VAR' then
                        key = value(translate(key,'_','-'))             
                     else do
                        say SysGetMessage(1003)     
                        iterate        
                        end                    
                  if rest \= '' then       
                     call value 'key._'c2x(key), rest
                  else                  
                     interpret 'drop key._'c2x(key)
                  end                  
               when (ucmd = 'QUIT') then return 0                 
            otherwise                   
            end      
         when wordpos(ucmd, cmdList) > 0 | left(ucmd,1) = '(' then
            cmd args  
      otherwise
         'call' cmd args
      end /* select */
   end              

   if arg(1) \= '' & interactive & needcr then say
                    
   return 1                   
                               
error:                     
   say 'REX'right(rc,4,'0')':' errortext(rc)nl
   if condition('I') = 'SIGNAL' then
      signal loop
   else                                        
      return  
                                                                        
substitute: 
   procedure
   symb = arg(1); actual = arg(2); xpos = 1; xlen = length(symb); r = ''; inSubst = 0
   do while xpos <= xlen                            
      ch = substr(symb,xpos,1); xpos = xpos + 1
      if ch = '^' then do                           
         r = r || substr(symb,xpos,1)
         xpos = xpos + 1                       
         end                      
      else                               
      if ch = '%' & inSubst = 0 then inSubst=1
      else                
      if inSubst = 1 then do            
         inSubst = 0
         if pos(ch,0123456789) > 0 then
            if substr(symb,xpos,1) = '*' then do
               r = r || subword(actual,ch+1)
               xpos = xpos+1              
               end     
            else    
               r = r || word(actual,ch+1)
         else                           
         if ch = '*' then
            r = r || subword(actual,2)  
         else
            r = r'%'ch     
         end     
      else                 
         r = r || ch                               
   end /* do */                                
   if inSubst = 1 then              
      r = r'%'                                 
   return r

expand: 
   procedure
   args = arg(1); xpos = pos('%',args)+1
   if xpos > 1 then do
      ypos = pos('%',args,xpos)
      if ypos > 0 then do
         envi = substr(args,xpos,ypos-xpos)
         valu = value(envi,,'OS2ENVIRONMENT')
         if valu = '' then
            args = left(args,xpos-1) || envi || expand(substr(args,ypos))
         else
            args = left(args,xpos-2) || valu || expand(substr(args,ypos+1))
         end
      end
   return args

dir: 
   procedure                         
   parse value expand(arg(1)) with args                
   if left(args,1) = '"' then args = strip(args,,'"')
   if directory(args) = '' then do       
      cdpath = value('CDPATH',,'OS2ENVIRONMENT')
      do while cdpath \= ''
         parse value cdpath with path ';' cdpath
         if pos(right(path,1),'\/') = 0 then
            path = path'\'
         if directory(path||args) \= '' then do
            return directory()       
            end                     
      end /* do */                   
      return ''                           
      end              
   return directory()                     
                       
cd:                                     
   parse value arg(1) with args
                                        
   curDir = directory() 
   select                               
      when args = '-' then
         call directory oldDir
      when args = '/?' then do                     
         '@CD /?'                              
         say cdHelp                                
         end
      when args = '' | right(args,1) = ':' then do
         say directory(args)
         call directory(curDir)
         end                         
   otherwise         
      if dir(args) = '' then do      
         say SysGetMessage(0003)
         needcr = 0          
         end
   end  /* select */
   oldDir = curDir 
      
   return          
                                     
alias: 
   procedure expose aliasHelp aliasNames aliasStem.
         
   parse value arg(1) with subcmd '>' file
                       
   select      
      when translate(subcmd) = 'LIST' then
         if (file \= '') then do        
            do alias = 1 to words(aliasNames)
               name = word(aliasNames,alias)
               call lineout file,name'='aliasStem.name
            end /* do */
            call stream file,'c','close'
            end
         else                                      
            do alias = 1 to words(aliasNames)
               name = word(aliasNames,alias)
               say right(alias,4) left(name,10) '=' aliasStem.name
            end
      when left(subcmd,1) = '@' then do
         file = substr(subcmd,2)
         do while lines(file) > 0    
            call addalias linein(file)
         end /* do */        
         call stream file,'c','close'
         end
      when subcmd = '/?' then do
         say aliasHelp
         end       
   otherwise
      call addalias arg(1)
   end /* select */
   return                           

addalias:      
   parse value arg(1) with alias '=' cmd
   alias = strip(alias)
   if cmd \= '' then do
      if wordpos(alias,aliasNames) = 0 then
         aliasNames = aliasNames alias
      aliasStem.alias = cmd
      end
   else do
      parse value aliasNames with first (alias) last
      aliasNames = first last
      end
   return

