Program PWTNDEMO;
{$A+,B-,D+,F-,G+,I-,K+,L+,N-,P+,Q+,R+,S+,T+,V+,W+,X+,Y+}
{$M 8192,8192}
{Simple Telnet Client for PWTN}

Uses WinTypes, WinProcs, WinCrt, Strings, UseTcp4W;

Const LTIL = 9900; {Long Text Item Length}

Type PLTI = ^TLTI;   {Long Text Item}
     TLTI = Array [0..LTIL] Of Char;

Var Status, Port: Integer;
    S: TSocket;
    T: TLTI;
    SaveExitProc : Pointer;

Procedure CheckStatus;
  Begin
    If Status > 0 Then Exit;
    WriteLn ('?', TCP4W_Error (Status));
    Halt
  End;

Procedure HandleTelnetControl (S: TSocket; P: PLTI; Len: Integer);
  {See RFC 854, 855, 930 at www.internic.net}
  Begin
    WriteLn;
    If (P^[1] = #253) And (P^[2] = #24) Then
      Begin
        P^[1] := #251;
        TcpSend (S, P^, 3, False, -1);
        Exit
      End;
    If (P^[1] = #250) And (P^[2] = #24) Then
      Begin
        StrPCopy (P^, #255#250#24#0'UNKNOWN'#255#240);
        TcpSend (S, P^, 13, False, -1);
        Exit
      End;
    If (P^[1] = #251) Then
      Begin
        If P^[2] = #1 Then P^[1] := #253 Else P^ [1] := #254;
        TcpSend (S, P^, 3, False, -1);
        Exit
      End;
    If (P^[1] = #252) Then
      Begin
        P^ [1] := #254;
        TcpSend (S, P^, 3, False, -1);
        Exit
      End;
  End;

Function TelnetRecv (S: TSocket; P: PLTI; MaxLen: Integer): Integer;
  Var Len, Start, I: Integer;
      H: String;
  Begin
    Len := TCPRecv (S, P^, MaxLen, 10, -1);
    TelnetRecv := Len;
    If Len <= 0 Then
      Begin
        P^[0] := #0;
        Exit
      End;
    H := '';
    Start := -1;
    I := 0;
    While I < Len Do
      Begin
        If (P^[I] = #255) And (Start = -1) Then
          Start := I;
        If Start >= 0 Then H := H + P^[I];
        If ((Start >= 0) And (P^[I] = #240)) Or
           ((Start >= 0) And (Start = I-2) And (H [2] <> #250)) Then
          Begin
            HandleTelnetControl (S, PLTI (@H [1]), Length (H));
            Move (P^[I+1], P^[Start], Len-I-1);
            Len := Len - (I-Start+1);
            I := Start-1;
            H := '';
            Start := -1;
          End;
        If I >= 0 Then
          If P^[I] = #0 Then P^[I] := #4;
       Inc (I);
      End;
    P^[Len] := #0
  End;

Procedure MainLoop;
  Var I, J: Integer;
  Begin
    Write (#129);
    Repeat
      If KeyPressed Then
        Begin
          T [0] := ReadKey;
          If T [0] = #3 Then Exit;
          T [1] := #0;
          Status := TcpSend (S, T, 1, False, -1);
          CheckStatus;
        End;
      If TCPIsDataAvail (S) > 0 Then
        Begin
          Write (#8#32#8);
          Status := TelnetRecv (S, @T, LTIL);
          CheckStatus;
          J := StrLen (T);
          For I := 0 To J-1 Do
            If (T [I] = #13) And (T [I+1] = #4) Then
              T [I] := #4;
          Write (T, #129);
        End;
    Until False;
  End;

Procedure MyExitProc; Far;
  Begin
    ExitProc := SaveExitProc;
    If S <> 0 Then TcpClose (S);
  End;

Begin
  CheckBreak := False;
  CmdShow := sw_ShowMaximized;
  AutoTracking := False;
  TCP4WInit;
  WriteLn ('Simple Telnet Client by AStA (Andreas.Tikart@uni-konstanz.de) <Polarwolf>');
  TCP4WVer (T, LTIL);
  WriteLn (T);
  WriteLn;
  S := 0;
  SaveExitProc := ExitProc;
  ExitProc := @MyExitProc;

  Write ('Host:');
  ReadLn (T);
  Port := 23;
  Status := TcpConnect (S, T, '', Port);
  CheckStatus;
  MainLoop;
  Status := TcpClose (S);
  S := 0;
  CheckStatus;
  ExitProc := SaveExitProc;
  DoneWinCrt;
End.
