Program PWTN;
{$A+,B-,D+,F-,G+,I-,K+,L+,N-,P+,Q+,R+,S+,T+,V+,W+,X+,Y+}
{$M 8192,8192}
{Simple Koala Client for TCP4W}

Uses WinTypes, WinProcs, WinCrt, Strings, UseTcp4w;

Const LTIL = $7000;

Type PLongTextItem = ^TLongTextItem;
     TLongTextItem = Array [0..LTIL] Of Char;

Var Status: Integer;
    S: TSocket;
    Port: Integer;
    T: PLongTextItem;
    SaveExitProc : Pointer;

Procedure WriteWinsockVerInfo;
  Const WSADESCRIPTION_LEN = 256;
        WSASYS_STATUS_LEN = 128;
  Type TWSAData = Record
           wVersion: Word;
           wHighVersion: Word;
           szDescription: Array [0..WSADESCRIPTION_LEN] Of Char;
           szSystemStatus: Array [0..WSASYS_STATUS_LEN] Of Char;
           iMaxSockets: Byte;
           iMaxUdpDg: Byte;
           lpVendorInfo: Pointer;
         End;
       TWSAStartUp = Function (wVersionRequested: Word; WSAData: TWSAData): Integer;
       TWSACleanup = Function: Integer;
  Var WSAData: TWSAData;
      hWinsock: THandle;
      FP : TFarProc;
  Begin
    hWinsock := LoadLibrary ('WINSOCK');
    If hWinsock >= 32 Then
      Begin
        FP := GetProcAddress (hWinsock, 'WSAStartup');
        If FP <> NIL Then
          If TWSAStartUp (FP) (257, WSAData) = 0 Then
            WriteLn (WSAData.szDescription);
        FP := GetProcAddress (hWinsock, 'WSACleanup');
        If FP <> NIL Then TWSACleanUp (FP);
        FreeLibrary (hWinsock)
      End
  End;

Procedure CheckStatus;
  Begin
    If Status > 0 Then Exit;
    WriteLn;
    WriteLn ('?', Tcp4W_Error (Status));
    Halt
  End;

Procedure MyExitProc; Far;
  Begin
    ExitProc := SaveExitProc;
    If S <> 0 Then TcpClose (S);
    Tcp4WCleanup;
  End;

Procedure GetAnswer;
  Begin
    Status := TcpRecv (S, T^, LTIL, 1000, -1);
    CheckStatus;
    T^[Status] := #0;
    Write (T^)
  End;

Procedure MainLoop;
  Begin
    Repeat
      ReadLn (T^);
      StrCat (T^, #13#10);
      If StrLIComp (T^, 'EXIT', 4) = 0 Then Exit;
      If StrLIComp (T^, 'ENDE', 4) = 0 Then Exit;
      If StrLIComp (T^, 'QUIT', 4) = 0 Then Exit;
      Status := TcpSend (S, T^, StrLen (T^) , False, -1);
      CheckStatus;
      GetAnswer;
    Until False
  End;

Begin
  CheckBreak := False;
  CmdShow := sw_ShowMaximized;
  AutoTracking := False;
  New (T);
  WriteLn ('Simple Koala Client by AStA (Andreas.Tikart@uni-konstanz.de) <Polarwolf>');
  Tcp4wVer (T^, 0);
  WriteLn (T^);
  WriteWinsockVerInfo;
  WriteLn;
  S := 0;
  Port := 775;
  SaveExitProc := ExitProc;
  ExitProc := @MyExitProc;
  Status := Tcp4wInit;
  CheckStatus;

  Status := TcpConnect (S, 'polydos.uni-konstanz.de', '', Port);
  CheckStatus;

  GetAnswer;
  GetAnswer;
  MainLoop;
  TcpClose (S);
  S := 0;
  CheckStatus;
  Tcp4WCleanUp;
  ExitProc := SaveExitProc;
  DoneWinCrt;
End.
