/**
***  IPDial     Script program for initializing a SLIP connection
***  Copyright  (C)   1994    Jochen Wiedmann
***
***  This program is free software; you can redistribute it and/or modify
***  it under the terms of the GNU General Public License as published by
***  the Free Software Foundation; either version 2 of the License, or
***  (at your option) any later version.
***
***  This program is distributed in the hope that it will be useful,
***  but WITHOUT ANY WARRANTY; without even the implied warranty of
***  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
***  GNU General Public License for more details.
***
***  You should have received a copy of the GNU General Public License
***  along with this program; if not, write to the Free Software
***  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***
***
***
***  This file contains a function to set an environment variable.
***
***
***  Computer: Amiga 1200                       Compiler: Dice 3.01
***
***  Author:    Jochen Wiedmann
***             Am Eisteich 9
***             72555 Metzingen
***             Germany
***
***             Phone: (+0049) 7123 / 14881
***             Internet: wiedmann@neckar-alb.de
**/





/**
***  Include files
**/
#define __USE_SYSBASE
#ifndef IPDIAL_H
#include "IPDial.h"
#endif
#include <exec/execbase.h>



ULONG setvar(STRPTR var, STRPTR val, ULONG flags)

{ LONG save = FALSE;
  ULONG success = TRUE;

  if (flags & GVF_SAVE_VAR) {
      flags |= GVF_GLOBAL_ONLY;
  }
  if ((flags & GVF_SAVE_VAR)  &&  SysBase->LibNode.lib_Version < 39)
  { flags &= ~GVF_SAVE_VAR;
    save = TRUE;
  }

  if (!SetVar(var, val, -1, LV_VAR | flags))
  { return(FALSE);
  }

  if (save)
  { BPTR dir, oldDir;
    BPTR file;

    success = FALSE;

    if ((dir = Lock((STRPTR) "ENVARC:", SHARED_LOCK)))
    { oldDir = CurrentDir(dir);

      if ((file = Open(var, MODE_NEWFILE)))
      { LONG len = strlen((char*) val);

	if (Write(file, val, len) == len)
	{ success = TRUE;
	}

	Close(file);
      }

      CurrentDir(oldDir);
    }
  }

  return(success);
}
