;****************************************************************************/
;*                                                                          */
;* Module Name: password.asm    version: 2.04,          Date: 12/06/95      */
;*                                                                          */
;* Designer(s): Joe Gruessing,                                              */
;*              Adapted from public domain sources. See "HISTORY" below.    */                         */
;*                                                                          */
;* Description: This program is loaded as device in CONFIG.SYS and requires */
;*              the user to  enter  the "proper" password to continue  boot */
;*              process. Failure  to enter correct password after "n" tries */
;*              ("n" as defined below) results  in  a cold reboot. Also, if */
;*              the  user  input remains  idle for "n" seconds, the  system */
;*              will be rebooted. Keypresses refresh the timeout counter.   */
;*                                                                          */
;*              A success results in the continuation of CONFIG.SYS.  It is */
;*              intended that this program be used with the multiple config */
;*              capabilities of MSDOS 6.xx, or DataLight ROM-DOS 6.22.      */
;*                                                                          */
;*              Passwords are not case-sensitive in this program!           */
;*                                                                          */
;*                                                                          */
;* Assembler:   Borland Turbo Assembler, v4.0,                              */
;*                                                                          */
;*              Tested with ASM Checker by V. Communications                */
;*                                                                          */
;****************************************************************************/
;**************** Copyright (C) 1995, Joseph A. Gruessing Jr. ***************/
;****************************************************************************/
;*                                                                          */
;* HISTORY:                                                                 */
;*                                                                          */
;* 07/10/95                                                                 */
;* 2.00 JAG     Initial adaptation from assembly source "password.asm"      */
;*              by Cristoph Christ (v1.01 dated 1.11.92) in the Simtel      */
;*              archive file: "msdos/security/passw11.zip"                  */
;*                                                                          */
;*              Changes:                                                    */
;*                                                                          */
;*              - removed copyright notice printing to stdout               */
;*              - changed output strings to be similar to a Unix login      */
;*              - fixed backspace behavior when at leftmost position        */
;*              - fixed so input cannot include ascii below space character */
;*              - user *must* hit return to process entered password        */
;*              - max password length reduced to 8 characters               */
;*              - changed read int 21h, function 8 to function 7 so that    */
;*                ^C would not be printed on screen! Same for function 6    */
;*              - changed system halt on repeated failures to a reboot      */
;*              - added timeout capability, if no keypress after n seconds, */
;*                system will reboot                                        */
;*              - removed case-sensitivity by borrowing routine from "PW.8" */
;*                by Bob Montgomery, in the simtel archive file:            */
;*                           "msdos/security/passwrd6.zip"                  */
;*                                                                          */
;* 08/06/95                                                                 */
;* 2.01 JAG     - replaced my int19 bootstrap with 286 bus reset            */
;*              - fixed error accepting password after backspace            */
;*              - fixed indexing on backspace                               */
;*              - released binary in distribution of company project        */
;*                                                                          */
;* 10/15/95                                                                 */
;* 2.02 JAG     - Cleaned up for general release, redundant code removed,   */
;*                internal calls rewritten as procedures                    */
;* 10/16/95                                                                 */
;* 2.03 JAG     - Fixed index error in Input at "Weiter:" label. Added      */
;*                reboot message and delay.                                 */
;*                                                                          */
;* 12/06/95     - No change to sources. Added FILE_ID.DIZ to archive for    */
;*                BBS description usage                                     */
;*                                                                          */
;****************************************************************************/
;* NOTE:        THIS CODE IS NOT PUBLIC DOMAIN! AUTHOR RETAINS COPYRIGHT.   */
;*              YOU MAY DISTRIBUTE, USE, OR MODIFY AS YOU SEE FIT AS LONG   */
;*              AS COPYRIGHT NOTICE AND ALL  COMMENTS ARE RETAINED IN THE   */
;*              RESULTING SOURCE FILE. YOU MAY *NOT* SELL THIS SOURCE FOR   */
;*              PROFIT--EXCEPT AS A PART OF A SHAREWARE COLLECTION.         */
;****************************************************************************/

; Compiler directives ********************************************************

.8086                                   ; base CPU support

; External data references used **********************************************

DOSClock       EQU 046ch                ; DOS Clock used for input timeout

; Macros used ****************************************************************

PushAll Macro                           ; save all registers
  push ax                               ;
  push bx                               ;
  push cx                               ;
  push dx                               ;
  push si                               ;
  push di                               ;
  push bp                               ;
  push ds                               ;
  push es                               ;
EndM                                    ;

PopAll Macro                            ; restore all registers
  pop es                                ;
  pop ds                                ;
  pop bp                                ;
  pop di                                ;
  pop si                                ;
  pop dx                                ;
  pop cx                                ;
  pop bx                                ;
  pop ax                                ;
EndM                                    ;



Code    Segment byte public
        Assume cs:Code, ds:Code, es:Code

        org    0



Passwrd proc   far

; Device header **************************************************************

Next_Driver    DD 0FFFFFFFFh            ; one device in this file
Attributes     DW 0                     ;
StrategyProc   DW OFFSET Strategy       ; pointer to entry point
CommandsProc   DW OFFSET Commands       ; pointer to proc handling services
Device_Name    DB 'PWAMCXYZ'            ; name of this block device




; Variables ******************************************************************
;
; 1. data: {length password},{password},(length input-length password)*{nulls}
;          {length input},{current length}, length input*{nulls}
;
; 2. Encrypted password value determined by Password[x] = Password[x]^x
;

Password       DB 5, 'FWFWQ', 3 dup(0) ; "GUEST" is default build password
Input          DB 8, 0, 8 dup(0)       ; 

; user prompts ---------------------------------------------------------------

Prompt         DB 13, 10, 13, 10, 'Password: $'                        
AccessMsg      DB 13, 10, 'Password accepted.', 13, 10, 13, 10, '$'     
InvalidPwd     DB 13, 10, 'Password incorrect.', '$'         
TimeoutMsg     DB 13, 10, 'Timeout occurred.','$'
NoAccess       DB ' Rebooting...','$'

; test flag and # retries ----------------------------------------------------

Counter        DB 2                     ; 0,1,2-> 3 tries and reboot
Passed         DB 1                     ; 0= True 1= False

; timeout value and counters -------------------------------------------------

Timeout        EQU 0222h                ; 18.2 ticks/s * 30s= 546 ticks
RebootTimeout  EQU 0037h                ; pause 2 seconds before reboot
StartTime      DW 0                     ;
TimeElapsed    DW 0                     ;



; Request header *************************************************************

Params         DD 0                     ; Address of the Request header

Request struc                           ;
   Len         db 0                     ;
   Unit        db 0                     ;
   CommandCode db 0                     ;
   Status      dw 0                     ;
   CountUnits  db 0                     ;
   EndAdress   dd 0                     ;
   BIOS_Param  dd 0                     ;
   DriveNr     db 0                     ;
   ConfigError dw 0                     ;
Request ends                            ;

Passwrd endp

; Strategy Entry Point *******************************************************

Strategy proc far                       ; External Entry Point       
         mov Word Ptr Params, bx        ; Request Header is stored at this
         mov Word Ptr Params + 2, es    ; location
         retf                           ; 
Strategy endp                           ;




; Commands Entry Point *******************************************************

Commands proc far                       ;
         cmp cs:passed, 0               ; did user enter correct password?
         je Exit                        ; yes, return to system
         PushAll                        ;
         mov ax, cs                     ; set Datasegment to Codesegment
         mov ds, ax                     ; ""
         mov es, ax                     ; ""
         call Encrypt                   ;
Read:                                   ;
         mov dx, offset Prompt          ;
         call PrintStr                  ; print "Password: " prompt
         call ReadString                ; get user input
         Call ScanLine                  ; test user input
         jz OK                          ; is password ok?
         cmp Counter, 0                 ; no. Any tries left?
         jne Read2                      ; yes. Continue at read2
         mov dx, offset InvalidPwd      ; else
         call PrintStr                  ;  print "Password incorrect"
         call Reboot                    ;  and reboot
         inc Counter                    ; get here only if reboot failed
Read2:                                  ; i know this looks silly :-)
         dec Counter                    ; decrement tries left
         mov dx, offset InvalidPwd      ;
         call PrintStr                  ; print "Password incorrect"
         jmp short Read                 ;
OK:                                     ;
         mov dx, offset AccessMsg       ;
         call PrintStr                  ; print "Password accepted"
         mov passed, 0                  ; flag that user entered correct pwd
         PopAll                         ; get all previous saved Registers
Exit:                                   ;
         retf                           ; return to system

Commands endp




; Encryption Procedure -------------------------------------------------------

Encrypt  proc near                      ;
         mov di, 1                      ; start from Byte 1 (not 0!!)
         mov cl, byte ptr Password      ; cx= length to encrypt the Password
         cbw                            ; convert byte to word
         mov bx, offset Password        ; bx= ofs(Password) ds= Seg(P.W.)
L1:                                     ;
         mov al, es:[bx + di]           ; al= Password[di]
         mov dx, di                     ; 
         xor al, dl                     ; al= al^di
         mov es:[bx + di], al           ; Password[di]= al
         inc di                         ; next character from String
         loopnz L1                      ; loop if zf= 0, cx > 0
         retn                           ;
encrypt  endp                           ;



;  Get Character Procedure ---------------------------------------------------

GetChar proc near                       ; 08/05/95 JAG - section rewritten
        call GetTime                    ; get the start minutes
        mov cx, TimeElapsed             ;
        mov word ptr StartTime, cx      ;
GetChar2:                               ;
        call GetTime                    ; get the elapsed minutes
        mov cx, TimeElapsed             ;
        sub cx, word ptr StartTime      ; (elapsed - start time)
        cmp cx, Timeout                 ; timeout occurred?
        jbe GetChar3                    ;
        mov dx, offset TimeoutMsg       ; yes,
        call PrintStr                   ; print "Timeout occurred. "
        call Reboot                     ; and call reboot
GetChar3:                               ;
        push dx                         ; preserve maxstrlen
        mov ah, 06h                     ; DOS service 6, subfunction FFh:
        mov dl, 0ffh                    ; get keypress while ignoring ^C's
        int 21h                         ; and don't wait if none available!
        pop dx                          ;
        jz GetChar2                     ; no char was available so loop
        ret                             ;
GetChar endp                            ;



; Get Time in Ticks Procedure ------------------------------------------------

GetTime proc near                       ; 08/05/95 addition: get system time
        PushAll                         ;
        xor ax, ax                      ;
        mov es, ax                      ; simulation segment to 0
        mov cx, es:[DOSClock]           ;
        mov TimeElapsed, cx             ; get time elapsed in ticks
        PopAll                          ;
        retn                            ;
GetTime endp                            ;





; Print Character to CRT Procedure -------------------------------------------

OutChar proc near                       ;
        push dx                         ; DOS service 2:
        mov ah, 02h                     ; output character in dl to CRT
        mov dl, al                      ;
        int 21h                         ;
        pop dx                          ;
        retn                            ;
Outchar endp                            ;




; Print String to CRT Procedure ----------------------------------------------

printstr proc near                      ;
         mov ah, 09H                    ; DOS service 9:
         int 21H                        ; output string at ds:dx ending in '$'
         retn                           ;
printstr endp                           ;



; Read and Process String ----------------------------------------------------

ReadString proc near                    ;
        mov bx, offset Input            ; bx= *Input[0], ptr to max length
        xor dh, dh                      ;
        mov dl, byte ptr es:[bx]        ; dx= Input[0], max length of input
        mov byte ptr es:[bx + 1], 0     ; initialize Input[1] = 0
        xor di, di                      ; offset counter
 Repeat:                                ;
        call GetChar                    ;
        cmp al, 32                      ; above a space ?
        ja Weiter                       ; yes, go get character
        cmp al, 13                      ; a carriage return ?
        je RepeatQuit                   ; yes, go test user's password
        cmp al, 8                       ; a backspace ?
        jne Repeat                      ; no, so ignore
        cmp di, 0                       ; yes, are we at leftmost position ?
        jbe Repeat                      ; yes, so ignore
        dec di                          ; no, do a backspace
        mov ax, di                      ; 
        dec ax                          ; new stringlength after backspace:
        mov byte ptr es:[bx + 1], al    ;       Input[1] = di-1
        mov al, 8                       ; remove last character from screen
        call OutChar                    ; ""
        mov al, 32                      ; by overwriting it with a space
        call OutChar                    ; ""
        mov al, 8                       ; and backing up cursor
        call OutChar                    ; ""
        jmp Repeat                      ; loop until a carriage return
 Weiter:                                ;
        cmp di, dx                      ; current length < maximum length ?
        jge Repeat                      ; no, don't add any more chars!
        mov byte ptr es:[bx + di+2], al ; Input[bx+di+2] = last char in al
        mov ax, di                      ;
        mov byte ptr es:[bx + 1], al    ; Store current length in *Input[1]
        inc di                          ; 
        mov al, '*'                     ; Display a '*' for typed character
        call OutChar                    ; 
        jmp Repeat                      ;
 RepeatQuit:                            ;
        retn                            ; should never get here
ReadString endp                         ;




; Reboot machine by twiddling bus reset. May only work on 286+ ???
;
; Note: This can be replace with a standard far jmp reset if does not work
;       on your platform. Otherwise, this seems elegant.

Reboot proc far                         ;
        mov dx, offset NoAccess         ;
        call PrintStr                   ; print "Access Denied. Rebooting..."
        call GetTime                    ; delay momentarily before reboot
        mov cx, TimeElapsed             ; so the user can read the message
        mov word ptr StartTime, cx      ; ""
Reboot2:                                ; ""
        call GetTime                    ; get the elapsed minutes
        mov cx, TimeElapsed             ; ""
        sub cx, word ptr StartTime      ; (elapsed - start time)
        cmp cx, RebootTimeout           ; timeout occurred?
        jbe Reboot2                     ; ""
                                        ; ******* actual reboot ********
        mov al, 0feh                    ; reboot now by pulsing
        mov dx, 064h                    ; .
        out dx, al                      ; the CPU bus reset
        retf                            ; only returns if reset failed
Reboot endp                             ;




ScanLine proc near                      ;
         xor ch, ch                     ;
         mov cl, Byte ptr Password      ; number of characters to compare
         mov al, Byte ptr Input  + 1    ; bytes actually inputted by user
         inc al                         ; compensate for input offset        
         sub al, cl                     ; do sizes match ?
         jnz ScanExit                   ; no, so abort
         mov di, offset Password + 1    ; di = ptr to actual password
         mov si, offset Input    + 2    ; si = ptr to user entry

         PushAll                        ;
; *** Case-Sensitivity Section -----------------------------------------------
;
; Notes:
;        1. This section was extracted "as-is" from "PW.8" on SimTel on
;           08/05/95. See "HISTORY" above for details.
;
;           Case-sensitivity is removed by converting any received ASCII
;           characters in the range 'a' through 'z' to caps.
;
;        2. This is recommended for applications in which the user
;           may not be readily aware of the state of the CAPS LOCK key!
;
;        3. For other applications, the input may be treated as case sensitive
;           by commenting out this section and recompiling.
;
         mov ax, ds                     ;
         mov es, ax                     ; ES=DS
         mov di, si                     ; DI=SI
ScanCase:                               ;
         cld                            ; clear the direction flag
         lodsb                          ; get char at DS:[SI] to al, inc SI
         cmp al, 'a'                    ; < a ?
         jl ScanStore                   ; yes
         cmp al, 'z'                    ; > z ?
         jg ScanStore                   ; yes
         sub al, 20h                    ; no, convert to uppercase
ScanStore:                              ;
         stosb                          ; store al to ES:[DI], inc DI
         loop ScanCase                  ; loop until CX = 0
; *** End Case-Sensitivity Section -------------------------------------------
; ----------------------------------------------------------------------------
         PopAll                         ; restore registers and continue

         cld                            ; clear the direction flag
         repe cmpsb                     ; repeat while zf=1+cx > 0 
ScanExit:                               ; amd compare [si] to es:[di]
         retn                           ;
ScanLine endp                           ;

; ****************************************************************************
; end Password.asm ***********************************************************

Code ends
end



