/****************************************************************************/
/*                                                                          */
/* Module Name: encrypt.c       version: 1.00,          Date: 11/12/95      */
/*                                                                          */
/* Designer(s): Joe Gruessing                                               */
/*                                                                          */
/* Description: This program determines the encrypted form of the password  */
/*              entered by the user. This password is the exclusive-OR of   */
/*              each character with its corresponding position in the       */
/*              string -- starting with 1 (not 0).                          */
/*                                                                          */
/* Returns:     0 if successful,                                            */
/*              1 if failed or user aborted                                 */
/*                                                                          */
/****************************************************************************/
/************** Copyright (C) 1995, Joseph A. Gruessing Jr. *****************/
/****************************************************************************/
/*                                                                          */
/* HISTORY:                                                                 */
/*                                                                          */
/* 08/05/95     JAG     - Display encrypted password only.                  */
/* 11/12/95     JAG     - Initial release completed.                        */
/*                                                                          */
/****************************************************************************/

#include <conio.h>
#include <ctype.h>                                             /* toupper() */
#include <stdio.h>                                                             
#include <stdlib.h>
#include <string.h>                        

#define PASSWFILE       "PASSWORD.SYS"      /* name of password driver file */
#define PASSLENGTH      8                   /* length of embedded password  */
#define PASSSTART       18                  /* start location of password   */                               

int main(void)
{
  FILE *outf;

  unsigned char inputString[PASSLENGTH + 1];
              
  int   i, forever;

  for (;;)              
  {
        clrscr();
        printf("Ŀ\r\n");
        printf(" Modify Password: \"%s\" driver utility. \r\n", PASSWFILE);
        printf(" Copyright (c) 1995 Joseph A. Gruessing Jr.      \r\n");
        printf("\r\n\r\n");
        printf("Enter password  to encrypt: ");
        gets(inputString);

        for (i = strlen(inputString); i < PASSLENGTH; i++)
          inputString[i] = 0;

        for (i=0; i < strlen(inputString); i++)
          inputString[i] = toupper(inputString[i])^(i+1);
       
        printf("Encrypted version to embed: %s\r\n\r\n", inputString);
        printf("Selected password OK? (YyNnQq): ");

        forever = 1;

        while (forever)              /* loop #2 - wait for valid user input */
        {        
           i = getch();

           switch (i)
           {
             case 'Y':
             case 'y':
             {
                printf("%c\r\n\r\n%s: ", i, PASSWFILE);
                if((outf = fopen(PASSWFILE, "r+b")) == 0)
                {
                   printf("Cannot open file. Aborting...\r\n\r\n");
                   return(1);
                }

                fseek(outf, PASSSTART, SEEK_SET);
                fputc(strlen(inputString), outf);
                fwrite(&inputString, PASSLENGTH, 1, outf);
                fclose(outf);
                printf("Password change complete.\r\n");
                return(0);
             }

             case 'N':
             case 'n':
             {
                forever = 0;
                break;
             }

             case 'Q':
             case 'q':
             {
                printf("%c\r\n\r\nNo modifications were made to \"%s\".\r\n",
                       i, PASSWFILE);

                return(1);
             }

           } /* end - switch */

        } /* end - while (forever) */

  } /* end - for (;;) */

}

