PROGRAM delete_duplicate_4dos_command_history_entries;
{$M 2048,0,655360}  { 5k reserved for data, remainder allowed for pointers }
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}

USES DOS;
TYPE
  link = ^node;
  node = RECORD
           Command  : STRING;
           NextNode : link;
         END;
CONST
  cursorState : BYTE = 1;  {0..3}
  cursorData : ARRAY [0..3] OF CHAR = (#179, #47, #196, #92);

VAR
  SavedExitProc: POINTER;

FUNCTION WordToHex (i: WORD): STRING; FORWARD;

PROCEDURE CustomExit; FAR;
{---- Always exit through here ----}
CONST
  NL = #13#10;
VAR
  message: STRING [79];
BEGIN
  ExitProc := SavedExitProc;
  IF (ExitCode > 0) THEN BEGIN {If there is any problem...}
    WriteLn ('4HIST v1.11 - Free 4DOS utility: command history duplicate entry deleter.');
    WriteLn ('March 10, 1996. Copyright (c) 1996 by David Daniel Anderson - Reign Ware.'+NL);
    WriteLn ('Usage: 4HIST histfile [/i (ignore case)]'+NL);
    WriteLn ('Note:  I recommend using the 4H.BTM batch file to automate the process.'+NL);
  END;
  IF ErrorAddr <> NIL THEN {If an unanticipated run-time error occured...}
  BEGIN
    WriteLn ('An unanticipated error occurred, please contact DDA with the following data:');
    WriteLn ('Address = ', WordToHex (Seg (ErrorAddr^)), ':', WordToHex (Ofs (ErrorAddr^)));
    WriteLn ('Code    = ', ExitCode);
    ErrorAddr := NIL; {IMPORTANT!!!}
  END
  ELSE
    IF (ExitCode IN [1..254]) THEN BEGIN
      CASE ExitCode OF
        7 : message := 'File handling error.  File may have been corrupted or deleted!';
        ELSE  message := 'Unknown error.';
      END;
      WriteLn (#7, 'Error encountered (#', ExitCode, '):'); WriteLn (message);
    END;
END;

FUNCTION WordToHex (i: WORD): STRING; {Convert a WORD variable to STRING}
CONST
  HexLetters : ARRAY [0..15] OF CHAR = '0123456789ABCDEF';
BEGIN
  WordToHex := Concat (HexLetters [Hi (i) SHR 4], HexLetters [Hi (i) AND 15],
                       HexLetters [Lo (i) SHR 4], HexLetters [Lo (i) AND 15]);
END;

PROCEDURE CheckIO;
BEGIN
  IF IOResult <> 0 THEN Halt (7);
END;

PROCEDURE updateCursor;
BEGIN
  cursorState := Succ (cursorState) AND 3;
  Write (cursorData [cursorState], ^H);
END;

PROCEDURE UpFast (VAR Str: STRING);  {** from SWAG **}
INLINE ($8C/$DA/$5E/$1F/$FC/$AC/$30/$E4/$89/$C1/$E3/$12/$BB/Ord('a')/Ord('z')/
        $AC/$38/$D8/$72/$08/$38/$F8/$77/$04/$80/$6C/$FF/$20/$E2/$F1/$8E/$DA);

FUNCTION Upper (lstr : STRING): STRING;
BEGIN
  upfast (lstr);
  Upper := lstr;
END;

FUNCTION IsDir (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) = Directory)
    THEN IsDir := TRUE
    ELSE IsDir := FALSE;
END;

FUNCTION GetFilePath (CONST PSTR: STRING; VAR sDir: DIRSTR): PATHSTR;
VAR
  jPath     : PATHSTR;  { file path,       }
  jDir      : DIRSTR;   {      directory,  }
  jName     : NAMESTR;  {      name,       }
  jExt      : EXTSTR;   {      extension.  }
BEGIN
  jPath := PSTR;
  IF jPath = '' THEN jPath := '*.*';
  IF (NOT (jPath [Length (jPath)] IN [':', '\'])) AND IsDir (jPath) THEN
    jPath := jPath + '\';
  IF (jPath [Length (jPath)] IN [':', '\']) THEN
    jPath := jPath + '*.*';

  FSplit (FExpand (jPath), jDir, jName, jExt);
  jPath := jDir + jName+ jExt;

  sDir := jDir;
  GetFilePath := jPath;
END;

VAR
  dirinfo : SEARCHREC;
  sPath   : PATHSTR;
  sDir    : DIRSTR;
  sFile   : TEXT;
  IgnoreCase : BOOLEAN;

  CmdInHand,
  CmdInList,
  CurrentCommand : STRING;
  anchor,
  chain,
  CurrentNode,
  TempNode       : LINK;
  NumHistItems   : WORD;
  HistorySize    : LONGINT;

BEGIN
  SavedExitProc := ExitProc;
  ExitProc := @CustomExit;

  IF ParamCount >= 1
    THEN sPath := ParamStr (1)
    ELSE Halt (255);

  sPath := GetFilePath (sPath, sDir);
  Assign (sFile, sPath); Reset (sFile); CheckIO;

  IgnoreCase := ((ParamCount = 2) AND (Upper (ParamStr (2)) = '/I'));

  HistorySize := 0;
  NumHistItems := 0;

  anchor := NIL;

  WHILE NOT SeekEoF (sFile) DO BEGIN
    chain := anchor;

    ReadLn (sFile, CurrentCommand);
    UpdateCursor;
    HistorySize := HistorySize + Length (CurrentCommand);
    Inc (NumHistItems);

    { Remove any previous occurence from list }

    CmdInHand := CurrentCommand;
    IF IgnoreCase THEN UpFast (CmdInHand);
    WHILE (chain <> NIL) AND (chain^. NextNode <> NIL) DO BEGIN

      CmdInList := chain^. Command;
      IF IgnoreCase THEN UpFast (CmdInList);

      IF (CmdInHand = CmdInList) THEN
      BEGIN
        TempNode := chain^. NextNode;
        chain^. Command := chain^. NextNode^. Command;
        chain^. NextNode := chain^. NextNode^. NextNode;
        Dispose (TempNode)
      END
      ELSE
        chain := chain^. NextNode
    END;

    { Append to end if it doesn't duplicate last entry }

    New (CurrentNode);
    CurrentNode^. Command  := CurrentCommand;
    CurrentNode^. NextNode := NIL;

    IF chain <> NIL THEN
    BEGIN
      CmdInList := chain^. Command;
      IF IgnoreCase THEN UpFast (CmdInList);

      IF (CmdInHand <> CmdInList)
      THEN chain^. NextNode := CurrentNode
      ELSE BEGIN
        chain^. Command := CurrentNode^. Command;
        Dispose (CurrentNode)
      END
    END
    ELSE
      anchor := CurrentNode;
  END;

  HistorySize := HistorySize + NumHistItems;
  Write ('History was: ', HistorySize, ' bytes (', NumHistItems, ' commands),');

  HistorySize := 0;
  NumHistItems := 0;

  { Wipe out old file, and open it for input }

  Close (sFile);   CheckIO;
  Assign (sFile, sPath);
  Rewrite (sFile); CheckIO;

  { Write out what is left }

  WHILE anchor <> NIL DO BEGIN
    WriteLn (sFile, anchor^. Command);
    HistorySize := HistorySize + Length (anchor^. Command);
    Inc (NumHistItems);

    TempNode := anchor;
    anchor := anchor^. NextNode;
    Dispose (TempNode);
  END;
  Close (sFile);   CheckIO;

  HistorySize := HistorySize + NumHistItems;
  WriteLn (' now is: ', HistorySize, ' bytes (', NumHistItems, ' commands).');
END.
