* DEMOTR
* Authored by: Stephen Bell
* Released To The Public Domain - 1995
*
* This short TDBS program was written to provide a quick interface for the
* user to review some of the various features of the TR Text Reader for
* TBBS/TDBS.  It also serves as a simple example of how to use TR's built
* in hook for returning to a calling program or exiting to a different program.
*
* Essentially, when TR is started with the /Z parameter on its command line,
* it expects to find a file named TRHOOK.xx where xx is the number of the line
* in use by the calling program, e.g. TRHOOK.00 for the console.  TR expects
* this file to be located in its homepath directory and to be a text file in
* which the first line of the file contains a command line which can be
* executed by a DOTBBS TYPE 200 command.  You can place any additional
* information which might be useful on any subsequent lines.
*
* When TR is exited, it will attempt to execute the TYPE 200 (TDBS) command
* found.  This command may be the same program which called TR or a different
* program altogether.  This means that you can use the hook as a mechanism to
* to loop back from TR or to chain out.  If you use the hook to return to a
* calling program, it is important to understand that you are not returning
* to the point of execution in the calling program but are restarting that
* program entirely.  If you wish to create for the user of the calling program
* the illusion that they are 'taking up at the same place they left off', your
* calling program may need to save information about it's current state and
* provide a mechanism to return to that state upon re-starting.  Memory
* variable files (.mem files), used in conjunction with the SAVE TO and RESTORE
* FROM commands, are commonly used for this purpose.
*
* This program is expected to live in the same directory as TR and is
* adequately simple that it does not need to save status information, but
* such functionality could readily be added to a more complex program.
*

SET ESCAPE OFF                           && do not permit user abort

twoamp = CHR(38)+CHR(38)                 && the comment marker '&&'
where = HOMEPATH()                       && location for hook file
options = ""                             && options to pass to TR, if any

IF .NOT. FILE("TRHOOK." + ULINE())       && original call to this program
   SET CONSOLE OFF                       && turn the screen echo off
   SET ALTERNATE TO "TRHOOK." + ULINE()  && define hook file
   SET ALTERNATE ON                      && create hook file
   ?? OPTDATA()                          && write the command line this program
   ?                                     &&   was called with to the first line
   SET ALTERNATE OFF                     && close the hook file
   SET CONSOLE ON                        && restore screen echo
ENDIF                                    && otherwise this program was
                                         &&   called from a hook file and
                                         &&   doesn't need to create one

IF "/E" $ UPPER(OPTDATA())               && if this program was called with an
  options = "E"                          &&   /e parameter, we will pass that
ENDIF                                    &&   along to TR to enable its e-mail
                                         &&   feature for this demo

CLEAR                                    && clear the screen

?? "Thank you for using the TR text reader for TBBS."
?
?  "If this is your first look at TR, please select each of the"
?  "menu options below.  Each will display a different text file"
?  "with additional info about TR.  You may then wish to run the"
?  "TRCFG program to make any customizations you would like to try."
?  "If you use TRCFG to set up TR's e-mail feature, you can restart"
?  "this program with the command line: DEMOTR " + twoamp + " /E " +;
      "to test the "
?  "e-mail feature.  Thanks again for selecting TR."
?

? "A: Demonstrate TR with color pattern 1 (Northwest)."
? "B: Demonstrate TR with color pattern 2 (Cool Blue)."
? "C: Demonstrate TR with color pattern 3 (Taos)."
? "D: Demonstrate TR with Sysop defined color scheme."
? "Q: Quit - End Demonstration." 
?
? "Enter Option Letter. >  "             && create a simple menu

DO WHILE .T.
   key = INKEY(0)                        && wait for user selection
   sel = UPPER(CHR(ABS(key)))         
   DO CASE                               && if it's a valid selection
     CASE  sel = "A"                     && execute the appropriate command
        DOTBBS TYPE 200 OPTDATA where + "TR /Q " + twoamp + where +;
           "TRINFO.TXT /ZQ" + options
     CASE  sel = "B"                  
        DOTBBS TYPE 200 OPTDATA where + "TR /Q " + twoamp + where +;
           "TRCMDS.TXT /1ZQ" + options
     CASE  sel = "C"                  
        DOTBBS TYPE 200 OPTDATA where + "TR /Q " + twoamp + where +;
           "TRDOCS.TXT /2ZQT" + options
     CASE sel = "D"
        DOTBBS TYPE 200 OPTDATA where + "TR /Q " + twoamp + where +;
           "DEMOTR.PRG /CZQ" + options
     CASE  sel = "Q"                     && exit the input loop if user is done
        EXIT
   ENDCASE
ENDDO
                                         && if we are here, we are exiting at
IF FILE("TRHOOK." + ULINE())             && user command rather than DOTBBS
   ERASE("TRHOOK." + ULINE())            && 200 call, so we can erase hook file
ENDIF

CLEAR                                    && clear the screen
QUIT                                     && and exit to TBBS

* == END OF FILE ==

