{***************************************************************************
**
**                             -=( UOsys )=-
**                   (c) CopyRight LiveSystems 1992, 1993
**
** Author    : Gerhard Hoogterp
** FidoNet   : 2:283/7.33
**             2:282/10.5
** Internet  : Gerhard@frappe.iaf.nl
**
**
**    This unit is part of the UserOn package and may be used freely in
**    other programs.
**
**    Under no circumstances will the author (me) be held responsible for any
**    damage as result of using this library. Use this unit at your own risk!
**    Comments and remarks are welcome at one of the above addresses.
**
**    If you use this source or when you support UserDoes and SysDoes files
**    a reference to LiveSystems UserOn, UserOn/PRO and HandyMan would be
**    appriciated.
**
****************************************************************************}

Unit UOSys;
Interface
Uses Dos;


Type UserDoesString = String[75];
     UserDoesObject = Object
                        DoesWhat : UserDoesString;    { The string to write   }
                        SemDir   : PathStr;           { Where to write        }
                        Node     : Byte;              { The nodenumber        }
                        Name     : String[12];        { The UsedDoes filename }

                        { Prepare the userdoes object                         }
                        Procedure Init( _Node : Byte;
                                        _Does : UserDoesString;
                                        _Where: PathStr);

                        { Write the _Does string to the semafore directory    }
                        Procedure SetIt;

                        { Change the UserDoes string in the semaphore         }
                        { directory                                           }
                        Procedure ReSetIt(_Does : UserDoesString);

                        { Remove the UserDoes file                            }
                        Procedure ClearIt;

                        { Read the UserDoes file from disk                    }
                        Procedure GetIt(Def : UserDoesString);

                      End;

Implementation

Var Tmp : Text;


Function Nr2Str(Nr : Word;Len : Byte):String;
Var Temp : String[20];
Begin
Str(Nr:Len,Temp);
Nr2Str:=Temp;
End;

Procedure UserDoesObject.Init( _Node : Byte;
                               _Does : UserDoesString;
                               _Where: PathStr);
Begin
Node:=_Node;
DoesWhat:=_Does;
SemDir:=_Where;
Name:='USERDOES.'+Nr2Str(Node,0);
End;


Procedure UserDoesObject.SetIt;
Begin
Assign(Tmp,SemDir+Name);
Rewrite(Tmp);
WriteLn(Tmp,DoesWhat);
Close(Tmp);
If IoResult<>0
   Then;
End;

Procedure UserDoesObject.ReSetIt(_Does : UserDoesString);
Begin
DoesWhat:=_Does;
SetIt;
End;

Procedure UserDoesObject.ClearIt;
Var Try : Byte;
Begin
Try:=3;
Repeat
 Assign(Tmp,SemDir+Name);
 Erase(Tmp);
 If IoResult<>0
    Then Dec(Try)
    Else Try:=0;
Until Try=0;
End;

Procedure UserDoesObject.GetIt(Def : UserDoesString);
Begin
Assign(Tmp,SemDir+Name);
Reset(Tmp);
If IoResult=0
   Then Begin
        ReadLn(Tmp,DoesWhat);
        Close(Tmp);
        End
   Else DoesWhat:=Def;
If IoResult<>0
   Then;
End;

End.

