#ifndef _WMCHAT_H_
#define _WMCHAT_H_

/* If you experience strange problems, be sure that other locations aren't
   using the 5000-5009 range.  If they are, you can change the below ones
   to anything you like, they're not dependent on the number */

#define INST_LOC_CH1          5000
#define INST_LOC_CH2          5001
#define INST_LOC_CH3          5002
#define INST_LOC_CH4          5003
#define INST_LOC_CH5          5004
#define INST_LOC_CH6          5005
#define INST_LOC_CH7          5006 
#define INST_LOC_CH8          5007
#define INST_LOC_CH9          5008
#define INST_LOC_CH10         5009

#define INST_FLAGS_INVIS      0x0004  /* For invisibility */

typedef struct {
  int r;
  char aword[12];
  char toprint[80];
  char toperson[80];
  char toall[80];
  char singular[80];
} ch_action;

/* Edit this line to allow > 100 actions.  There are actually 101 possible
   actions by default (0 through 100 = 101) but it would've looked goofy
   to use the number 99 :) */
#define MAX_NUM_ACT 100

/* File: wmchat.c */

void wmchat(void);
void who_online(int *nodes, int loc);
void intro(int loc);
void ch_direct(char *msg, int loc, char *color);
void ch_whisper(char *msg, char *color);
int rip_words(int start, char *cmsg, char *wd, int size, char lookfor);
int wusrinst(char *n);
void secure_ch(int ch);
int unsecure_ch(char *r);
void cleanup_chat(void);
void page_user(int loc);
void moving(int x, int loc);
void out_msg(char *msg, int loc);
void get_colors(char *color);
void load_actions(void);
void add_action(ch_action act);
void free_actions(void);
int f_action(int start, int end, char *aword);
int check_action(char *msg, char *color, int loc);
void exec_action(char *msg, char *color, int loc, int nact);
void action_help(int num);
void ga(char *msg, char *color, int loc);
void toggle_avail(void);
void toggle_invis(void);
void exit_chat(unsigned char *s, unsigned char *r);
void set_wmstr(void);

#endif
