/*
 * Allfix/2 1.x WPfolder Installation Program copyright (c) 1995, 1996
 * by Scott Drake of Innovative Solutions 1;2630/212
 *
 * This program creates a folder to hold program objects, then creates
 * program objects for each executable.  It only needs to be run once
 * (unless you move the Allfix directory -- see say notes at end).  Run
 * this program in the Allfix directory (where you unpacked the archive).
 */

/* see if we might be in the right directory... */

'@Echo off'
'cls'

say ''
say ''
say '[0;1;34;44m[0;30;44m[40m'
say '[1;34;44m [0;30;44m [40m'
say '[1;34;44m                  [33mAllfix 4.x WPfolder Installation Program                [0;30;44m [40m'
say '[1;34;44m                   [36mCopyright (c) 1995, 1996 by [31mScott Drake                [0;30;44m [40m'
say '[1;34;44m          [33mAllfix v4.x [36mis Copyrighted (c) 1992-96 by [31mHarald Harms          [0;30;44m [40m'
say '[1;34;44m                           [36mAll rights reserved                            [0;30;44m [40m'
say '[1;34;44m [0;30;44m [40m'
say '[1;34;44m [0;30;44m[1;34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m          [1;37mHave you read the ALLFIX.DOC or ALLFIX.INF file yet?           [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m           [1;37mBy running this program, you agree to the license             [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m                       [1;37mas specified in that file,                        [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m      [1;37mand it tells you how to install ALLFIX, so you should read it.     [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m                                 [1;37mPlease?                                 [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m[1;34m [0;30;44m[40m'
say '[1;34;44m[0;30;44m[0m'
say ''
say ''

/*
 * allow user to eliminate associations from being placed on AV/2.
 * seemed to upset some fellow on CIS (I guess he doesn't know about
 * Settings notebooks on WPS objects).
 */
assocfilter = ';ASSOCFILTER=*.ZIP,*.ARC,*.LZH,*.ARJ,*.ZOO,*.MO0,READ.ME,README,README.1ST,README.OS2,REGISTER.TXT'
existed = ''
parse upper arg dummy
if dummy = 'NOASSOC' then assocfilter = ''

rc = stream('allfix.exe','c','query exists')
if rc = '' then
do
  say '[0;1;31mSorry, ALLFIX.EXE not found.  Must not be right directory.  Terminating.[0m'
  exit
end

/* tell user what we're doing, give him a chance to hit CTRL-C */

say ''
say 'This program creates Desktop objects for Allfix [DOS]. If you do not want'
say 'create the Desktop Objects, say press CTRL + C the press Enter.'
say ''



say '[0;1;35mPress [Enter] to continue...[0m'
pull dummy .
say ''


/* save current directory */

curdir = directory()

/* load rexx utility functions */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* say it, then do it */

'cls'
say ''
say ''
say ''
say "[0;1;5;31mCreating The Allfix [DOS] FileEcho Processor folder and objects...[0m"

/* first, create Allfix folder */

rc = stream('affldr.ico','c','query exists')
title = "Allfix [DOS] FileEcho^ Processor"
classname = 'WPFolder'
location = '<WP_DESKTOP>'
setup = 'OBJECTID=<Allfix_Folder>;OPEN=DEFAULT'
if rc \= '' then setup = setup';ICONFILE='rc
result=SysCreateObject(classname,title,location,setup,f)

/* NOTE:  remove following 9 lines for unattended use... */
if result = 0 then
do
  assocfilter = ''
  existed = 'TRUE'
  say ''
  say '[0;1;31mThe Allfix [DOS] FileEcho Processor folder already exists.'
  say '[33mShould I update the objects? (Y/n)[0m'
  parse upper pull dummy
  if left(dummy,1) = 'N' then exit
  say ''
end

/* now, create program objects in Allfix folder */

title = "Allfix v4.32^ FileEcho Processor"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'OBJECTID=<Allfix v4.32>;EXENAME='curdir'\ALLFIX.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

title = "Allfix v4.32^ Configuration"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'OBJECTID=<Allfix Configuration>;EXENAME='curdir'\ASETUP.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

title = "Allfix v4.32^ File Hatch"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'OBJECTID=<Allfix v4.32 File Hatch>;EXENAME='curdir'\HATCH.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

title = "Allfix v4.32^ Fix Utility"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'OBJECTID=<Allfix Utility>;EXENAME='curdir'\FIXUTIL.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

title = "Allfix v4.32^ Update Utility"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'OBJECTID=<Allfix Update Utility>;EXENAME='curdir'\UPDATE.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

title = "Allfix v4.32^ File Area Compilier"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'OBJECTID=<Allfix v4.32 File Area Compilier>;EXENAME='curdir'\FCOMP.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

title = "Allfix v4.32^ Cookie Baker"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'OBJECTID=<Allfix v4.32^ Cookie Baker>;EXENAME='curdir'\BAKE.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

rc = stream('cookie.ico','c','query exists')
title = "COOKIE.TXT"
classname = 'WPShadow'
location = '<Allfix_Folder>'
setup = 'OBJECTID=<Allfix v4.32^COOKIE.TXT>;EXENAME=view.exe;PARAMETERS='curdir'\cookie.txt;STARTUPDIR='curdir
if rc \= '' then setup = setup';ICONFILE='rc
call SysCreateObject classname,title,location,setup,u

rc = stream('whatsnew.ico','c','query exists')
title = "WHATSNEW.DOC"
classname = 'WPShadow'
location = '<Allfix_Folder>'
setup = 'OBJECTID=<Allfix v4.32^Whats New!>;EXENAME=view.exe;PARAMETERS='curdir'\whatsnew.doc;STARTUPDIR='curdir
if rc \= '' then setup = setup';ICONFILE='rc
call SysCreateObject classname,title,location,setup,u

rc = stream('ALLFIX.DOC','c','query exists')
if rc \= '' then
do
title = "Allfix v4.32^ Text Doc's"
classname = 'WPProgram'
location = '<Allfix_Folder>'
  setup = 'OBJECTID=<Allfix v4.32 Documentation>;EXENAME=e.exe;PARAMETERS='curdir'\allfix.doc;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('ALLFIX.INF','c','query exists')
if rc \= '' then
do
  title = "Allfix v4.32^ INF Doc's"
  classname = 'WPProgram'
  location = '<Allfix_Folder>'
  setup = 'OBJECTID=<Allfix v4.32 OS/2 Documentation>;EXENAME=view.exe;PARAMETERS='curdir'\allfix.inf;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('UPGRADE.LOG','c','query exists')
if rc \= '' then
do
  title = "UPGRADE.LOG"
  classname = 'WPShadow'
  location = '<Allfix_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

/* Final words */
'cls'

say ''
say ''
say ''
say ''
say ''
say '[0;30m [1;34;44m[40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m  [36mIf you find a need to move Allfix to a different Directory, delete the  [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m   [36mAllfix Desktop folder and re-run INSTALL in the New Allfix Directory.  [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m [0;30;44m[1;34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m          [1;37mI am now done Installing the Allfix Desktop Folder!            [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m [1;37mPlease be sure to check all the settings for each program, as a default [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m    [1;37mall programs will be opened in a DOS Window instead of a DOS Full    [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m [1;37mScreen. Also be sure to check the parameters on such programs as Fcomp  [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m                                                                         [1;34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m   [1;31mIf you havent Registered Allfix yet,  please remember to do so soon.  [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m[1;34m [40m'
say '[A[79C[0;30;44m[1C[1;34m[0;30;44m[40m'
say '[A[79C[44m[0m'


