{********************************************}
{*                                          *}
{* TOGGLE25.PAS generated from TOGGLE25.VBX *}
{*                                          *}
{********************************************}

unit Toggle25;

interface

uses SysUtils, Classes, Graphics, Forms, Controls, VBXCtrl, BIVBX;

{ $DEFINE InitTToggle}
{^- Remove space to enable default init data -- See documentation. }

type

  { TToggle }

  TToggle = class(TVBXControl)
  protected
    { Event handler }
    procedure HandleVBXEvent(var Message: TWMVBXFireEvent); override;
    procedure DefineProperties(Filer: TFiler); override;
  public
    constructor Create(AOwner: TComponent); override;

    property Index: TVBInteger index 0 read GetIntProp;
    property AVersion: Single index 20 read GetSingleProp write SetSingleProp;
    property ZLoad: TVBInteger index 53 read GetIntProp write SetIntProp;
  published
    property BackColor: TColor index 2 read GetColorProp write SetColorProp;
    property Enabled;
    property Visible;
    property MousePointer: TVBEnum index 9 read GetEnumProp write SetEnumProp
      default 0;
    property TabOrder;
    property TabStop;
    property Font;
    property ParentFont;
    property About: TVBString index 21 read GetStringProp {NoRT}write
      SetStringProp stored False;
    property BevelWidth: TVBInteger index 22 read GetIntProp write SetIntProp;
    property BevelInner: TVBEnum index 23 read GetEnumProp write SetEnumProp;
    property BevelOuter: TVBEnum index 24 read GetEnumProp write SetEnumProp;
    property BorderWidth: TVBInteger index 25 read GetIntProp write
      SetIntProp;
    property Value: Boolean index 26 read GetBoolProp write SetBoolProp;
    property OnPicture: TVBPic index 27 read GetPictureProp write
      SetPictureProp stored False;
    property OffPicture: TVBPic index 28 read GetPictureProp write
      SetPictureProp stored False;
    property OnWave: TVBString index 29 read GetStringProp write
      SetStringProp;
    property OffWave: TVBString index 30 read GetStringProp write
      SetStringProp;
    property Sound: Boolean index 31 read GetBoolProp write SetBoolProp;
    property AutoSize: Boolean index 32 read GetBoolProp write SetBoolProp;
    property OnBackColor: TColor index 33 read GetColorProp write
      SetColorProp;
    property OffBackColor: TColor index 34 read GetColorProp write
      SetColorProp;
    property OnCaption: TVBString index 35 read GetStringProp write
      SetStringProp;
    property OffCaption: TVBString index 36 read GetStringProp write
      SetStringProp;
    property OnForeColor: TColor index 37 read GetColorProp write
      SetColorProp;
    property OffForeColor: TColor index 38 read GetColorProp write
      SetColorProp;
    property BlinkMode: TVBEnum index 39 read GetEnumProp write SetEnumProp;
    property BlinkRate: TVBInteger index 40 read GetIntProp write SetIntProp;
    property OnTimer: TVBInteger index 41 read GetIntProp write SetIntProp;
    property MouseControl: Boolean index 42 read GetBoolProp write
      SetBoolProp;
    property TwoState: Boolean index 43 read GetBoolProp write SetBoolProp;
    property Outline: Boolean index 44 read GetBoolProp write SetBoolProp;
    property OutlineColor: TColor index 45 read GetColorProp write
      SetColorProp;
    property OnX: TVBInteger index 46 read GetIntProp write SetIntProp;
    property OnY: TVBInteger index 47 read GetIntProp write SetIntProp;
    property OffX: TVBInteger index 48 read GetIntProp write SetIntProp;
    property OffY: TVBInteger index 49 read GetIntProp write SetIntProp;
    property PushX: TVBInteger index 50 read GetIntProp write SetIntProp;
    property PushY: TVBInteger index 51 read GetIntProp write SetIntProp;
    property PushPicture: TVBPic index 52 read GetPictureProp write
      SetPictureProp stored False;
    property OnClick;
    property OnEnter;
    property OnExit;
    property OnMouseUp;
    property OnMouseDown;
    property OnDragDrop;
    property OnEndDrag;
    property OnMouseMove;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
  end;

procedure Register;

implementation

{ Default form data for TToggle }

{$IFDEF InitTToggle}

const
  TToggleInitLen = 134;

procedure TToggleInitData; near; assembler;
asm
	DB	$00,$00,$00,$02,$C0,$C0,$C0,$00,$03,$07,$FF,$FF,$08,$FF,$FF,$09
	DB	$00,$0A,$00,$00,$0B,$00,$00,$0C,$00,$0D,$00,$13,$06,$54,$6F,$67
	DB	$67,$6C,$65,$14,$00,$00,$20,$40,$16,$02,$00,$17,$01,$18,$02,$19
	DB	$02,$00,$1A,$00,$00,$1D,$00,$1E,$00,$1F,$00,$00,$20,$00,$00,$21
	DB	$00,$FF,$00,$00,$22,$FF,$00,$00,$00,$23,$02,$4F,$6E,$24,$03,$4F
	DB	$66,$66,$25,$00,$00,$00,$00,$26,$00,$00,$00,$00,$27,$00,$28,$00
	DB	$00,$29,$00,$00,$2A,$FF,$FF,$2B,$00,$00,$2C,$00,$00,$2D,$00,$00
	DB	$00,$00,$2E,$00,$00,$2F,$00,$00,$30,$00,$00,$31,$00,$00,$32,$00
	DB	$00,$33,$00,$00,$35,$FF
end;

{$ENDIF}

{ TToggle }

constructor TToggle.Create(AOwner: TComponent);
begin
  FVBXFile := StrNew('TOGGLE25.VBX');
  FVBXClass := StrNew('TOGGLE');
  SetBounds(0, 0, 80, 32);
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csCaptureMouse, csClickEvents];
  TabStop := True;
  FVBXFlags := [vfLoadMessage];
  {$IFDEF InitTToggle}
  FHForm := VBXCreateFormFile(TToggleInitLen, @TToggleInitData);
  {$ENDIF}
end;

procedure TToggle.HandleVBXEvent(var Message: TWMVBXFireEvent);
begin
  case Message.VBXEvent^.EventIndex of
    0: DispatchNotifyEvent(OnClick);
    1: begin end; { VCL Handles OnGotFocus }
    2: begin end; { VCL Handles OnLostFocus }
    3: DispatchMouseEvent(OnMouseUp, Message);
    4: DispatchMouseEvent(OnMouseDown, Message);
    5: begin end; { VCL Handles OnDragDrop }
    6: DispatchMouseMoveEvent(OnMouseMove, Message);
    7: DispatchKeyEvent(OnKeyDown, Message);
    8: DispatchKeyPressedEvent(OnKeyPress, Message);
    9: DispatchKeyEvent(OnKeyUp, Message);
  end;
end;

procedure TToggle.DefineProperties(Filer: TFiler);
begin
  inherited DefineProperties(Filer);
  HandleProperty('AVersion', Filer, 20);
  HandleBinaryProperty('OnPicture_Data', Filer, 27);
  HandleBinaryProperty('OffPicture_Data', Filer, 28);
  HandleBinaryProperty('PushPicture_Data', Filer, 52);
  HandleBinaryProperty('ZLoad', Filer, 53);
end;

{ Designer registration }
procedure Register;
begin
  RegisterComponents('VBX', [
    TToggle]);
end;

end.
