#ifndef MTYPES_H
#define MTYPES_H

#ifdef __WATCOMC__

#define inportb(x) inp(x)
#define outportb(x,y) outp(x,y)
#define inport(x) inpw(x)
#define outport(x,y) outpw(x,y)
#define disable() _disable()
#define enable() _enable()

#else

/* Borland doesn't save 32 bit registers when it enters the interrupt
handler, so this defines can be used to fix that
*/
	
#define pushad() __emit__(0x66,0x60)
#define popad() __emit__(0x66,0x61)                                                            

#endif

#ifdef __cplusplus
extern "C" {
#endif


typedef char            BYTE;           // has to be 1 byte signed
typedef unsigned char   UBYTE;          // has to be 1 byte unsigned
typedef short           WORD;           // has to be 2 bytes signed
typedef unsigned short  UWORD;          // has to be 2 bytes unsigned
typedef long            LONG;           // has to be 4 bytes signed
typedef unsigned long   ULONG;          // has to be 4 bytes unsigned
typedef int                             BOOL;           // doesn't matter.. 0=FALSE, <>0 true



/*
	error variables:
	===============
*/

extern char *ERROR_ALLOC_STRUCT;
extern char *ERROR_LOADING_PATTERN;
extern char *ERROR_LOADING_TRACK;
extern char *ERROR_LOADING_HEADER;
extern char *ERROR_NOT_A_MODULE;
extern char *ERROR_LOADING_SAMPLEINFO;
extern char *ERROR_OUT_OF_HANDLES;
extern char *ERROR_SAMPLE_TOO_BIG;
extern char *mkerr;




// Sample types...

#define SF_16BITS       1
#define SF_SIGNED   4
#define SF_LOOP         8
#define SF_BIDI         16
#define SF_DELTA        32
#define SF_OWNPAN       64

#define EF_ON           1
#define EF_SUSTAIN      2
#define EF_LOOP         4

#define UF_XMPERIODS    1               // if set use XM periods/finetuning
#define UF_LINEAR               2               // if set use LINEAR periods


typedef struct ENVPT{
	WORD pos;
	WORD val;
} ENVPT;

typedef struct SAMPLE{  // new sample info with some converted types
	UWORD c2spd;            // finetune frequency
	BYTE  transpose;                // transpose value
	UBYTE volume;                   // volume 0-64
	UBYTE panning;                  // panning
	ULONG length;                   // length of sample (in samples!)
	ULONG loopstart;                // repeat position (relative to start, in samples)
	ULONG loopend;                  // repeat end
	UWORD flags;
	ULONG seekpos;
	char *samplename;               // name of the sample
	WORD  handle;                   // handle <- NEW since 0.4
} SAMPLE;


// ******************* these are for a future .MOD player **************


typedef struct UNISAMPLE{       // new sample info with some converted types
	UWORD c2spd;            // finetune frequency
	BYTE  transpose;                // transpose value
	UBYTE volume;                   // volume 0-64
	UBYTE panning;                  // panning
	ULONG length;                   // length of sample (in samples!)
	ULONG loopstart;                // repeat position (relative to start, in samples)
	ULONG loopend;                  // repeat end
	UWORD flags;
} UNISAMPLE;


typedef struct INSTRUMENT{
	UBYTE numsmp;
	UBYTE samplenumber[96];

	UBYTE volflg;                   // bit 0: on 1: sustain 2: loop
	UBYTE volpts;
	UBYTE volsus;
	UBYTE volbeg;
	UBYTE volend;
	ENVPT volenv[12];

	UBYTE panflg;                   // bit 0: on 1: sustain 2: loop
	UBYTE panpts;
	UBYTE pansus;
	UBYTE panbeg;
	UBYTE panend;
	ENVPT panenv[12];

	UBYTE vibtype;
	UBYTE vibsweep;
	UBYTE vibdepth;
	UBYTE vibrate;

	UWORD volfade;
	char  *insname;
	SAMPLE *samples;
} INSTRUMENT;


// UNIINSTRUMENT has the same first members as INSTRUMENT

typedef struct UNIINSTRUMENT{
	UBYTE numsmp;
	UBYTE samplenumber[96];

	UBYTE volflg;                   // bit 0: on 1: sustain 2: loop
	UBYTE volpts;
	UBYTE volsus;
	UBYTE volbeg;
	UBYTE volend;
	ENVPT volenv[12];

	UBYTE panflg;                   // bit 0: on 1: sustain 2: loop
	UBYTE panpts;
	UBYTE pansus;
	UBYTE panbeg;
	UBYTE panend;
	ENVPT panenv[12];

	UBYTE vibtype;
	UBYTE vibsweep;
	UBYTE vibdepth;
	UBYTE vibrate;

	UWORD volfade;
} UNIINSTRUMENT;


/*
	UNImod types:
	====================
*/

typedef struct UNIMOD{
	UBYTE           numchn;                         // number of channels
	UWORD       numpos;                             // number of positions in this song
	UWORD           numpat;                         // number of patterns in this song
	UWORD           numtrk;                         // number of tracks
	UWORD           numins;                         // number of samples
	UBYTE           initspeed;                      //
	UBYTE           inittempo;          //
	UBYTE           positions[256];         // all positions
	UBYTE           panning[32];            // 32 panning positions
	UBYTE           flags;                          //
	char       *songname;                   // name of the song
	char       *modtype;                    // string type of module
	char       *comment;                    // module comments
	INSTRUMENT *instruments;                // all samples
	UWORD      *patterns;                   // array of PATTERN
	UWORD      *pattrows;                   // array of number of rows for each pattern
	UBYTE     **tracks;                             // array of pointers to tracks
} UNIMOD;


// UNIHEADER has the same first members as the head of a UNIMOD

typedef struct UNIHEADER{
	UBYTE           numchn;                         // number of channels
	UWORD       numpos;                             // number of positions in this song
	UWORD           numpat;                         // number of patterns in this song
	UWORD           numtrk;                         // number of tracks
	UWORD           numsmp;                         // number of samples
	UBYTE           initspeed;                      //
	UBYTE           inittempo;          //
	UBYTE           positions[256];         // all positions
	UBYTE           panning[32];            // 32 panning positions
	UBYTE           flags;
} UNIHEADER;

#ifdef __cplusplus
}
#endif

#endif
