#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <string.h>

#include "mtypes.h"                      // you must include these headers
#include "mwav.h"              
#include "midkit.h"


mks_file mks[2];                          // initiate the song varibles
mki_file mki;                             // the MID-KIT instrument bank file
int song=0;                               // current song #

int volume=50;

void do_mid_kit(void);


int main(int argc,char *argv[])
{
	printf(" =============================================================\n");
	printf(" ** MID-KIT ver 1.23 *** Programmed by - John Pollard       **\n");
	printf(" ** A powerfull midi engine!  With 32 voice support!        **\n");
	printf(" ** Complete with Panning, and stereo sound effects!        **\n");
	printf(" ** Please read MID-KIT.DOC for info.                       **\n");            
	printf(" **---------------------------------------------------------**\n");
	printf(" **   Registering is only $50!  No royalties to be paid!    **\n");
	printf(" **         Read REGISTER.FRM for ordering info.            **\n");
	printf(" **---------------------------------------------------------**\n");
	printf(" ** You can contact me via compuserve, internet, or phone.  **\n");
	printf(" ** Compuserve: 74723,1626 - Phone: 1(918)234-1420          **\n");
	printf(" ** INTERNET: 74723.1626@compuserve.com                     **\n");
	printf(" =============================================================\n");

	/*
		Initialize soundcard parameters.. you _have_ to do this
		before calling MK_Init(), and it's illegal to change them
		after you've called MK_Init()
	*/
	// these are for the digital routines
	// These mean nothing, if you don't iniatiate the SB for DIGI_PLAY
	mk_mixfreq      =44100;             // standard mixing freq for .WAV's
	mk_dmabufsize   =4000;              // standard dma buf size
	mk_mode         =STEREO;            // standard mixing mode
	// NOTE - if the sound card does not support any of the above
	// perameters, then they will be dropped accordingly, by MID-KIT.
	
	//      initialize soundcard
	
	// NOTE - if you want to use you own perameters to install MID-KIT
	// just set MK_AutoDetect=0, and set the irq,dma, etc variables.
	// Read "MID-KIT.DOC" for details on these variables...

	// Set for MID, and DIG play.  Use auto-detect, and mix 10 channels.

	if(!MK_Init(MK_DIGI | MK_MIDI | MK_AUTO,10) ){
	    printf("ERROR: %s.\n",mkerr);
	    printf("No sound will be heard...\n");
	}
	else
	printf("Sound Blaster found at port %0xh, IRQ %i\n",sb_port, sb_irq);
	printf("FM-OPL2 found at address %0xh\n",fm_addr);

	MK_StartTimer();                   // you can call this even if
					   // no sound card was found...
					   // all MK routine can also be called

	if (!MK_LoadMKI(&mki) ) {      
	    printf("%s",mkerr);
	    goto end;
	}
	if (!MK_LoadMKS("fightm.mks",&mks[0]) ) {
	     printf("%s",mkerr);
	     goto end;
	}
	if (!MK_LoadMKS("credits.mks",&mks[1]) ) {
	     printf("%s",mkerr);
	     goto end;
	}

	MK_PlayMKS(&mks[0],&mki);
	
	MK_SetMusicVol(volume);            // about 50%

	printf("Using %d bit %s sound at %u Hz\n\n",
			(mk_mode&BITS16) ? 16:8,
			(mk_mode&STEREO) ? "stereo":"mono",
			mk_mixfreq);
	
	// call main program

	do_mid_kit();

	// and clean up
	end:;
	MK_StopMKS();                  // stop whatever song is playing....
	MK_FreeMKS(&mks[1]);             // make sure to free them :-)
	MK_FreeMKS(&mks[0]);
	MK_Exit();                     
	MK_StopTimer();                // allways call this after your done
				       // with MID-KIT, if you initiated it!!!
	return 0;
}

void do_mid_kit(void)
{
	int t;
	SAMPLE *s1,*s2;

	if((s1=MK_LoadWave("s1.wav"))==NULL){
		printf("Wavload error: %s.\n",mkerr);
		return;
	}

	if((s2=MK_LoadWave("s2.wav"))==NULL){
		printf("Wavload error: %s.\n",mkerr);
		MK_FreeWave(s1);
		return;
	}

	puts("Press '1,2,3,4' to hear the .WAV files.");
	puts("Press '5' to change songs.");
	puts("Press - / + to change music volume.");
	printf("\nPress 'q' to EXIT to DOS.\n");

	while(1){
	      if (kbhit() )
		t=getch();

		if (t=='5') {
		    song++;
		    if (song>1) song=0;
		    MK_StopMKS();                   // stop the old song
		    MK_PlayMKS(&mks[song], &mki);   // play the current song
		}
		
		if(t=='q') break;

		if(t=='1'){
			MK_VoiceSetVolume(0,64);
			MK_VoiceSetPanning(0,0);
			MK_VoiceSetFrequency(0,12000);
			MK_VoicePlay(0,s1->handle,0,s1->length,0,0,s1->flags);
		}

		if(t=='2'){
			MK_VoiceSetVolume(1,64);
			MK_VoiceSetPanning(1,64);
			MK_VoiceSetFrequency(1,13000);
			MK_VoicePlay(1,s1->handle,0,s1->length,0,0,s1->flags);
		}

		if(t=='3'){
			MK_VoiceSetVolume(2,64);
			MK_VoiceSetPanning(2,128);
			MK_VoiceSetFrequency(2,10000);
			MK_VoicePlay(2,s2->handle,0,s2->length,0,0,s2->flags);
		}

		if(t=='4'){
			MK_VoiceSetVolume(3,64);
			MK_VoiceSetPanning(3,200);
			MK_VoiceSetFrequency(3,12000);
			MK_VoicePlay(3,s2->handle,0,s2->length,0,0,s2->flags);
		}
	    if (t=='-') { volume--; 
	       if (!MK_SetMusicVol(volume)) 
		 printf("%s",mkerr);
	    }
	    if (t=='=') { volume++; 
	       if (!MK_SetMusicVol(volume)) 
		 printf("%s",mkerr);
	    }

	// this will show you how MK_Timer is updated......
	printf("\rMusic Volume: %i , MK_Timer val = %lu",volume,MK_Timer);

	t=0;
	}

	MK_FreeWave(s1);
	MK_FreeWave(s2);
}
