Type lrect
    Left As Integer
    Top As Integer
    right As Integer
    bottom As Integer
End Type

Declare Function GetDesktopWindow Lib "user" () As Integer
Declare Function GetDC Lib "user" (ByVal hwnd%) As Integer

Declare Function ReleaseDC Lib "User" (ByVal hwnd As Integer, ByVal hDC As Integer) As Integer

Declare Sub GetWindowRect Lib "User" (ByVal hwnd%, lpRect As lrect)

Sub GrabScreen ()
    Dim winSize As lrect

    ' Assign information of the source bitmap.
    ' Note that BitBlt requires coordinates in pixels.
    hwndSrc% = GetDesktopWindow()
    hSrcDC% = GetDC(hwndSrc%)
    XSrc% = 0: YSrc% = 0
    Call GetWindowRect(hwndSrc%, winSize)
    nWidth% = winSize.right             ' Units in pixels.
    nHeight% = winSize.bottom           ' Units in pixels.

    ' Assign informate of the destination bitmap.
    hDestDC% = SaverBack.hDC

    ' Assign the value of the constant SRCOPYY to the Raster operation.
    dwRop& = &HCC0020

    ' Note function call must be on one line:
    Suc% = BitBlt(hDestDC%, X%, Y%, nWidth%, nHeight%, hSrcDC%, XSrc%, YSrc%, dwRop&)

    ' Release the DeskTopWindow's hDC to Windows.
    ' Windows may hang if this is not done.
    Dmy% = ReleaseDC(hwndSrc%, hSrcDC%)

End Sub

