// ------------------------------------------------------------------------
// File.......:	XSETDEMO.PRG
// Author.....:	Pepijn Smits
// Date.......:	June 1995
// Copyright..:	(c)1995 by SPS/Softwarebureau Pepijn Smits
// Notes......:	Demonstration for XSETMODE ("Extended SetMode()") Library
// Usage......:	See XSETDEMO.RMK
// ------------------------------------------------------------------------
//
// This application simply display's a Menu with some Text Mode
// resolutions to select. the selected Text Mode is then applied
// to the xSetMode() function, if that function returns .t., a
// screen demonstrating the new resolutions (incl. MaxRow()/Col())
// is shown. if xSetMode() returns .f., it means that the selected
// text resolution is not supported (this applies to VESA modes
// only, meaning 80x60 and the 132x?? modes). Exit with Escape.
//
// In any case, you will a VGA monitor in order to run this application,
// also, you may want to experiment only with the 80x?? modes when
// running in a graphic Box under Windows.
//
// ------------------------------------------------------------------------

Proc main()
Local n := 1
Local i
Local a := {	{40,12, "  40 x 12 "},;
		{40,25, "  40 x 25 "},;
		{40,28, "  40 x 28 "},;
		{40,50, "  40 x 50 "},;
		{80,12, "  80 x 12 "},;
		{80,25, "  80 x 25 "},;
		{80,28, "  80 x 28 "},;
		{80,43, "  80 x 43 "},;
		{80,50, "  80 x 50 "},;
		{80,60, "  80 x 60 "},;
		{132,25," 132 x 25 "},;
		{132,43," 132 x 43 "},;
		{132,50," 132 x 50 "},;
		{132,60," 132 x 60 "}	}

while n<>0
	cls
	@ 0,0 say "Select Video you want to test.."
	for i := 1 to 7
		@ 2+i,10 prompt a[i][3]
	next
	for i := 8 to 14
		@ 2+i-7,25 prompt a[i][3]
	next
	menu to n
	if n>0
		if xSetMode(a[n][2],a[n][1])
			box(a[n][3])
		else
			@ maxrow(),0 say "Mode not supported on this system.."
			inkey(0)
		end
	end
end
Return

Procedure Box(cTitle)
Local i
cls
dispbox(0,0,maxrow(),maxCol(),2)
@ 0,3 say cTitle
@ maxRow(),3 say " Press a key "
@  8,0 say replicate("!         ",20)
@  9,0 say replicate("0123456789",20)
for i := 0 to maxrow()
	@ i,18 say str(i,2)
next
@ 4,2 say "MaxRow() = "+Str(MaxRow(),3)
@ 5,2 say "MaxCol() = "+Str(MaxCol(),3)
inkey(0)
Return
