{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit                       }
{                Version: GOLD                                             }
{                Build:   1.00                                             }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                    {**********************************}
                    {**       Unit:   GOLDTINT       **}
                    {**********************************}

{++++++++++++++++++++++++++++++} unit GOLDTINT; {++++++++++++++++++++++++++++}

{$I GOLDFLAG.INC}
{$IFNDEF GOLDTINT}
   {$DEFINE GOLDTINT}
{$ENDIF}

{++++++++++++++++++++++++++++++++} INTERFACE {+++++++++++++++++++++++++++++++}

uses DOS, CRT,
     GoldAttr, GoldHard;

type
   TintElement = (Fast,           {WriteCol defaults}
      Progress1,
      Progress2,
      ProgressPercent,
      WinBorder,                  {Window defaults}
      WinBorder3DIn,
      WinBorder3DOut,
      WinTitle,
      WinBody,
      WinIcons,
      WinCaption,
      WinCustom,
      WinMoveBody,
      WinMoveHi,
      WinBorderOff,
      PromptBorder1,                {misc. messages for WinMessage, etc.}
      PromptBorder2,
      PromptTitle,
      PromptIcons,
      PromptBody,
      PromptBodyHi,
      PromptNormalCmt,
      PromptHiCmt,
      PromptEditErase,
      PromptEditNorm,
      PromptEditHi,
      PromptButtonNorm,               {prompt buttons}
      PromptButtonNormHot,
      PromptButtonHi,
      PromptButtonHiHot,
      PromptButtonDef,
      PromptButtonDefHot,
      CalBorder,                  {Calendar defaults}
      CalBorderOff,
      CalTitle,
      CalIcons,
      CalActiveMonth,
      CalEdgeMonth,
      CalToday,
      CalHiDay,
      CalcBorder,                 {Calculator defaults}
      CalcBorderOff,
      CalcBody,
      CalcTitle,
      CalcIcons,
      CalcInput,
      CalcOperand,
      CalcTape,
      CalcButtons,
      IOEditErase,                {Input fields}
      IOEditNorm,
      IOEditHi,
      IOEditOff,
      IOButtonNorm,               {buttons}
      IOButtonNormHot,
      IOButtonHi,
      IOButtonHiHot,
      IOButtonOff,
      IOButtonDef,
      IOButtonDefHot,
      IOMessage,                  {IO messages}
      IOLabelNorm,                {Field labels}
      IOLabelNormHot,
      IOLabelHi,
      IOLabelHiHot,
      IOLabelOff,
      IOWinBorder1,
      IOWinBorder2,
      IOWinTitle,
      IOWinBody,
      IOWinIcons,
      IOWinBorderOff,
      IOCheckArea,                {check boxes}
      IOChoiceHi,
      IOChoiceHiHot,
      IOChoiceNorm,
      IOChoiceNormHot,
      IOChoiceOff,
      IOIcons,
      IOIcons2,
      IOListHi,
      IOListHiHot,
      IOListHiInactive,
      IOListNorm,
      IOListNormHot,
      IOListOff,
      IOListScroll,
      Raised,
      Sunken,
      ListHi1,
      ListHi2,
      ListHiInactive,
      ListNorm1,
      ListNorm2,
      ListOff,
      ListMarkers,
      ListScrollbarHi,
      ListScrollbarNorm,
      ListBorder1,
      ListBorder2,
      ListBorderOff,
      ListTitle,
      ListHeaders,
      ListIcons,
      MemoHi,
      MemoNorm,
      MemoBlock,
      MemoScrollbarHi,
      MemoScrollbarNorm,
      MemoBorder1,
      MemoBorder2,
      MemoBorderOff,
      MemoTitle,
      MemoHeaders,
      MemoIcons,
      DirPathInfo,
      DirFileInfo,
      DirListInfo,
      MenuHiHot,
      MenuHi,
      MenuNormHot,
      MenuNorm,
      MenuOff,
      MenuBorder,
      PullHiHot,
      PullHi,
      PullNormHot,
      PullNorm,
      PullOff,
      PullMsgHot,
      PullMsg,
      PullBorder1,
      PullBorder2,
      DeskBack,
      Generic
      );



   TintSettings = array[Fast..Generic] of byte;

   TintSet = record
      LeaveMonoTints: boolean;
      UsingMonoTints: boolean;
   end; { TintSet }


const
    ColorTints: TintSettings =
       (15,            {   Fast                 }
        63,            {   Progress1,           }
        63,            {   Progress2,           }
        63,            {   ProgressPercent,     }
        159,           {   WinBorder            }
        112,           {   WinBorder3DIn        }
        127,           {   WinBorder3DOut       }
        79,            {   WinTitle             }
        159,           {   WinBody              }
        154,           {   WinIcons             }
        79,            {   WinCaption           }
        120,           {   WinCustom            }
        79,            {   WinMoveBody          }
        78,            {   WinMoveHi            }
        23,            {   WinBorderOff         }
        63,            {   PromptBorder1        }
        48,            {   PromptBorder2        }
        79,            {   PromptTitle          }
        49,            {   PromptIcons          }
        48,            {   PromptBody           }
        63,            {   PromptBodyHi         }
        113,           {   PromptNormalCmt      }
        121,           {   PromptHiCmt          }
        47,            {   PromptEditErase      }
        27,            {   PromptEditNorm       }
        31,            {   PromptEditHi         }
        23,            {   PromptButtonNorm     }
        30,            {   PromptButtonNormHot  }
        31,            {   PromptButtonHi       }
        31,            {   PromptButtonHiHot    }
        27,            {   PromptButtonDef      }
        31,            {   PromptButtonDefHot   }
        31,            {   CalBorder            }
        31,            {   CalBorderOff         }
        31,            {   CalTitle             }
        26,            {   CalIcons             }
        30,            {   CalActiveMonth       }
        16,            {   CalEdgeMonth         }
        29,            {   CalToday             }
        62,            {   CalHiDay             }
        112,           {   CalcBorder           }
        112,           {   CalcBorderOff        }
        112,           {   CalcBody             }
        126,           {   CalcTitle            }
        122,           {   CalcIcons            }
        15,            {   CalcInput            }
        122,           {   CalcOperand          }
        122,           {   CalcTape             }
        79,            {   CalcButtons          }
        47,            {   IOEditErase          }
        48,            {   IOEditNorm           }
        31,            {   IOEditHi             }
        120,           {   IOEditOff            }
        32,            {   IOButtonNorm         }
        46,            {   IOButtonNormHot      }
        46,            {   IOButtonHi           }
        46,            {   IOButtonHiHot        }
        96,            {   IOButtonOff          }
        43,            {   IOButtonDef          }
        46,            {   IOButtonDefHot       }
        0,             {   IOMessage            }
        112,           {   IOLabelNorm          }
        126,           {   IOLabelNormHot       }
        127,           {   IOLabelHi            }
        126,           {   IOLabelHiHot         }
        120,           {   IOLabelOff           }
        127,           {   IOWinBorder1         }
        112,           {   IOWinBorder2         }
        127,           {   IOWinTitle           }
        127,           {   IOWinBody            }
        122,           {   IOWinIcons           }
        112,           {   IOWinBorderOff       }
        48,            {   IOChoiceArea         }
        63,            {   IOChoiceHi           }
        62,            {   IOChoiceHiHot        }
        48,            {   IOChoiceNorm         }
        62,            {   IOChoiceNormHot      }
        56,            {   IOChoiceOff          }
        32,            {   IOIcons              }
        26,            {   IOIcons2             }
        31,            {   IOListHi             }
        30,            {   IOListHiHot          }
        63,            {   IOListHiInactive     }
        48,            {   IOListNorm           }
        62,            {   IOListNormHot        }
        120,           {   IOListOff            }
        63,            {   IOListScroll         }
        127,           {   Raised               }
        112,           {   Sunken               }
        31,            {   ListHi1              }
        30,            {   ListHi2              }
        63,            {   ListHiInActive       }
        48,            {   ListNorm1            }
        63,            {   ListNorm2            }
        56,            {   ListOff              }
        31,            {   ListMarkers          }
        48,            {   ListScrollbarHi      }
        48,            {   ListScrollbarNorm    }
        63,            {   ListBorder1          }
        48,            {   ListBorder2          }
        48,            {   ListBorderOff        }
        79,            {   ListTitle            }
        49,            {   ListHeaders          }
        52,            {   ListIcons            }
        31,            {   MemoHi               }
        48,            {   MemoNorm             }
        113,           {   MemoBlock            }
        31,            {   MemoScrollbarHi      }
        48,            {   MemoScrollbarNorm    }
        19,            {   MemoBorder1          }
        16,            {   MemoBorder2          }
        16,            {   MemoBorderOff        }
        30,            {   MemoTitle            }
        25,            {   MemoHeaders          }
        26,            {   MemoIcons            }
        127,           {   DirPathInfo          }
        127,           {   DirFileInfo          }
        49,            {   DirListInfo          }
        63,            {   MenuHiHot            }
        62,            {   MenuHi               }
        31,            {   MenuNormHot          }
        30,            {   MenuNorm             }
        23,            {   MenuOff              }
        28,            {   MenuBorder           }
        36,            {   PullHiHot            }
        32,            {   PullHi               }
        116,           {   PullNormHot          }
        112,           {   PullNorm             }
        120,           {   PullOff              }
        127,           {   PullMsgHot           }
        112,           {   PullMsg              }
        112,           {   PullBorder1          }
        127,           {   PullBorder2          }
        23,            {   DeskBack             }
        0              {   Generic              }
       );
    MonoTints: TintSettings =
       (15,            {   Fast                 }
        15,            {   Progress1,           }
        15,            {   Progress2,           }
        15,            {   ProgressPercent,     }
        112,           {   WinBorder            }
        112,           {   WinBorder3DIn        }
        112,           {   WinBorder3DOut       }
        112,           {   WinTitle             }
        15,            {   WinBody              }
        15,            {   WinIcons             }
        112,           {   WinCaption           }
        15,            {   WinCustom            }
        15,            {   WinMoveBody          }
        15,            {   WinMoveHi            }
        7,             {   WinBorderOff         }
        112,           {   PromptBorder1        }
        112,           {   PromptBorder2        }
        112,           {   PromptTitle          }
        15,            {   PromptIcons          }
        112,           {   PromptBody           }
        15,            {   PromptBodyHi         }
        112,           {   PromptNormalCmt      }
        127,           {   PromptHiCmt          }
        112,           {   PromptButtonNorm     }
        112,           {   PromptEditErase      }
        15,            {   PromptEditNorm       }
        112,           {   PromptEditHi         }
        15,            {   PromptButtonNormHot  }
        15,            {   PromptButtonHi       }
        15,            {   PromptButtonHiHot    }
        15,            {   PromptButtonDef      }
        7,             {   PromptButtonDefHot   }
        112,           {   CalBorder            }
        112,           {   CalBorderOff         }
        112,           {   CalTitle             }
        15,            {   CalIcons             }
        15,            {   CalActiveMonth       }
        7,             {   CalEdgeMonth         }
        7,             {   CalToday             }
        112,           {   CalHiDay             }
        112,           {   CalcBorder           }
        112,           {   CalcBorderOff        }
        112,           {   CalcBody             }
        126,           {   CalcTitle            }
        112,           {   CalcIcons            }
        15,            {   CalcInput            }
        112,           {   CalcOperand          }
        112,           {   CalcTape             }
        240,           {   CalcButtons          }
        112,           {   IOEditErase          }
        15,            {   IOEditNorm           }
        112,           {   IOEditHi             }
        7,             {   IOEditOff            }
        15,            {   IOButtonNorm         }
        112,           {   IOButtonNormHot      }
        112,           {   IOButtonHi           }
        112,           {   IOButtonHiHot        }
        7,             {   IOButtonOff          }
        112,           {   IOButtonDef          }
        112,           {   IOButtonDefHot       }
        0,             {   IOMessage            }
        7,             {   IOLabelNorm          }
        15,            {   IOLabelNormHot       }
        15,            {   IOLabelHi            }
        15,            {   IOLabelHiHot         }
        7,             {   IOLabelOff           }
        15,            {   IOWinBorder1         }
        15,            {   IOWinBorder2         }
        112,           {   IOWinTitle           }
        15,            {   IOWinBody            }
        112,           {   IOWinIcons           }
        112,           {   IOWinBorderOff       }
        15,            {   IOChoiceArea         }
        15,            {   IOChoiceHi           }
        15,            {   IOChoiceHiHot        }
        15,            {   IOChoiceHiInactive   }
        7,             {   IOChoiceNorm         }
        15,            {   IOChoiceNormHot      }
        0,             {   IOChoiceOff          }
        15,            {   IOIcons              }
        15,            {   IOIcons2             }
        7,             {   IOListHi,            }
        112,           {   IOListHiHot,         }
        7,             {   IOListNorm,          }
        15,            {   IOListNormHot        }
        0,             {   IOListOff            }
        0,             {   IOListScroll         }
        15,            {   Raised               }
        7,             {   Sunken               }
        112,           {   ListHi1              }
        112,           {   ListHi2              }
        63,            {   ListHiInActive       }
        15,            {   ListNorm1            }
        7,             {   ListNorm2            }
        7,             {   ListOff              }
        15,            {   ListMarkers          }
        15,            {   ListScrollbarHi      }
        7,             {   ListScrollbarNorm    }
        15,            {   ListBorder1          }
        15,            {   ListBorder2          }
        15,            {   ListBorderOff        }
        15,            {   ListTitle            }
        15,            {   ListHeaders          }
        15,            {   ListIcons            }
        15,            {   MemoHi               }
        7,             {   MemoNorm             }
        112,           {   MemoBlock            }
        15,            {   MemoScrollbarHi      }
        7,             {   MemoScrollbarNorm    }
        15,            {   MemoBorder1          }
        15,            {   MemoBorder2          }
        15,            {   MemoBorderOff        }
        15,            {   MemoTitle            }
        15,            {   MemoHeaders          }
        15,            {   MemoIcons            }
        112,           {   DirPathInfo          }
        112,           {   DirFileInfo          }
        112,           {   DirListInfo          }
        15,            {   MenuHiHot            }
        15,            {   MenuHi               }
        15,            {   MenuNormHot          }
        07,            {   MenuNorm             }
        08,            {   MenuOff              }
        07,            {   MenuBorder           }
        15,            {   PullHiHot            }
        07,            {   PullHi               }
        15,            {   PullNormHot          }
        112,           {   PullNorm             }
        112,           {   PullOff              }
        15,            {   PullMsgHot           }
        127,           {   PullMsg              }
        112,           {   PullBorder1          }
        112,           {   PullBorder2          }
        7,             {   DeskBack             }
        0              {   Generic              }
       );

procedure GoldSetColor(Zone:TintElement; Col:byte);
function  GoldGetColor(Zone:TintElement): byte;
procedure UseColorDefaults;
procedure UseMonoDefaults;
procedure UseColorScheme(var NewTints:TintSettings);
procedure TintDefaultSettings;


var
   Tint: TintSettings;
   TintVars: TintSet;

{+++++++++++++++++++++++++++++} IMPLEMENTATION {+++++++++++++++++++++++++++++}

procedure GoldSetColor(Zone:TintElement; Col:byte);
{}
begin
   with TintVars do
   if (not UsingMonoTints) or (not LeaveMonoTints) then
      Tint[Zone] := Col;
end; { GoldSetColor }

function GoldGetColor(Zone:TintElement): byte;
{}
begin
   GoldGetColor := Tint[Zone];
end; { GoldGetColor }

procedure UseColorDefaults;
{}
begin
   Tint := ColorTints;
   TintVars.UsingMonoTints := false;
end; { UseColorSet }

procedure UseMonoDefaults;
{}
begin
   Tint := MonoTints;
   TintVars.UsingMonoTints := true;
end; { UseMonoSet }

procedure UseColorScheme(var NewTints:TintSettings);
{}
begin
   Tint := NewTints;
   TintVars.UsingMonoTints := false;
end; { UseColorScheme }

              {*********************************************}
              {**  U N I T   I N I T I A L I Z A T I O N  **}
              {*********************************************}

procedure TintDefaultSettings;
{}
begin
   if ColorScreen then
      UseColorDefaults
   else
      UseMonoDefaults;
   TintVars.LeaveMonoTints := true;
end; { TintDefaultSettings }

procedure GoldTINTInit;
{}
begin
   TintDefaultSettings;
end; {GoldTINTInit}

begin
   GoldTINTInit;
end.
