{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit                       }
{                Version: GOLD                                             }
{                Build:   1.00                                             }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                         {************************}
                         {**  Unit:   GOLDREAD  **}
                         {************************}

{++++++++++++++++++++++++++++++} unit GOLDREAD; {++++++++++++++++++++++++++++}

{$I GOLDFLAG.INC}
{$IFNDEF GoldRead}
   {$DEFINE GoldRead}
{$ENDIF}

{++++++++++++++++++++++++++++++++} INTERFACE {+++++++++++++++++++++++++++++++}

uses DOS, CRT, GoldAttr, GoldHard, GoldTint, GoldStr, GoldWin, GoldMisc,
     GoldKey, GoldFast, GoldDate, GoldIO, GoldIO2, GoldIO3, GoldReal, GoldDir;

const
   MaxScrnFldLen = 30;

type

   ReadHelpHook = procedure;

   ReadSet = record
      LastEcode: integer;
      EMsgFunc: ErrMsgFunc;
      Boundary: gCoords;
      TotWinSpc: byte;
      LastAction: gAction;
      OutsideGap,
      ButtonGap: byte; { area between buttons }
      PromptStyle: byte; { Prompt window style }
      Len: byte;   { length of field }
      ForeGroundByte,
      BackGroundByte: integer;
      FldStrtPos: integer;
      ButStrtPos: integer;
      LabLen: byte;
      TmpPswdStr,
      PromptStrVar: StrScreen;
      PromptNumVar: longint;
      PromptFixedVar,
      PromptRealVar: extended;
      PromptDateVar: Dates;
      PromptRadioVar: byte;
      PromptColorVar: byte;
      Validation: gValidate;
      Password,
      Radio: boolean;
      ReadHelp: ReadhelpHook;
      TextSampleHook: HindHookProc;
      ColorWinDepth: byte;
      Use16BgndColors: boolean;
      FGLabel: string[12];
      BGLabel: string[12];
      FGHotKey: word;
      BGHotKey: word;
      SampleText: string[16];
      SampleTxtHdr: string[14];
      LowerSet: string[100];
      UpperSet: string[100];
      LabelAboveChar: char;
   end;

var
   ReadVars: ReadSet;

procedure ReadSetError(ECode:integer);
function  LastReadError: integer;
{Prompt Read}
function  PromptStr(X,Y,StrFldLen:byte;Lab,Tit:StrScreen;
                     Default:string;Caps:boolean): string;
function  PromptNum(X,Y:byte;Lab,Tit:StrScreen;
                     Default,Min,Max:LongInt;Spin:boolean): longint;
function  PromptReal(X,Y,FldLen:byte;Lab,Tit:StrScreen;
                     Default,Min,Max:extended): extended;
function  PromptFixedReal(X,Y:byte;Lab,Tit:StrScreen;WLen,DP:byte;
                     Default,Min,Max,Delta:extended;Spin:boolean): extended;
function  PromptDate(X,Y:byte;Lab,Tit:StrScreen;Fmat:gDate;
                     Default,Min,Max:Dates;Spin,Drop:boolean): Dates;
function  PromptRadio(X,Y:byte;Lab,Tit:StrScreen;Fields:string;Default:byte): byte;
function  PromptColor(X,Y,Default:byte;Cmt,Tit:StrScreen): byte;
procedure AssignTextSampleHook(Proc:HindHookProc);
procedure RemoveTextSampleHook;
procedure DefaultTextSample(CurrentField:byte;var Refresh:byte);
procedure AssignReadHelpHook(RFHook: ReadhelpHook);
procedure RemoveReadHelpHook;

{+++++++++++++++++++++++++++++} IMPLEMENTATION {+++++++++++++++++++++++++++++}
const
   ReadFormID = 2;
   SpinIconLen = 4;
   DropIconLen = 3;
   RadioIconLen = 5;
   InsideGap = 1;
   MaxRadioElements = 13;

                      {******************************}
                      {**  Miscellaneous Routines  **}
                      {******************************}

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}

function ReadEMsg(ECode:integer): string;
{}
begin
   case Ecode of
      0: exit;
      1: ReadEMsg := 'Unable to create Prompt IO form';
      else
         ReadEMsg := 'Internal Read error';
   end; {case}
end; { ReadEMsg }

{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure ReadSetError(ECode:integer);
{}
{$IFOPT D+}
var Msg: string;
{$ENDIF}
begin
   ReadVars.LastEcode := ECode;
{$IFOPT D+}  {if debug active display an error message and terminate}
   if Ecode <> 0 then
   begin
      str(Ecode,Msg);
      Msg := Msg+': '+ReadVars.EMsgFunc(Ecode);
      SetWinIgnore(true);
      if PromptCustom(' GoldRead Error ',Msg,' ~I~gnore ',' ~A~bort ','',279,286,0,0, 10000) = 2 then
         Halt;
   end;
{$ENDIF}
end; {ReadSetError}

function LastReadError: integer;
{}
begin
   LastReadError := ReadVars.LastECode;
end; { LastReadError }

procedure AssignReadHelpHook(RFHook: ReadhelpHook);
{}
begin
   ReadVars.ReadHelp := RFHook;
end; {AssignReadHelpHook }

procedure RemoveReadhelpHook;
{}
begin
   ReadVars.ReadHelp := nil;
end; { RemoveReadhelpHook }

function LineLen(Cmts,Tit:string;FldLen:byte;LabelIncluded:boolean): byte;
{}
var PromptLen, CmtsLen,
    TitLen, TmpLen,
    Border, ButStrLen: byte;
begin
   with ReadVars do
   begin
      CmtsLen := length(Cmts);
      Border := OutsideGap * 2;
      TitLen := Length(Tit) + Border + 2*ord(PromptStyle in [7,8]);
      ButStrLen := length(Strip('A',HiMarker,WinVars.OKbutStr+WinVars.CancelbutStr))
                   + 4 + ButtonGap + Border;
      if @Readhelp <> nil then
         inc(ButStrLen,ButtonGap+length(Strip('A',HiMarker,WinVars.HelpButStr))+2);
      if LabelIncluded then { Label on same line as field }
         PromptLen := InsideGap + CmtsLen + FldLen + Border
      else
         PromptLen := 0;
      TmpLen := GetMax(PromptLen,TitLen);
      TmpLen := GetMax(TmpLen,CmtsLen+Border);
      TmpLen := GetMax(TmpLen,FldLen+Border);
      LineLen := GetMax(TmpLen,ButStrLen);
      {       or the compact way!
      LineLen := GetMax(TmpLen,GetMax(GetMax(LabelLen+Border,FldLen+Border),ButStrLen));
      }
   end;
end; { LineLen }

procedure CalcWinCoords(X,Y:byte;FLen,WDep:byte);
{}
begin
   with ReadVars do
   begin
      case PromptStyle of
        0: begin       {no border}
           dec(FLen,2);
           dec(Wdep,2);
        end;
        7,8: inc(Flen,2);
        9: dec(WDep,5);
      end;
      with Boundary do
      begin
         if (X = 0) then  {center window}
         begin
            X1 := pred((HardVars.Width - FLen) div 2);
            X2 := X1 + succ(FLen);
         end else
         begin
            if X + FLen + 2 > HardVars.Width then
            begin
               X1 := HardVars.Width - FLen - 2;
               X2 := HardVars.Width;
            end else
            begin
               X1 := X;
               X2 := X + FLen + 2;
            end;
         end;
         if (Y = 0) then  {center window}
         begin
            Y1 := (HardVars.Depth - WDep) div 2;
            Y2 := Y1 + WDep;
         end else
         begin
            if Y + WDep + 2 > HardVars.Depth then
            begin
               Y1 := HardVars.Depth - WDep - 2;
               Y2 := HardVars.Depth;
            end else
            begin
               Y1 := Y;
               Y2 := Y + WDep;
            end;
         end;
      end;
   end;
end; { CalcWinCoords }

procedure CalcGlobals(var FldLen:byte;Lab:StrScreen; LabeltoLeft:boolean);
{}
begin
   with ReadVars do
   begin
      with Boundary do
         TotWinSpc := X2 - succ(X1) - 2*ord(PromptStyle in [7,8]);
      LabLen := length(Lab);
      if Radio then
         with Boundary do
            FldStrtPos := (TotWinSpc div 2) - ((FldLen+RadioIconLen) div 2)
      else
      begin
         if LabelToLeft then
            FldStrtPos := ((TotWinSpc div 2) - ((InsideGap + ord(LabelToLeft)*LabLen + FldLen) div 2))
                           + succ(InsideGap + ord(LabelToLeft)*LabLen)
         else
            FldStrtPos := succ(OutsideGap);
      end;
      ButStrtPos :=ButtonGap + length(Strip('A',HiMarker,WinVars.OKButStr+WinVars.CancelButStr)) + 4;
      if @Readhelp <> nil then
         inc(ButStrtPos,2+ButtonGap+length(Strip('A',HiMarker,WinVars.HelpButStr)));
      {at this point ButStrtPos is the length of all the buttons plus the gaps;
       time to change to the literal start pos of the OK button}
      ButStrtPos := TotWinSpc - pred(ButStrtPos) - Outsidegap;

   end;
end; { CalcGlobals }

procedure SetPromptColors;
{}
begin
   IOSetColor(IOWinTitle,Tint[PromptTitle]);
   IOSetColor(IOWinBorder1,Tint[PromptBorder1]);
   IOSetColor(IOWinBorder2,Tint[PromptBorder2]);
   IOSetColor(IOWinIcons,Tint[PromptIcons]);
   IOSetColor(IOButtonNorm,Tint[PromptButtonNorm]);
   IOSetColor(IOButtonNormHot,Tint[PromptButtonNormHot]);
   IOSetColor(IOButtonHi,Tint[PromptButtonHi]);
   IOSetColor(IOButtonHiHot,Tint[PromptButtonHiHot]);
   IOSetColor(IOButtonDef,Tint[PromptButtonDef]);
   IOSetColor(IOButtonDefHot,Tint[PromptButtonDefHot]);
   IOSetColor(IOWinBody,Tint[PromptBody]);
   IOSetColor(IOLabelNorm,Tint[PromptBody]);
   IOSetColor(IOLabelHiHot,Tint[PromptBodyHi]);
   IOSetColor(IOLabelHi,Tint[PromptBody]);
   IOSetColor(IOLabelNormHot,Tint[PromptBodyHi]);
   IOSetColor(IOEditNorm,Tint[PromptEditNorm]);
   IOSetColor(IOEditHi,Tint[PromptEditHi]);
   IOSetColor(IOEditErase,Tint[PromptEditErase]);
end; { SetPromptColors }

function SetWindow(Tit,Lab:StrScreen; LabelToLeft: boolean): boolean;
{Returns false if function fails}
var
  WinNum: byte;
  BX: byte;
begin
   with ReadVars do
   begin
      Validation := IOVars.DefaultValidate;
      IOVars.DefaultValidate := ValidateAtEnd;
      ActivatePrivateForm;
      SetPromptColors;
      with Boundary do
         SetFormWindow(X1,Y1,X2,Y2,PromptStyle);
      WinNum := FormWinNum;
      if WinNum = 0 then
      begin
         ReadSetError(1);
         exit
      end;
      ActivateWindow(WinNum);
      WinSetTitle(WinNum,Tit);
      WinSetType(WinNum,WMove);
      WinSetShowNum(WinNum,false);
      KwikAddField(1, FldStrtPos,2+ord(not LabelToLeft));
      with Boundary do
         KwikAddField(2, ButStrtPos,(Y2-Y1)-2);
      ButtonDefaultField(2, WinVars.OKButStr,Stop1);
      SetHK(2,WinVars.OKHotKey);
      BX := 2+ButStrtPos + length(strip('A',HiMarker,WinVars.OKButStr)) + ButtonGap;
      with Boundary do
         if @ReadVars.ReadHelp = nil then
            KwikAddLastField(3,BX,(Y2-Y1)-2)
         else
            KwikAddField(3,BX,(Y2-Y1)-2);
      ButtonField(3, WinVars.CancelButStr,Escaped);
      SetHK(3,WinVars.CancelHotKey);
      if @ReadVars.ReadHelp <> nil then
      begin
         inc(BX,2+length(strip('A',HiMarker,WinVars.OKButStr)) + ButtonGap);
         with Boundary do
            KwikAddLastField(4,BX,(Y2-Y1)-2);
         ButtonField(4, WinVars.HelpButStr,Stop9);
         SetHK(4,WinVars.HelpHotKey);
      end;
      FieldRules(1, AllowNull+EraseDefault,[NoChar],[NoChar]);
      if not LabelToLeft then
         SetLabel(1,Labeltop,Labeltop,Lab)
      else
         SetLabel(1,LabelLeft,LabelLeft,Lab);
      SetWindow := true;
   end;
end; { SetWindow }


function GetLabelLoc(var Lab:string):boolean;
{}
begin
   if (Lab <> '') and (Lab[1] = ReadVars.LabelAboveChar) then
   begin
      GetLabelLoc := false;
      delete(Lab,1,1);
   end
   else
      GetLabelLoc := true;
end; { GetLabelLoc }

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure ReadPassword(var K : word; var CurrentField:byte;var Refresh:byte);
{}
begin
   with ReadVars do
   begin
      if (K <> WinVars.OKHotKey) and
         (K <> WinVars.CancelHotKey) and
         (K <> 500) and (K <> 13) and (K <> 271) and (K <> 9) then
      begin
         if IsLetter(K) or IsDigit(K) then
         begin
            TmpPswdStr := TmpPswdStr + WordToChar(K);
            K := MaskChr;
         end
         else if K = 8 then
            delete(TmpPswdStr,length(TmpPswdStr),1)
         else
            K := 0;
         Refresh := RefreshCurrent;
      end;
   end;
end; { ReadPassword }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

function PromptStr(X,Y,StrFldLen:byte;Lab,Tit:StrScreen;
                     Default:string;Caps:boolean): string;
{}
var Action: gAction;
    FmtCh: char;
    TmpFldLen: byte;
    LabelToLeft,
    OverRide: boolean;
begin
   with ReadVars do
   begin
      LastAction := None;
      PromptStrVar := Default;
      OverRide := (StrFldLen > MaxScrnFldLen);
      if OverRide then
      begin
         TmpFldLen := StrFldLen;
         StrFldLen := MaxScrnFldLen;
      end;
      LabelToLeft := GetLabelLoc(Lab);
      CalcWinCoords(X,Y,LineLen(Lab,Tit,StrFldLen,LabelToLeft),6+ord(not LabelToLeft));
      CalcGlobals(StrFldLen,Lab,LabelToLeft);
      if not OverRide and Caps then
         FmtCh := '!'  { set to uppercase }
      else
         FmtCh := '*';
      if SetWindow(Tit,Lab,LabelToLeft) then
      begin
         if OverRide then
            ScrollField(1, PromptStrVar,MaxScrnFldLen,TmpFldLen)
         else
            StringField(1,PromptStrVar,Replicate(StrFldLen,FmtCh));
         if Password then
            AssignCharHook(ReadPassword);
         repeat
            LastAction := EditForm(1);
            if LastAction = Stop9 then
               ReadVars.ReadHelp;
         until LastAction in [Stop1,Finished,Escaped];
         if LastAction = Stop1 then
            if Password then
               if Caps then
                  PromptStr := SetUpper(TmpPswdStr)
               else
                  PromptStr := TmpPswdStr
            else
               PromptStr := PromptStrVar
         else
            PromptStr := Default;
         DisposeFields;
         DisposePrivateForm;
         IOVars.DefaultValidate := Validation;
         Password := false;
      end;
   end;
end; { PromptStr }

function  PromptNum(X,Y:byte;Lab,Tit:StrScreen;
                     Default,Min,Max:LongInt;Spin:boolean): longint;
{valid values are -2147483648..2147483647}
var MinLen, MaxLen,
    TmpLen, NumFldLen: byte;
    FmtCh: char;
    LabelToLeft: boolean;
begin
   with ReadVars do
   begin
      LastAction := none;
      PromptNumVar := Default;
      if (Min = 0) and (Max = 0) then
         NumFldLen := length(IntToStr(MaxLongInt))
      else
      begin
         MinLen := length(IntToStr(Min));
         MaxLen := length(IntToStr(Max));
         if MaxLen >= MinLen then
            NumFldLen := MaxLen
         else
            NumFldLen := MinLen;
      end;
      if Spin then
         NumFldLen := NumFldLen + SpinIconLen;
      LabelToLeft := GetLabelLoc(Lab);
      CalcWinCoords(X,Y,LineLen(Lab,Tit,NumFldLen,LabelToLeft),6+ord(not LabelToLeft));
      CalcGlobals(NumFldLen,Lab,LabelToLeft);
      FmtCh := '#';
      if SetWindow(Tit,Lab,LabelToLeft) then
      begin
         if Spin then
            SpinLongField(1, PromptNumVar, NumFldLen - SpinIconLen,Min,Max,1)
         else
            LongIntField(1,PromptNumVar,Replicate(NumFldLen,FmtCh),Min,Max);
         repeat
            LastAction := EditForm(1);
            if LastAction = Stop9 then
               ReadVars.ReadHelp;
         until LastAction in [Stop1,Finished,Escaped];
         if LastAction = Stop1 then
            PromptNum := PromptNumVar
         else
            PromptNum := Default;
         DisposeFields;
         DisposePrivateForm;
         IOVars.DefaultValidate := Validation;
      end;
   end;
end; { PromptNum }

function  PromptReal(X,Y,FldLen:byte;Lab,Tit:StrScreen;
                     Default,Min,Max:extended): extended;
{}
var RealFldLen: byte;
    FmtCh: char;
    LabelToLeft: boolean;
begin
   with ReadVars do
   begin
      LastAction := none;
      PromptRealVar := Default;
      RealFldLen := FldLen;
      LabelToLeft := GetLabelLoc(Lab);
      CalcWinCoords(X,Y,LineLen(Lab,Tit,RealFldLen,LabelToLeft),6+ord(not LabelToLeft));
      CalcGlobals(RealFldLen,Lab,LabelToLeft);
      FmtCh := '#';
      if SetWindow(Tit,Lab,LabelToLeft) then
      begin
         RealField(1,PromptRealVar,Replicate(RealFldLen,FmtCh),Min,Max);
         repeat
            LastAction := EditForm(1);
            if LastAction = Stop9 then
               ReadVars.ReadHelp;
         until LastAction in [Stop1,Finished,Escaped];
         if LastAction = Stop1 then
            PromptReal := PromptRealVar
         else
            PromptReal := Default;
         DisposeFields;
         DisposePrivateForm;
         IOVars.DefaultValidate := Validation;
      end;
   end;
end; { PromptReal }

function  PromptFixedReal(X,Y:byte;Lab,Tit:StrScreen;WLen,DP:byte;
                     Default,Min,Max,Delta:extended;Spin:boolean): extended;
{}
var FxdFldLen: byte;
    LabelToLeft: boolean;
begin
   with ReadVars do
   begin
      LastAction := none;
      PromptFixedVar := Default;
      if DP = 0 then
         FxdFldLen := WLen
      else
         FxdFldLen := WLen + succ(DP);
      if Spin then
         FxdFldLen := FxdFldLen + SpinIconLen;
      LabelToLeft := GetLabelLoc(Lab);
      CalcWinCoords(X,Y,LineLen(Lab,Tit,FxdFldLen,LabelToLeft),6+ord(not LabelToLeft));
      CalcGlobals(FxdFldLen,Lab,LabelToLeft);
      if SetWindow(Tit,Lab,LabelToleft) then
      begin
         if Spin then
            SpinRealField(1,PromptFixedVar,WLen,DP,Min,Max,Delta)
         else
            FixedRealField(1,PromptFixedVar,WLen,DP,Min,Max);
         repeat
            LastAction := EditForm(1);
            if LastAction = Stop9 then
               ReadVars.ReadHelp;
         until LastAction in [Stop1,Finished,Escaped];
         if LastAction = Stop1 then
            PromptFixedReal := PromptFixedVar
         else
            PromptFixedReal := Default;
         DisposeFields;
         DisposePrivateForm;
         IOVars.DefaultValidate := Validation;
      end;
   end;
end; { PromptFixedReal }

function  PromptDate(X,Y:byte;Lab,Tit:StrScreen;Fmat:gDate;
                     Default,Min,Max:Dates;Spin,Drop:boolean): Dates;
{}
var DatFldLen: byte;
    LabelToLeft: boolean;
begin
   with ReadVars do
   begin
      LastAction := none;
      PromptDateVar := Default;
      if Spin then
         DatFldLen := 12;
      if Drop then
         DatFldLen := 11;
      if Spin and Drop then
         DatFldLen := 13;
      LabelToLeft := GetLabelLoc(Lab);
      CalcWinCoords(X,Y,LineLen(Lab,Tit,DatFldLen,LabelToLeft),6+ord(not LabelToLeft));
      CalcGlobals(DatFldLen,Lab,LabelToLeft);
      if SetWindow(Tit,Lab,LabelToLeft) then
      begin
         if Spin and Drop then
            SpinDropDateField(1, PromptDateVar, Fmat,'',Min,Max)
         else if Drop then
            DropDateField(1, PromptDateVar, Fmat,'',Min,Max)
         else if Spin then
            SpinDateField(1, PromptDateVar, Fmat,'',Min,Max)
         else DateField(1, PromptDateVar, Fmat, '', Min,Max);
         repeat
            LastAction := EditForm(1);
            if LastAction = Stop9 then
               ReadVars.ReadHelp;
         until LastAction in [Stop1,Finished,Escaped];
         if LastAction = Stop1 then
            PromptDate := PromptDateVar
         else
            PromptDate := Default;
         DisposeFields;
         DisposePrivateForm;
         IOVars.DefaultValidate := Validation;
      end;
   end;
end; { PromptDate }

function PromptRadio(X,Y:byte;Lab,Tit:StrScreen;Fields:string;Default:byte): byte;
{NOTES:  The Fields parameter is a string of element names.
         Each element is separated by a split bar (|).
         The Default parameter is the beginning element.    }
var RadFldLen,
    ElementCount, I: byte;
    ElementStr: StrScreen;

   function GetElement: StrScreen;
   {}
   begin
      if (pos(StrVars.LineBreak,Fields) = 0) then
         GetElement := copy(Fields,1,length(Fields))
      else
         GetElement := copy(Fields,1,pred(pos(StrVars.LineBreak,Fields)));
      delete(Fields,1,pos(StrVars.LineBreak,Fields));
   end;

begin
   with ReadVars do
   begin
      LastAction := none;
      Radio := true;
      RadFldLen := WidestLine(Fields);
      ElementCount := succ(CharCount(StrVars.LineBreak,Fields));
      if ElementCount > MaxRadioElements then
         ElementCount := MaxRadioElements;
      CalcWinCoords(X,Y,LineLen(Lab,Tit,RadFldLen,false)+RadioIconLen,ElementCount+6);
      CalcGlobals(RadFldLen,Lab,false);
      if SetWindow(Tit,Lab,false) then
      begin
         PromptRadioVar := Default;
         RadioField(1,succ(RadFldLen+RadioIconLen),ElementCount,PromptRadioVar);
         for I := 1 to ElementCount do
             RadioAddItem(1, 1,I,GetElement,'',0);
         repeat
            LastAction := EditForm(1);
            if LastAction = Stop9 then
               ReadVars.ReadHelp;
         until LastAction in [Stop1,Finished,Escaped];
         if LastAction = Stop1 then
            PromptRadio := PromptRadioVar
         else
            PromptRadio := Default;
         DisposeFields;
         DisposePrivateForm;
         IOVars.DefaultValidate := Validation;
      end;
      Radio := false;
   end;
end; { PromptRadio }

procedure AssignTextSampleHook(Proc:HindHookProc);
{}
begin
   ReadVars.TextSampleHook := Proc;
end; { AssignTextSampleHook }

procedure RemoveTextSampleHook;
{}
begin
   ReadVars.TextSampleHook := DefaultTextSample;
end; { RemoveTextSampleHook }

function ColorSet(BothSets:boolean): string;
{}
begin
   if BothSets then
      ColorSet := ReadVars.LowerSet+'|'+ReadVars.UpperSet
   else
      ColorSet := ReadVars.LowerSet;
end; { ColorSet }


{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}

procedure DefaultTextSample(CurrentField:byte;var Refresh:byte);
{}
var A: byte;
begin
   with ReadVars do
   begin
      Refresh := RefreshOthers;
      A := Cattr(pred(ForeGroundByte),pred(BackGroundByte));
      WriteAT(succ(OutsideGap),8,Tint[PromptBody],SampleTxtHdr);
      WriteAT(succ(OutsideGap),9,A,SampleText);
      WriteAT(succ(OutsideGap),10,A,SampleText);
   end;
end; { DefaultTextSample }

{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

function PromptColor(X,Y,Default:byte;Cmt,Tit:StrScreen): byte;
{}
var FldStrtPos,
    ColorFldLen : byte;
    WinNum: integer;
    CmtVar: string[40];
begin
   with ReadVars do
   begin
      LastAction := None;
      ColorFldLen := 29 + length(strip('A',HiMarker,WinVars.OKButStr)) + (OutsideGap*2) + ButtonGap;
      ForeGroundbyte := succ(Fattr(Default));
      BackGroundbyte := succ(Battr(Default));
      if ColorWinDepth > 22 then
         ColorWinDepth := 22;
      CalcWinCoords(X,Y,LineLen(Cmt,Tit,ColorFldLen,false),ColorWinDepth);
      CalcGlobals(ColorFldLen,Cmt,true);
      Validation := IOVars.DefaultValidate;
      IOVars.DefaultValidate := ValidateAtEnd;
      ActivatePrivateForm;
      SetPromptColors;
      with Boundary do
         SetFormWindow(X1,Y1,X2,Y2,PromptStyle);
      WinNum := FormWinNum;
      if WinNum = 0 then
      begin
         DisposePrivateForm;
         ReadSetError(1);
         exit
      end;
      ActivateWindow(WinNum);
      WinSetTitle(WinNum,Tit);
      WinSetType(WinNum,WMoveNoClose);
      WinSetShowNum(WinNum,false);
      WinDisplay(WinNum);
      if Cmt <> '' then
         WriteHi(succ(OutsideGap),2,Tint[PromptBodyHi],Tint[PromptBody],Cmt);
      AssignHindHook(ReadVars.TextSampleHook);
      FldStrtPos := ((TotWinSpc div 2) - (ColorFldLen div 2));
      KwikAddField(1, 12+OutsideGap,4);      { foreground }
      KwikAddField(2, 12+OutsideGap,6);      { background }
      KwikAddField(3, 35,4);      { OK button }
      if @ReadHelp = nil then
         KwikAddLastField(4, 35,6)  { Cancel Button }
      else
      begin
         KwikAddField(4, 35,6);
         KwikAddLastField(5, 35,8);
      end;
      SpinDropListField(1,12,ForeGroundByte);
      SetLabel(1,LabelLeft,LabelLeft,FGLabel);
      SetHK(1,FGHotKey);
      ListKwikAddItem(1,LowerSet+'|'+UpperSet);
      SpinDropListField(2,12,BackGroundByte);
      SetLabel(2,LabelLeft,LabelLeft,BGLabel);
      SetHK(2,BGHotKey);
      ListKwikAddItem(2,ColorSet(Use16BgndColors));
      ButtonDefaultField(3, WinVars.OKButStr,Stop1);
      SetHK(3,WinVars.OKHotKey);
      ButtonField(4, WinVars.CancelButStr,Escaped);
      SetHK(4, WinVars.CancelHotKey);
      if @ReadHelp <> nil then
      begin
         ButtonField(5, WinVars.HelpButStr,Stop9);
         SetHK(5, WinVars.HelpHotKey);
      end;
      repeat
         LastAction := EditForm(1);
         if LastAction = Stop9 then
            ReadVars.ReadHelp;
      until LastAction in [Stop1,Finished,Escaped];
      if LastAction = Stop1 then
         PromptColor := Cattr(pred(ForeGroundByte),pred(BackGroundByte))
      else
         PromptColor := Default;
      DisposeFields;
      DisposePrivateForm;
   end;
end; { PromptColor }

              {*********************************************}
              {**  U N I T   I N I T I A L I Z A T I O N  **}
              {*********************************************}

procedure ReadDefaultSettings;
{}
begin
   with ReadVars do
   begin
      PromptStyle := WinVars.PromptStyle;
      Use16BgndColors := false;
      FGLabel := '~F~oreground';
      BGLabel := '~B~ackground';
      FGHotKey := 289;          { Alt+F }
      BGHotKey := 304;          { Alt+B }
      SampleText := ' Text Text Text ';
      SampleTxtHdr := 'Sample Text';
      LowerSet := 'Black|Blue|Green|Cyan|Red|Magenta|Brown|LightGray';
      UpperSet := 'DarkGray|LightBlue|LightGreen|LightCyan|LightRed|LightMagenta|Yellow|White';
      OutsideGap := 2;
      ButtonGap := 2;
      Password := false;
      TextSampleHook := DefaultTextSample;
      ColorWinDepth := 12;
      LabelAboveChar := '^';
   end;
end; { ReadDefaultSettings }

procedure GoldReadInit;
{}
begin
   with ReadVars do
   begin
      EMsgFunc := ReadEMsg;
      ReadHelp := nil;
      with Boundary do
      begin
         X1 := 0;
         Y1 := 0;
         X2 := 0;
         Y2 := 0;
      end;
      TmpPswdStr := '';
      Radio := false;
   end;
   ReadDefaultSettings;
end; {GoldReadInit}

begin
   GoldReadInit;
end.
