{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit                       }
{                Version: GOLD                                             }
{                Build:   1.00                                             }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                    {*********************************}
                    {**       Unit:   GOLDDIR       **}
                    {*********************************}

{++++++++++++++++++++++++++++++} unit GOLDDIR; {++++++++++++++++++++++++++++}

{$I GOLDFLAG.INC}
{$IFNDEF GOLDDIR}
   {$DEFINE GOLDDIR}
{$ENDIF}

{++++++++++++++++++++++++++++++++} INTERFACE {+++++++++++++++++++++++++++++++}

uses DOS, CRT, GoldHard, GoldMisc, GoldKey, GoldFast, GoldWin, GoldIO,
     GoldIO2, Goldio3, GoldLink, GoldStr, GoldTint, GoldDate, GoldList;


type
   DirTints = Array [DirPathInfo..DirFileInfo] of byte;

   PromptHelpHook = procedure;

   DirSet = record
      ExistsOnly: boolean;
      LastECode: integer;
      ScrlFldVar: PathStr;
      FileFldVar: integer;
      DirFldVar: integer;
      TypeFldVar: integer;
      DrvFldVar: integer;
      FilLst, DirLst,
      TypLst, DrvLst: StringLL;
      InputField: string;
      Attr: word;
      SavedPath,
      DefaultMask: PathStr;
      Col: DirTints;
      {List-related}
      LX1,LX2,LY1,LY2,
      LWinStyle: byte;
      AllowDirChange: boolean;
      AllowDrvChange: boolean;
      NameList: DoubleLLPtr;
      SortbyName: boolean;
      LastAction: gAction;
      EMsgFunc: ErrMsgFunc;
      {text}
      PromptFileHelp: PrompthelpHook;
      StrPromptFileTitle: string[60];
      StrPromptDirTitle: string[40];
      OpenButStr: strButton;
      OpenHK: word;
      NotReadyTitle: string [30];
      NotReadyMsgA: string [30];
      NotReadyMsgB: string [60];
      NoExistTitle: string [30];
      NoExistText: string [60];
      ParentStr: string[30];
      SubDirStr: string[30];
      RootStr: string[30];
      NoFilesStr: string[30];
      RootNameStr: string[12];
      DriveStr: string[20];
      SortingStr: string[30];
   end;

function  PromptFile(FullFilename:PathStr): StrScreen;
function  FileList(FullFilename:PathStr; Tit:StrScreen): StrScreen;
function  PromptDir(FullFilename:PathStr;Cmt:StrScreen): StrScreen;
function  LastDirError: integer;
procedure AssignDirHelpHook(PFHook: PrompthelpHook);
procedure RemoveDirhelpHook;

{$IFDEF TTT5}
function Display_Directory(DIRFULLFileName: StrScreen;var Retcode:integer): StrScreen;
{$ENDIF}

var
   DirVars: DirSet;

{+++++++++++++++++++++++++++++} IMPLEMENTATION {+++++++++++++++++++++++++++++}
var
   StartPathStr,
   LastMaskStr: PathStr;
   LastDir: DirStr;
   LastFullFileName: PathStr;
   LastFld4Val: PathStr;
   LastDrv: byte;
   CurrFld: integer;
   Action: gAction;
   SavedDrv,
   SavedDir: integer;
   CDirLine: byte;

                      {******************************}
                      {**  Miscellaneous Routines  **}
                      {******************************}

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
function DirEMsg(ECode:integer): string;
{}
begin
   case Ecode of
      0: exit;
      1: DirEMsg := 'Insufficient memory to display files';
      2: DirEMsg := 'Passed parameter can''t be located';
      3: DirEMsg := 'Unable to reset original path';
      4: DirEMsg := 'Error testing selected directory';
      else
         DirEMsg := 'Internal directory error';
   end; {case}
end; { DirEMsg }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure DirSetError(ECode:integer);
{}
{$IFOPT D+}
var Msg: string;
{$ENDIF}
begin
   DirVars.LastEcode := ECode;
{$IFOPT D+}  {if debug active display an error message and terminate}
   if Ecode <> 0 then
   begin
      str(Ecode,Msg);
      Msg := Msg+': '+DirVars.EMsgFunc(Ecode);
      SetWinIgnore(true);
      if PromptCustom(' GoldDir Error ',Msg,' ~I~gnore ',' ~A~bort ','',279,286,0,0, 10000) = 2 then
         Halt;
   end;
{$ENDIF}
end; {DirSetError}

function LastDirError: integer;
{}
begin
   LastDirError := DirVars.LastECode;
end; { LastDirError }

function RealDriveID(ListID: byte): byte;
{}
begin
   RealDriveID := ListID + ord((ListID <> 1) and IsPhantom);
end; { RealDriveID }

procedure AssignDirHelpHook(PFHook: PrompthelpHook);
{}
begin
   DirVars.PromptFileHelp := PFHook;
end; {AssignDirHelpHook }

procedure RemoveDirhelpHook;
{}
begin
   DirVars.PromptFileHelp := nil;
end; { RemoveDirhelpHook }

function FileDetailsStr(Fname:PathStr;PadIt: boolean): PathStr;
{}
var
   SrchRec: SearchRec;
   DT: DateTime;
   Secs: longint;
begin
   findfirst(Fname,AnyFile,SrchRec);
   UnPackTime(SrchRec.Time,DT);
   with DT do
   begin
      Secs := TimetoLong(Hour,Min,Sec);
      if PadIt then
         FileDetailsStr := PadLeft(SrchRec.Name,12,' ')+' '+
                         PadLeft(IntToStr(SrchRec.Size),12,' ')+' '+
                         FancyDateStr(GregToJul(DT.Month,
                                      DT.Day,DT.Year),false,false)+'  '+
                         LongToTimeStr(Secs,HHMM,true,false)
      else
         FileDetailsStr := SrchRec.Name+' '+
                           IntToStr(SrchRec.Size)+' '+
                           FancyDateStr(GregToJul(DT.Month,
                                      DT.Day,DT.Year),false,false)+' '+
                           LongToTimeStr(Secs,HHMM,true,false)

   end;
end; { FileDetailsStr }

procedure RefreshLongDesc;
{Writes the file or directory details in the directory window}
begin
   with DirVars do
   begin
      {erase and update current directory}
      WriteAT(3,14,Col[DirPathInfo],Replicate(50,' '));
      WriteAT(3,14,Col[DirPathInfo],LastDir);
      {erase and if appropriate, update file information}
      WriteAT(3,15,Col[DirFileInfo],Replicate(50,' '));
      if (StrLLGetStr(FilLst,FilLst.ActiveNode) <> LinkVars.NoFilesFound) then
         WriteAT(3,15,Col[DirFileInfo],FileDetailsStr(SlashedDirectory(LastDir)+StrLLGetStr(FilLst,FileFldVar),true));
   end;
end; { RefreshLongDesc }

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure DirLeaveHook(var CurrentField:byte;var Refresh:byte);
{}
begin
  if CurrentField = 1 then
   begin
      with DirVars do
      begin
         if (LastMaskStr <> ScrlFldVar) then
         begin
            if (length(ScrlFldVar) > 0) then
            begin
               if ((pos('*',ScrlFldVar) <> 0)
                  or (pos('?',ScrlFldVar) <> 0)) then
               begin
                  LastMaskStr := ScrlFldVar;
                  if (LoadWithFiles(FilLst,LastDir,LastMaskStr,Attr) = 0) then
                     ListUpDateStrLL(2,FilLst);
               end else
               begin
                  if (pos('*',ScrlFldVar) = 0)
                     and (pos('?',ScrlFldVar) = 0) then
                  Action := Finished;
               end;
               Refresh := RefreshOthers;
               CurrFld := 1;
            end;
         end;
      end;
   end;
end; { DirLeaveHook }

procedure DirHindHook(CurrentField:byte;var Refresh:byte);
{}
var
   StartDrv,
   gResult: integer;
   Tmp: string;
   LK: word;

    procedure ChangeDrives;
    {}
    begin
       with DirVars do
       begin
          ListUpdateStrLL(3,DirLst);
          if (pos('*',ScrlFldVar) = 0) and (pos('?',ScrlFldVar) = 0) then
             ScrlFldVar := LastMaskStr;
          if ( LoadWithFiles(FilLst,LastDir,ScrlFldVar,DirVars.Attr) = 0 ) then
             ListUpdateStrLL(2,FilLst);
          Refresh := RefreshAll;
          CurrFld := 5;
       end;
    end; { ChangeDrives }

begin
   Refresh := RefreshNone;
   case CurrentField of
      0: begin                 { first time thru }
         end;
      1: begin
            CurrFld := 1;
         end;
      2: begin                        { FileListField }
            with DirVars do
            begin
               Tmp := StrLLGetStr(FilLst,FileFldVar);
               if (Tmp = LinkVars.NoFilesFound) then
                  ScrlFldVar := LastMaskStr
               else if (ListLastKey(2) = 540) or (KeyVars.LastKey = 13) then
                  Refresh := EndInput
               else
               begin
                  ScrlFldVar := StrLLGetStr(FilLst,FileFldVar);
                  Refresh := RefreshOthers;
               end;
               CurrFld := 2
            end;
         end; {2}
      3: begin                        { DirectoryListField }
            LK := ListLastKey(3);
            if (KeyVars.LastKey = 13) or (LK = 540) then     {Enter or left double click}
            with DirVars do
            begin
               Tmp := StrLLGetStr(DirLst,DirFldVar);
               if (Tmp <> LinkVars.NoDirectories) then
               begin
                  delete(Tmp,length(tmp),1);    { deletes brackets }
                  delete(Tmp,1,1);
                  {$I-}
                  ChDir(Tmp);
                  gResult := IOResult;
                  {$I+}
                  if gResult <> 0 then
                     exit
                  else
                  begin
                     LastDir := CurrentPathStr;
                     if ( LoadWithDirectories(DirLst,LastDir) = 0 ) then
                     begin
                        ListUpdateStrLL(3,DirLst);
                        if (LoadWithFiles(FilLst,LastDir,LastMaskStr,Attr) = 0) then
                        begin
                           ListUpdateStrLL(2,FilLst);
                           ScrlFldVar := LastMaskStr;
                        end;
                        Refresh := RefreshAll;
                        CurrFld := 3;
                     end;
                  end;
               end;
            end;
         end; {3}
      4: begin                        { FileMaskField }
            with DirVars do
            begin
               Tmp := StrLLGetStr(TypLst,TypeFldVar);
               if ( LastFld4Val <> Tmp ) then
               begin
                  LastFld4Val := Tmp;
                  LastMaskStr := Tmp;
                  if ( LoadWithFiles(FilLst,LastDir,LastFld4Val,DirVars.Attr) = 0 ) then
                     ListUpdateStrLL(2,FilLst);
                  ScrlFldVar := LastMaskStr;
                  Refresh := RefreshAll;
                  CurrFld := 4;
               end;
            end;
         end;
      5: begin              { DriveField }
            with DirVars do
            begin
               if DrvFldVar <> LastDrv then
               begin
                  StartDrv := LastDrv;
                  LastDrv := DrvFldVar;
                  if (LastDrv >= 2) and IsPhantom then
                     inc(LastDrv);
                  SetCurrentDriveTo(DriveChar(LastDrv));
                  LastDir := CurrentPathStr;
                  if ( LoadWithDirectories(DirLst,LastDir) = 0 ) then
                     ChangeDrives
                  else
                  begin
                     Tmp := NotReadyMsgA + DriveChar(LastDrv) +':|' + NotReadyMsgB;
                     repeat
                         if PromptOKCancel(NotReadyTitle,Tmp) = 2 then
                         begin
                            LastDrv := StartDrv;
                            DrvFldVar := LastDrv - ord(IsPhantom and (LastDrv <> 1));
                            LastDrv := DrvFldVar;
                            (*
                            DrvLst.ActiveNode := DrvFldVar;
                            *)
                            SetCurrentDriveTo(DriveChar(RealDriveID(LastDrv)));
                            LastDir := CurrentPathStr;
                            if LoadWithDirectories(DirLst,LastDir) <> 0 then
                               {too bad};
                            Refresh := RefreshCurrent;
                            exit;
                         end;
                     until LoadWithDirectories(DirLst,LastDir) = 0;
                     ChangeDrives;
                  end;
               end;
            end;
         end;  {5}
      6: begin
            CurrFld := 1;
         end;
   end; { case of CurrentField }
   RefreshLongDesc;
end; {DirHindHook}

{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure ParseDriveandMask(FullFilename: PathStr; var Path: PathStr);
{Parses FullFilename into the specified path and filemask}
var P: byte;
begin
   FullFileName := SetUpper(FullFileName);
   if FullFileName = '' then
   begin
      P := pos(' ',DirVars.DefaultMask);
      if P = 0 then
         LastMaskStr := DirVars.DefaultMask
      else
         LastMaskStr := copy(DirVars.DefaultMask,1,pred(P));
      Path := CurrentPathStr;
   end else
   begin
      P := LastPos('\',FullFileName);
      if (P = 0) then
      begin
         Path := CurrentPathStr;
         if ((pos('*',FullFileName)=0) and (pos('?',FullFileName)=0)) then
            LastMaskStr := DirVars.DefaultMask
         else
            LastMaskStr := FullFileName;
      end
      else
      begin
         LastMaskStr := copy(FullFileName,succ(P),255);
         if ((pos('*',LastMaskStr)=0) and (pos('?',LastMaskStr)=0)) then
            LastMaskStr := DirVars.DefaultMask;
         Path := copy(FullFileName,1,pred(P));
         if path = '' then
            Path := '\';
      end;
   end;
   DirVars.ScrlFldVar := LastMaskStr;
   LastDir := Path;
   LastFullFileName := '';
end; { ParseDriveandMask }

Function PromptFile( FullFilename: PathStr): StrScreen;
{FullFileName includes path name and may include
 additional file masks, space delimited.
         Example:   C:\SUB1\SUB2\*.PAS     }
var
  DirWin: integer;
  Mask: DirStr;
  Path: PathStr;
  StartDir: PathStr;
  Completed: boolean;

   procedure SetFields;
   {}
   begin
      ActivatePrivateForm;
      AssignHindHook(DirHindHook);
      AssignLeaveFieldHook(DirLeaveHook);
      SetFormWindow(14,5,66,21,1);
      WinSetTitle(FormWinNum,DirVars.StrPromptFileTitle);
      WinSetType(FormWinNum,WMove);
      WinSetShowNum(FormWinNum,false);
      KwikAddField(1,3,2);    { file name }
      KwikAddField(2,3,4);    { file list }
      KwikAddField(3,21,4);   { directory list }
      KwikAddField(4,3,12);   { file mask list }
      KwikAddField(5,21,12);  { drive list }
      KwikAddField(6,39,2);   { OK Button }
      if @DirVars.PromptFileHelp = nil then
         KwikAddLastField(7,39,4)   { Cancel Button }
      else
      begin
         KwikAddField(7,39,4);        { Cancel Button }
         AddHotkeyField(8,315,Stop9); { F1 }
         KwikAddLastField(9,39,6);    { Help Button }
      end;
      with DirVars do
      begin
         ScrollField(1,ScrlFldVar,33,pred(sizeof(ScrlFldVar)));
         FieldRules(1,AllowNull+EraseDefault,[NoChar],[NoChar]);
         ListField(2,15,7,FileFldVar);
         if (LoadWithFiles(FilLst,Path,LastMaskStr,DirVars.Attr) = 0) then
            ListAssignStrLL(2,FilLst);
         ListField(3,15,7,DirFldVar);
         if (LoadWithDirectories(DirLst,Path) = 0) then
            ListAssignStrLL(3,DirLst);
         DropListField(4,15,TypeFldVar);
         if DirVars.DefaultMask = '' then
         begin
            if (LoadAvailFileExtensions(TypLst,Path) = 0) then ;
         end else
         begin
            DefaultMask := SetUpper(DefaultMask);
            if (LoadFileMasks(TypLst,DefaultMask) = 0) then ;
         end;
         LastFld4Val := StrLLGetStr(TypLst,TypeFldVar);
         ListAssignStrLL(4,TypLst);
         DrvFldVar := CurrentDriveByte;
         if (DrvFldVar >= 2) and IsPhantom then
           dec(DrvFldVar);
         DropListField(5,15,DrvFldVar);
         if (LoadWithDrives(DrvLst) = 0) then
         begin
            DrvLst.ActiveNode := DrvFldVar;
            ListAssignStrLL(5,DrvLst);
            LastDrv := DrvLst.ActiveNode;
         end;
         ButtonDefaultField(6,OpenButStr,Stop1);
         ButtonField(7,WinVars.CancelButStr,Escaped);
         SetHK(6,OpenHK);
         SetHK(7,WinVars.CancelHotkey);
         if @DirVars.PromptFileHelp <> nil then
         begin
           ButtonField(9,WinVars.HelpButStr,Stop9);
           SetHK(9,WinVars.HelpHotKey);
         end;
      end;
   end; { SetFields }

   procedure InitFieldVars;
   {}
   begin
      with DirVars do
      begin
         FileFldVar := 1;
         DirFldVar := 1;
         TypeFldVar := 1;
         DrvFldVar := 1;
      end;
   end; { InitFieldVars }

begin
   StartDir := CurrentPathStr;
   Path := '';
   Completed := false;
   ParseDriveandMask(FullFileName, Path);
   InitFieldVars;
   SetFields;
   MouseShow(true);
   CurrFld := 1;
   repeat
      DisplayAllFields;
      Action := EditForm(CurrFld);
      case Action of
         Finished,
         Stop1:    { open }
            with DirVars do
            begin
               ScrlFldVar := Strip('B',' ',ScrlFldVar);
               if (CurrFld = 1) and
                  { does not contain any wildcards }
                  (pos('*',ScrlFldVar) = 0) and (pos('?',ScrlFldVar) = 0) then
               begin
                  if ScrlFldVar = '' then
                     ScrlFldVar := LastMaskStr
                  else
                  begin
                     if ExistsOnly then
                     begin
                        if (ValidFileName(FExpand(ScrlFldVar)) = 0) then
                        begin
                           Completed := true;
                           PromptFile := FExpand(ScrlFldVar);
                        end else
                           PromptOK(DirVars.NoExistTitle,'^'+ScrlFldVar+DirVars.NoExistText);
                     end
                     else if (ValidFileName(ScrlFldVar) = 0) then
                     begin
                        PromptFile := FExpand(DirVars.ScrlFldVar);
                        Completed := true;
                     end
                     else
                     begin
                        PromptFile := DirVars.ScrlFldVar;
                        Completed := true;
                     end;
                  end;
               end else
               begin
                  if (pos('*',ScrlFldVar) = 0) and (pos('?',ScrlFldVar) = 0) then
                  begin
                     if (CurrFld = 2) then
                     begin
                        PromptFile := FExpand(DirVars.ScrlFldVar);
                        Completed := true;
                     end;
                  end else
                  begin
                     LastMaskStr := ScrlFldVar;
                     if (LoadWithFiles(FilLst,LastDir,LastMaskStr,DirVars.Attr) = 0) then
                        ListUpdateStrLL(2,FilLst);
                  end;
               end;
            end;
         Escaped:
            begin
               PromptFile := '';
               Completed := true;
            end;
         Stop9:
            begin
               DirVars.PromptFileHelp;
            end;
      end; { case }
   until Completed;
   DisposeFields;
   DisposePrivateForm;
   {$I-}
   chdir(StartDir);
   {$I+}
   if IOResult <> 0 then
      DirSetError(4);
   with DirVars do
   begin
      StrLLDestroy(DrvLst);
      StrLLDestroy(TypLst);
      StrLLDestroy(DirLst);
      StrLLDestroy(FilLst);
   End;
end; { PromptFile }

                             {****************}
                             {**  FileList  **}
                             {****************}

procedure PopulateList;
{}
var
   WrdCnt,
   I, gResult: integer;
   Mask: DirStr;
   SrchRec: SearchRec;
   DrvCh: char;
begin
   I := 1;
   DLLDestroy;
   WrdCnt := WordCnt(LastMaskStr);
   while (WrdCnt > 0) and (I < succ(WrdCnt)) do
   begin
      Mask := ExtractWords(I,1,lastMaskStr);
      findfirst(Mask,DirVars.Attr-Directory,SrchRec);
      while DosError = 0 do
      begin
         if (SrchRec.Attr and Directory <> Directory) then
         begin
            gResult := DllAddStr(SrchRec.Name);
            if (gResult <> 0) then
            begin
               {display a not enough message}
               exit;
            end;
         end;
         findnext(SrchRec);
      end;
      inc(I);
   end;
   if LinkVars.ActiveDLL^.TotalNodes = 0 then
      gResult := DLLAddStr(LinkVars.NoFilesFound)
   else if DirVars.SortByName then
   begin
      I := length(DirVars.SortingStr) + 6;
      gResult := (HardVars.Width - I) div 2;
      MkWin(gResult,10,gResult + pred(I),12,Tint[ListTitle],4);
      WriteCenter(11,0,DirVars.SortingStr);
      DLLSort(0,true);
      RmWin;
   end;
   if DirVars.AllowDirChange then {add all the directories}
   begin
      findfirst('*.*',Directory,SrchRec);
      while DosError = 0 do
      begin
         if (SrchRec.Attr and Directory = Directory) then
         begin
            if (SrchRec.Name = '.') then
            begin
               if DirVars.RootnameStr <> '' then
                  gResult := DllAddStr(DirVars.RootNameStr)
               else
                  gResult := -1;    {hack}
            end
            else
               gResult := DllAddStr(SrchRec.Name);
            if (gResult > 0) then
            begin
               {display a not enough message}
               exit;
            end
            else if (gResult = 0) then
            begin
               DLLSetBit(LinkVars.ActiveDLL^.EndNodePtr,1,true);
               DLLSetBit(LinkVars.ActiveDLL^.EndNodePtr,2,true);  {don't allow dirs to be tagged}
            end;
         end;
         findnext(SrchRec);
      end;
   end;
   if DirVars.AllowDrvChange then {add all the drives}
   begin
      for I := 1 to 26 do
      begin
         DrvCh := DriveChar(I);
         if DriveExists(DrvCh) then
         begin
            gResult := DLLAddStr('[ -'+DrvCh+'- ]');
            if gResult <> 0 then
            begin
              {display a not enough message}
              exit;
            end;
            DLLSetBit(LinkVars.ActiveDLL^.EndNodePtr,1,true);
            DLLSetBit(LinkVars.ActiveDLL^.EndNodePtr,2,true);  {don't allow dirs to be tagged}
         end;
      end;
   end;
end; { PopulateList }

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure FileListHook(DirFormatPtr:ListCfgPtr);
{}
var
   Fname: string[21];
   Str: StrScreen;
   DNP: DoubleNodePtr;
begin
   with DirFormatPtr^ do
   begin
      WriteAT(2,succ(Y2),Tint[DirListInfo],
              Squeeze('R',SlashedDirectory(LastDir)+LastMaskStr,pred(X2-X1)));
      DNP := DLLNodePtr(ActiveNode);
      FName := DLLGetNodeStr(DNP,0,0);
      if DLLGetBit(DNP,2) then  {directory or drive}
      begin
         if Fname = '..' then
            Str := DirVars.ParentStr + ' '+ ParentDirectory(LastDir)
         else if FName = DirVars.RootnameStr then
            Str := DirVars.RootStr
         else if copy(FName,1,3) <> '[ -' then
            Str := DirVars.SubDirStr+' '+Fname
         else
            Str := DirVars.DriveStr + ' '+copy(FName,4,1)+':';
      end
      else if Fname = LinkVars.NoFilesFound then
            Str := DirVars.NoFilesStr
      else
         Str := FileDetailsStr(FName,false);
      WriteAT(2,Y2+2,Tint[DirListInfo],Squeeze('L',Str,pred(X2-X1)));
   end;
end; {FileListHook}

function DirSelectHook(ListdetailsPtr:ListCfgPtr):gAction;
{}
var
   DNP: DoubleNodePtr;
   Fname: string[21];
begin
   with KeyVars do
   with ListdetailsPtr^ do
   begin
      if (LastKey = 600)
      or (LastKey = 27) then
         DirSelectHook := Escaped
      else if ((LastKey = 540) and (LastX <> 0))  {user selected something}
      or (LastKey = 13) then
      begin
         DNP := DLLNodePtr(ActiveNode);
         FName := DLLGetNodeStr(DNP,0,0);
         if DLLGetBit(DNP,2) then  {directory or drive}
         begin
            {$I-}
            if Fname = DirVars.RootNameStr then
               chdir('\')
            else if copy(FName,1,3) = '[ -' then  {drive}
               chdir(Fname[4]+':')
            else
               chdir(Fname);
            {$I+}
            if IoResult <> 0 then
               DirSelectHook := None
            else
            begin
               GetDir(0,LastDir);
               PopulateList;
               ActiveNode := 1;
               FileListHook(ListdetailsPtr);
               DirSelectHook := Refresh;
            end;
         end
         else if Fname = LinkVars.NoFilesFound then
            DirSelectHook := None
         else
            DirSelectHook := Finished;
      end
      else
         DirSelectHook := None;
   end
end;  {DirSelectHook}
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

function FileList(FullFilename:PathStr; Tit:StrScreen): StrScreen;
{Displays matching files in a multi-column list}
var
   DirFormat: ListCfg;
   StartDir: DirStr;

   procedure SetWindowDimensions;
   {}
   begin
      with DirFormat do
      with DirVars do
      begin
         WX1 := LX1;
         WX2 := LX2;
         WY1 := LY1;
         WY2 := LY2;
      end;
   end; { SetWindowDimensions }

begin
   initlistcfg(DirFormat);
   ListAssignSelectHook(DirFormat,DirSelectHook);
   with DirFormat do
   begin
      ColCount := 1;
      ColWidth := 12 + length(ListVars.ListLeft) + length(ListVars.Listright);
      if ColWidth = 12 then
         inc(ColWidth);
      AllowTwoColors := true;
      WStyle := DirVars.LWinStyle;
      BotGap := 2;
   end;
   SetWindowDimensions;
   ListAssignHindHook(DirFormat,FileListHook);
   with DirVars do
   begin
      if GoldMemAvail < sizeof(NameList^) then
      begin
         DirSetError(1);
         FileList := '';
      end
      else
      begin
         StartDir := CurrentPathStr;
         getmem(NameList,sizeof(NameList^));
         ParseDriveandMask(Fullfilename,LastDir);
         {$I-}
         chdir(LastDir);
         {$I+}
         if IOResult <> 0 then
            LastDir := StartDir;
         getdir(0,LastDir);  {make sure the fully qualified name is loaded}
         InitDLLStr(NameList^);
         DLLSetActiveList(NameList^);
         PopulateList;
         ListAssignDLL(DirFormat,NameList^);
         RunList(DirFormat,Tit);
         if (DirFormat.LastKey = 27) or (DirFormat.LastKey = 600) then
            FileList := ''
         else
            FileList := SlashedDirectory(LastDir)+DLLGetNodeStr(DLLNodePtr(DirFormat.ActiveNode),0,0);
         DLLDestroy;
         freemem(NameList,sizeof(NameList^));
         {$I-}
         chdir(StartDir);
         {$I+}
         if IOResult <> 0 then {oh well};
      end;
   end;
end; {FileList}

                          {*********************}
                          {**  Get Directory  **}
                          {*********************}

procedure RefreshDesc;
{}
begin
   WriteAT(3,CdirLine,Tint[IOWinBody],
          Squeeze('R',SlashedDirectory(DirVars.SavedPath),40));
end; { RefreshDesc }



{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}


procedure GetDirHindHook(CurrentField:byte;var Refresh:byte);
{}
var Rfsh: byte;
    LK: word;
    Tmp: string;


   procedure ProcessField1;
   {}
   begin
      with DirVars do
      begin
         Tmp := StrLLGetStr(DirLst,DirFldVar);
         if (Tmp <> LinkVars.NoDirectories) then
         begin
            delete(Tmp,length(tmp),1);    { deletes brackets }
            delete(Tmp,1,1);
            {$I-}
            ChDir(Tmp);
            {$I+}
            if IOResult <> 0 then
               exit
            else
            begin
               SavedPath := CurrentPathStr;
               if ( LoadWithDirectories(DirLst,SavedPath) = 0 ) then
               begin
                  ListUpdateStrLL(1,DirLst);
                  Refresh := RefreshAll;
               end;
               RefreshDesc;
            end;
         end;
      end;
   end; { ProcessField1 }

begin
   Rfsh := RefreshNone;
   case CurrentField of
      1: begin   { Directory List }
            LK := ListLastKey(1);
            if (LK = 13) or (LK = 540) then     {Enter or left double click}
               ProcessField1;
         end;
      2: begin  { Drive List }
            LK := ListLastKey(2);
            if (LK = 13) or (LK = 540) then
            with DirVars do
            begin
               if DrvFldVar <> SavedDrv then
               begin
                  SetCurrentDriveTo(DriveChar(RealDriveID(DrvFldVar)));
                  SavedPath := CurrentPathStr;
                  if ( LoadWithDirectories(DirLst,SavedPath) = 0 ) then
                  begin
                     SavedDrv := DrvFldVar;
                     ListUpdateStrLL(1,DirLst);
                     ProcessField1;
                  end else
                  begin
                     Tmp := NotReadyMsgA + DriveChar(RealDriveID(DrvFldVar)) +':|' + NotReadyMsgB;
                     repeat
                         if PromptOKCancel(NotReadyTitle,Tmp) = 2 then
                         begin
                            DrvFldVar := SavedDrv;
                            DrvLst.ActiveNode := DrvFldVar;
                            SetCurrentDriveTo(DriveChar(RealDriveID(SavedDrv)));
                            DrvLst.ActiveNode := SavedDrv;
                            SavedPath := CurrentPathStr;
                            if LoadWithDirectories(DirLst,SavedPath) <> 0 then
                               {too bad};
                            ListUpdateStrLL(1,DirLst);
                            Refresh := RefreshCurrent;
                            exit;
                         end;
                     until LoadWithDirectories(DirLst,SavedPath) = 0;
                     ListUpdateStrLL(1,DirLst)
                  end;
                  RefreshDesc;
                  Refresh := RefreshAll;
               end;
            end;
         end;
   end; { case }
end;  { GetDirHindHook }

{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

function PromptDir(FullFilename:PathStr;Cmt:StrScreen): StrScreen;
{}
var Path: PathStr;
    LastDrv, I: byte;
    CmtOn: boolean;

   procedure SetFields;
   {}
   begin
      CmtOn := Cmt <> '';
      ActivatePrivateForm;
      AssignHindHook(GetDirHindHook);
      SetFormWindow(19,6,61,18+ord(CmtOn)*2,1);
      WinSetTitle(FormWinNum,DirVars.StrPromptDirTitle);
      WinSetType(FormWinNum,WMove);
      WinSetShowNum(FormWinNum,false);
      WinDisplay(FormWinNum);
      if CmtOn then
         WriteHi(3,2,Tint[PromptHiCmt],Tint[PromptNormalCmt],Cmt);
      CDirLine := 11+ord(CmtOn)*2;
      RefreshDesc;
      KwikAddField(1,3,3+ord(CmtOn)*2);        { directory list }
      KwikAddField(2,19,3+ord(CmtOn)*2);       { drive list }
      KwikAddField(3,30,3+ord(CmtOn)*2);       { OK Button }
      if @DirVars.PromptFileHelp = nil then
         KwikAddLastField(4,30,5+ord(CmtOn)*2)   { Cancel Button }
      else
      begin
         KwikAddField(4,30,5+ord(CmtOn)*2);      { Cancel Button }
         KwikAddLastField(5,30,7+ord(CmtOn)*2);  { Help Button }
      end;
      with DirVars do
      begin
         ListField(1,15,7,DirFldVar);
         SetLabel(1,LabelTop,LabelTop,'Directories');
         if (LoadWithDirectories(DirLst,FullFileName) = 0) then
         begin
            ListAssignStrLL(1,DirLst);
            SavedDir := 1;
         end else
            DirSetError(2);
         DrvFldVar := SavedDrv;
         ListField(2,8,7,DrvFldVar);
         SetLabel(2, LabelTOp, LabelTop,'Drives');
         if (LoadWithDrives(DrvLst) = 0) then
            ListAssignStrLL(2,DrvLst);
         ButtonField(3,WinVars.OKButStr,Finished);
         ButtonField(4,WinVars.CancelButStr,Escaped);
         SetHK(3,WinVars.OKHotKey);
         SetHK(4,WinVars.CancelHotKey);
         if @DirVars.PromptFileHelp <> nil then
         begin
            ButtonField(5,WinVars.HelpButStr,Stop9);
            SetHK(5,WinVars.HelpHotKey);
         end;
      end;
   end; { SetFields }

begin
   with DirVars do
   begin
      SavedDrv := CurrentDriveByte;
      dec(SavedDrv,ord((SavedDrv <> 1) and IsPhantom));
      StrLLInit(DrvLst);
      StrLLInit(DirLst);
      StartPathStr := CurrentPathStr;
      if FullFileName = '' then
         FullFileName := StartPathStr;
      SavedPath := FullFileName;
      SetFields;
      repeat
         LastAction := EditForm(1);
         case LastAction of
           Stop1: begin {chdir}
             {!!}
           end;
           Stop9: DirVars.PromptFileHelp;
         end;
      until LastAction in [Finished,Escaped];
      if LastAction = Finished then
         PromptDir := SavedPath
      else
         PromptDir := '';
      if not SetCurrentPath(StartPathStr) then  { set path to original }
         DirSetError(3);
      DisposeFields;
      DisposePrivateForm;
      StrLLDestroy(DrvLst);
      StrLLDestroy(DirLst);
   end;
end;  { PromptDir }

                             {****************}
                             {**  TagFiles  **}
                             {****************}

              {*********************************************}
              {**  U N I T   I N I T I A L I Z A T I O N  **}
              {*********************************************}

procedure DirDefaultSettings;
{}
begin
   with DirVars do
   begin
      Attr := anyfile - Hidden - Directory - SysFile - VolumeID;
      AllowDirChange := true;
      AllowDrvChange := true;
      SortByName := false;
      InputField := '';
      DefaultMask := '';
      LWinStyle := 7;
      LX1 := 18;
      LY1 := 5;
      LX2 := 64;
      LY2 := 19;
      ExistsOnly := false;
   end;
end; { DirDefaultSettings }

procedure GOLDDIRInit;
{}
begin
   with DirVars do
   begin
      LastECode := 0;
      ScrlFldVar := '';
      StrLLInit(DrvLst);
      StrLLInit(TypLst);
      StrLLInit(DirLst);
      StrLLInit(FilLst);
      LastAction := None;
      DirFldVar := 1;
      DrvFldVar := 1;
      SavedDir := 0;
      EMsgFunc := DirEMsg;
      PromptFileHelp := nil;
      StrPromptFileTitle := ' Pick a File ';
      StrPromptDirTitle := ' Change directory ';
      OpenButStr := '  ~O~pen  ';
      OpenHK := 280;
      NotReadyTitle := 'Drive not ready!';
      NotReadyMsgA := 'Cannot read drive ';
      NotReadyMsgB := 'Please insert a disk or select Cancel';
      NoExistTitle := ' INVALID ';
      NoExistText := '||^Not a valid path or file name';
      ParentStr := 'Parent directory';
      SubDirStr := 'Sub directory';
      RootStr := 'Root directory';
      NoFilesStr := 'No files found';
      RootNameStr := '\ (root)';
      DriveStr := 'Drive';
      SortingStr := 'Sorting files...';
   end;
   DirDefaultSettings;
end; {GOLDDIRInit}

{$IFDEF TTT5} { allows backward compatibility to TTT5 }

function Display_Directory(DIRFULLFileName: StrScreen;var Retcode:integer): StrScreen;
{included for TTT5 compatibility}
begin
   Display_Directory := PromptFile(DIRFULLFileName);
   RetCode := DirVars.LastECode;
end;

{$ENDIF}

begin
   GOLDDIRInit;
end.
