{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMPMT4.PAS
              Illustrates how to create a custom Prompt which
              has a timeout period.
}

program DemPmt4;

{$I GOLDFLAG.INC}

uses DOS,CRT, GoldMisc, GoldAttr, GoldHard, GoldFast, GoldWin, GoldKey;

var Choice:integer;

procedure SetScreen;
{}
begin
   Clear(WhiteOnCyan,'');
   ClearLine(1,YellowOnBlue);
   WriteCenter(1,0,'3 Button Prompt With Timeout');
   ClearLine(25,BlackOnBrown);
   WriteCenter(25,0,'Press ESC to finish...');
end; { SetScreen }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   {The last parameter "5000" is the amount of time (in milliseconds) to wait for a response}
   Choice := PromptCustom(' Error ','^Drive not ready.',' ~A~bort ',' ~R~etry ',' ~I~gnore ',65,82,73,3,5000);
   case Choice of
      0: PromptOK(' Too Late! ','You took too long deciding!');
      1: PromptOK('','You chose Abort!');
      2: PromptOK('','You chose Retry!');
      3: PromptOK('','You chose Ignore!');
   end; {case}
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { DemPmt4 }
