{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DemMen4.PAS
              Shows how to use a character hook with a pop-up menu.
}

program DEMMEN4;

uses CRT, DOS, GoldFast, GoldMenu, GoldAttr, GoldTint,
               GoldMisc, GoldKey, GoldWin, GoldStr;

var
  MainMenu: MenuRecord;
  Choice,Ecode: integer;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlue,chr(176));
   ClearLine(1,WhiteOnBlue);
   ClearLine(25,WhiteOnBlue);
   WriteCenter(1,LightgrayOnBlue,' Copyright (c) 1995 TechnoJock Software Inc. ');
   WriteHi(1,25,YellowOnBlue,WhiteOnBlue,'~F1~ Topic Help    ~Alt-X~ Exit');
end; {SetScreen}

procedure SetMenu;
{}
begin
   MenuSet(MainMenu);
   with MainMenu do
   begin
      Heading1 := 'Missile Sites';
      Heading2 := 'Main Menu';
      Topic[1]  := '  Authorization';
      Topic[2]  := '  Load Database';
      Topic[3]  := '  Re-index Database ';
      Topic[4]  := '  Input new Data';
      Topic[5]  := '  Save Database';
      Topic[6]  := '  Print Reports';
      Topic[7]  := '  Quit';
      TotalPicks := 7;
      Boxtype      := 5;
      AddPrefix    := 1;
      PicksPerLine := 1;
      AllowEsc     := false;
   end;
end; { SetMenu }

{$F+}
procedure CheckForKeys(var Key:word; Choice:integer; var Ecode:integer);
{Checks for F1 or Alt-X}
begin
   if Key = 315then
   begin
      case Choice of
          1 :PromptOK(' Help ',
             '^~Authorization~||'+
             'Select this option before loading|'+
             'any databases - must enter password.'
             );
          2 :PromptOK(' Help ',
             '^~Load DataBase~||'+
             'Select this option to retrieve a|'+
             'missile database from disk.'
             );
          3 :PromptOK(' Help ',
             '^~Re-Index Database~||'+
             'Select this option to reorganize|'+
             'the database and improve performance.'
             );
          4 :PromptOK(' Help ',
             '^~New Data~||'+
             'Select this option to add new miss-|'+
             'ile site, or change existing one.'
             );
          5 :PromptOK(' Help ',
             '^~Save Database~||'+
             'Select this option to store new|'+
             'data back to the disk drive.'
             );
          6 :PromptOK(' Help ',
             '^~Print Reports~||'+
             'Select this option to print the|'+
             'missile summary for Europe/USA.'
             );
          7 :PromptOK(' Help ',
             '^~QUIT~||'+
             'If you don''t know what quit|'+
             'means why are you in the army?'
             );
      end;
   end
   else if Key = 301 then
       Ecode := 99; {exit}
end; { CheckForKeys }
{$F-}

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   clrscr;
   SetScreen;
   SetMenu;
   MainMenu.Hook := CheckForKeys;
   MouseShow(true);
   Choice := 1;
   repeat
      DisplayMenu(MainMenu,false,Choice,ECode);
      if Choice in [1..6] then
         PromptOK(' Selection ','You chose menu item '+IntToStr(Choice));
   until Choice = 7;
   MouseShow(false);
   clrscr;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { DEMMEN4 }
