{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DemMen2.PAS
              Shows how to customize the colors in a pop-up menu.
}

program DEMMEN2;

uses CRT, DOS, GoldFast, GoldMenu, GoldAttr, GoldTint,
               GoldMisc, GoldKey, GoldWin;

var
  MainMenu: MenuRecord;
  Choice,Ecode: integer;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlue,chr(176));
   ClearLine(25,WhiteOnBlue);
   WriteCenter(25,LightgrayOnBlue,' Copyright (c) 1995 TechnoJock Software Inc. ');
end; {SetScreen}

procedure SetMenu;
{}
begin
   MenuSet(MainMenu);
   with MainMenu do
   begin
      Heading1     := 'TechnoJock''s Turbo Toolkit';
      Heading2     := 'using Ugly Colors';
      Topic[1]     := 'Unit Descriptions';
      Topic[2]     := '-Unit Demos';
      Topic[3]     := 'Self-Running Demo';
      Topic[4]     := 'How to register';
      Topic[5]     := 'About GOLD';
      Topic[6]     := '';
      Topic[7]     := 'Exit Demo';
      TotalPicks   := 7;
      Boxtype      := 5;
      AddPrefix    := 3;
      PicksPerLine := 1;
      AllowEsc     := false;
   end;
end; { SetMenu }

procedure CustomizeColors;
{}
begin
   GoldSetColor(MenuHiHot,YellowOnGreen);
   GoldSetColor(MenuHi,BlackonGreen);
   GoldSetColor(MenuNormHot,YellowOnMagenta);
   GoldSetColor(MenuNorm,WhiteOnMagenta);
   GoldSetColor(MenuOff,LightgrayonMagenta);
   GoldSetColor(MenuBorder,YellowOnMagenta);
end; { CustomizeColors }

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   clrscr;
   SetScreen;
   CustomizeColors; {call before menuSet}
   SetMenu;
   MouseShow(true);
   Choice := 5;
   repeat
      DisplayMenu(MainMenu,false,Choice,ECode);
      case Choice of
         1: PromptOK(' Pretend ','You chose Unit Descriptions');
         2: ;
         3: PromptOK(' Pretend ','You chose Self-Running Demo');
         4: PromptOK(' Pretend ','How to register');
         5: PromptOK(' About ','^Gold||Copyright 1995 TechnoJock Software, Inc.');
      end;
   until Choice = 7;
   MouseShow(false);
   clrscr;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { DEMMEN2 }
