{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description:  DEMMEM8.PAS
               Illustrates how a hind hook is used to display the cursor
               position in the window frame.
}

program DemMem8;

{$I GOLDFLAG.INC}

uses CRT,
     GoldAttr, GoldFast, GoldMisc, GoldStr,
     GoldLink, GoldKey, GoldWin, GoldMemo;

const
     TextFileName = 'DEMMEM3.TXT';

var
  TextData: SingleLL;
  MemoSettings: MemoCFG;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,RedOnLightgray);
   WriteCenter(1,UseTInt,'TTT Gold');
   ClearLine(25,BlackOnLightgray);
   WritePlain(8,25,'');
end; { SetScreen }

procedure BuildSLL;
{}
begin
   InitSLLStr(TextData);
   SLLSetActiveList(TextData);
   if SLLLoadFromFile(TextFileName) <> 0 then {file not found}
      if SLLAddStr('') <> 0 then {create the first node}
      else
      begin
         PromptOK(' ERROR ','Not enough memory to execute program');
         halt;
      end;
end; {BuildSLL}

{$F+}
procedure UpdateFrame(MP:MemoCfgPtr);
{}
var Y: shortint;
begin
   with MP^ do
   begin
      SetWinIgnore(true);
      Y := WinPtr(WinWithFocus)^.Depth;
      if MemoIsDirty(MP^) then
         WritePlain(3,Y,'');
      WritePlain(6,Y,
                 padright(IntToStr(pred(TopNode)+CursorPosY),3,' ')
                 +':'
                 +padleft(IntToStr(CursorPosX),3,' '));
      SetWinIgnore(false);
   end;
end; { UpdateFrame }
{$F-}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   BuildSLL;
   InitMemoCfg(MemoSettings);
   MemoAssignSLL(MemoSettings,TextData);
   MouseShow(true);
   MemoSetWordwrap(MemoSettings,false); {no word wrap}
   MemoAssignHindHook(MemoSettings,UpdateFrame);
   RunMemo(MemoSettings,' Displaying the Cursor Position ');
   MouseShow(false);
   SLLSetActiveList(TextData);
   SLLDestroy;
   ResetStartUpMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. {DEMMEM8}
