{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description:  DEMMEM7.PAS
               Edits a text file with word wrapping turned off and implements
               a character hook to provide Ctrl-Y for line deletion.
}

program DemMem7;

{$I GOLDFLAG.INC}

uses CRT,
     GoldAttr, GoldFast, GoldMisc, GoldIO,
     GoldLink, GoldKey, GoldWin, GoldMemo;

const
     TextFileName = 'DEMMEM3.TXT';

var
  TextData: SingleLL;
  MemoSettings: MemoCFG;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,RedOnLightgray);
   WriteCenter(1,UseTInt,'TTT Gold');
   ClearLine(25,BlackOnLightgray);
   WritePlain(8,25,'');
end; { SetScreen }

procedure BuildSLL;
{}
begin
   InitSLLStr(TextData);
   SLLSetActiveList(TextData);
   if SLLLoadFromFile(TextFileName) <> 0 then {file not found}
      if SLLAddStr('') <> 0 then {create the first node}
      else
      begin
         PromptOK(' ERROR ','Not enough memory to execute program');
         halt;
      end;
end; {BuildSLL}


{$F+}
procedure DelLineHook(MP:MemoCfgPtr;var Code:word; var X,Y:byte);
{The following code is not for the faint hearted. The memo editor
is not really designed to be opened up to hooks -- in other words,
to customize the editor's behaviour, you need to understand how the
editor works.}
begin
   if Code = 25 then {Ctrl-Y was pressed}
      with MP^ do
      begin
         DelLine(MP,pred(TopNode)+CursorPosY);
         if pred(TopNode)+CursorPosY = TotalNodes then
            CursorUp(MP^);
         LineStr := GetLine(MP,pred(TopNode)+CursorPosY);
         dec(TotalNodes);
         DisplayMemo(MP^,HiStatus);
      end;
end; { DelLineHook }
{$F-}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   BuildSLL;
   InitMemoCfg(MemoSettings);
   MemoAssignSLL(MemoSettings,TextData);
   MouseShow(true);
   MemoSetWordwrap(MemoSettings,false); {no word wrap}
   MemoAssignCharHook(MemoSettings,DelLineHook);
   RunMemo(MemoSettings,' Text Editing without Word Wrap ');
   MouseShow(false);
   SLLSetActiveList(TextData);
   SLLDestroy;
   ResetStartUpMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. {Demmem7}
