{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description:  DEMMEM3.PAS
               Edits a text file with word wrapping turned off.
}

program DemMem3;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldFast, GoldMisc, GoldLink, GoldKey, GoldWin, GoldMemo;

const
     TextFileName = 'DEMMEM3.TXT';

var
  TextData: SingleLL;
  MemoSettings: MemoCFG;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,RedOnLightgray);
   WriteCenter(1,UseTInt,'TTT Gold');
   ClearLine(25,BlackOnLightgray);
   WritePlain(8,25,'');
end; { SetScreen }

procedure BuildSLL;
{}
begin
   InitSLLStr(TextData);
   SLLSetActiveList(TextData);
   if SLLLoadFromFile(TextFileName) <> 0 then {file not found}
      if SLLAddStr('') <> 0 then {create the first node}
      else
      begin
         PromptOK(' ERROR ','Not enough memory to execute program');
         halt;
      end;
end; {BuildSLL}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   BuildSLL;
   InitMemoCfg(MemoSettings);
   MemoAssignSLL(MemoSettings,TextData);
   MouseShow(true);
   MemoSetWordwrap(MemoSettings,false); {no word wrap}
   RunMemo(MemoSettings,' Text Editing without Word Wrap ');
   MouseShow(false);
   SLLSetActiveList(TextData);
   SLLDestroy;
   ResetStartUpMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
