{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMLNK2.PAS
              Illustrates the creation of a doubly linked list
              using GOLDLINK.
}

program DemLnk2;

{$I GOLDFLAG.INC}

uses CRT, GoldMisc, GoldLink;

var
  GirlFriends: DoubleLL;
  Retcode: integer;
  I: integer;
  S : string;

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   clrscr;
   InitDLLStr(GirlFriends);
   DLLSetActiveList(GirlFriends);
   Retcode := DLLAddStr('Erica');
   Retcode := DLLAddStr('Theresa');
   Retcode := DLLAddStr('Lynn');
   Retcode := DLLAddStr('Donna');
   Retcode := DLLAddStr('Godzilla');
   writeln('Total nodes: ',GirlFriends.TotalNodes);
   writeln('Active node number: ',GirlFriends.ActiveNodeNumber);
   for I := 1 to GirlFriends.TotalNodes do
       writeln(DLLGetNodeStr(DLLNodePtr(I),0,0));
   writeln;
   S := 'Joyce';
   RetCode := DLLInsertBefore(DLLNodePtr(4),S,length(S)+1);
   writeln('Total nodes: ',GirlFriends.TotalNodes);
   writeln('Active node number: ',GirlFriends.ActiveNodeNumber);
   DLLSwapNodes(DLLNodePtr(5),DLLNodePtr(2));
   S := 'Ekka';
   Retcode := DLLChange(GirlFriends.StartNodePtr,S,length(S)+1);
   for I := 1 to GirlFriends.TotalNodes do
       writeln(DLLGetNodeStr(DLLNodePtr(I),0,0));
   repeat until keypressed;
   DLLDestroy;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { DemLnk2 }
