{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMKY2.PAS
              Illustrates how to mouse management using the GoldKey unit.
}

program DEMKY2;

{$I GOLDFLAG.INC}

uses CRT, GoldMisc, GoldAttr, GoldKey, GoldFast;

var
  Ch : char;
  L,C,R,OldL,OldC,OldR: boolean;
  X,Y,OldX,OldY: byte;

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   Clrscr;
   if not MouseInstalled then
   begin
      Writeln('This demo will only function on systems equipped with a mouse');
   end
   else
   begin
      WriteLn('You have a ',KeyVars.ButtonCount,' button mouse!');
      Writeln('Press: C to confine the mouse');
      Writeln('       U to unconfine the mouse');
      Writeln('       L to change the mouse cursor');
      Writeln('       R to reset mouse');
      Writeln('       H to hide the mouse');
      Writeln('       S to show the mouse');
      Writeln('       any mouse button');
      Writeln('       Esc to quit');
      FBox(15,10,65,20,YellowOnBlue,1);
      MouseShow(true);
      repeat
         repeat
            MouseStatus(L,C,R,X,Y);
            if OldL <> L then
               if L then
                  WriteAT(20,11,YellowOnBlue,'Left Button')
               else
                  WriteAT(20,11,YellowOnBlue,'           ');
            if OldR <> R then
               if R then
                  WriteAT(20,12,YellowOnBlue,'Right Button')
               else
                  WriteAT(20,12,YellowOnBlue,'            ');
            if OldC <> C then
               if C then
                  WriteAT(20,13,YellowOnBlue,'Middle Button')
               else
                  WriteAT(20,13,YellowOnBlue,'             ');
                  (*
            if OldX <> X then
               WriteAT(20,15,30,inttostr(X)+' ');
            if OldY <> Y then
                WriteAT(20,16,30,inttostr(Y)+' ');
                *)
            OldL := L;
            OldR := R;
            OldC := C;
            OldX := X;
            OldY := Y;
         until GKeyPressed;
         GetInput;
         case upcase(chr(KeyVars.LastKey)) of
            'C': MouseConfine(15,10,65,20);
            'U': MouseConfine(1,1,80,25);
            'L': MouseStyle(random(200)+56,0);
            'H': MouseShow(false);
            'S': MouseShow(true);
            'R': begin
                    MouseShow(false);
                    MouseHardWareReset;
                    MouseShow(true);
                 end;
         end; {case}
      until KeyVars.LastKey = 27;
      MouseShow(false);
   GotoXY(1,23);
   end;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
