{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMIO8.PAS
              A font selection demo which illustrates some of
              the new  spin and drop fields.
}{
              Also illustrates how to use ListKwikAddItem procedure.
}

program DEMIO8;

{$I GOLDFLAG.INC}

uses  DOS, CRT, GoldAttr, GoldHard, GoldFast, GoldWin, GoldIO, GoldIO2,
      GoldIO3, GoldDate, GoldStr, GoldKey, GoldMisc;

type
   PrintRec = record
      TypefaceID: integer;
      TypeSize: byte;
      Bold: boolean;
      Italic: boolean;
   end; {PrintRec}

var
   PrintInfo: PrintRec;
   Norm: boolean;
   LongVar: longint;

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,YellowOnBlue);
   ClearLine(25,LightCyanOnBlue);
   WritePlain(8,25,'');
   WriteCenter(1,UseTint,' Spin & Drop Fields ');
   GotoXY(1,1);
end; {SetScreen}

procedure SetVars;
{Sets the default values for the fields}
begin
   with PrintInfo do
   begin
      TypefaceID := 1;
      TypeSize := 12;
      Bold := false;
      Italic := false;
   end;
   Norm := true;
   LongVar := PrintInfo.TypeSize;
end; {SetVars}

procedure SetFields;
{}
var I : Integer;
begin
   CreateForms(1);
   ActivateForm(1);
   {define the form's window}
   SetFormWindow(15,5,65,17,1);
   WinSetTitle(FormWinNum,' Font Settings ');
   WinSetType(FormWinNum,WMove);
   WinSetShowNum(FormWinNum,false);
   KwikAddField(1,15,2);
   KwikAddField(2,15,4);
   KwikAddField(3,15,6);
   KwikAddField(4,25,10);
   KwikAddLastField(5, 38,10);
   {Font List}
   SpinDropListField(1,25,PrintInfo.TypeFaceID);
   ListKwikAddItem(1,'Adelaide|Arial MT|Bookman|Courier|Dom Casual|Freestyle Script|Griffon');
   ListKwikAddItem(1,'Helvetica|Juniper|Kidnap|Lithos Light|Palatino|Symbol|System|Times Roman|Zap Dingbobs');
   SetLabel(1,LabelLeft,LabelLeft,'~T~ypeface');
   SetHK(1,276);
   SetMessage(1,0,0,'Select the typeface for printed output');
   {Font Size}
   SpinLongField(2,Longvar,2,6,72,1);
   SetLabel(2,LabelLeft,LabelLeft,'~P~oint size');
   SetHK(2,281);
   SetMessage(2,0,0,'Enter a point size in the range 6 to 72');
   {Check boxes}
   CheckField(3,15,3);
   CheckAddItem(3,1,1,'~N~ormal','Turns off bold and italic',305,Norm);
   CheckAddItem(3,1,2,'~B~old','Select this field for bold text',304,Printinfo.Bold);
   CheckAddItem(3,1,3,'~I~talic','Select this field for bold text',279,Printinfo.Italic);
   SetLabel(3,LabelLeft,LabelLeft,'Format');
   ButtonDefaultField(4,'   ~O~K   ',finished);
   SetHK(4,280);
   SetMessage(4,0,0,'Accept the settings in this dialog box');
   ButtonField(5,' C~a~ncel ',escaped);
   SetHK(5,286);
   SetMessage(5,0,0,'Close the dialog box without making any changes');
   SetMessageXY(10,25,false);  {ignore the window, and write at 10,25}
end; {SetFields}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   SetVars;
   SetFields;
   MouseShow(true);
   ProcessInput(1);
   DisposeFields;
   DisposeForms;
   PrintInfo.TypeSize := Longvar;
   GotoXY(1,21);
   MouseShow(false);
   Clrscr;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
