{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMIO7.PAS
              Uses an IO form in a window to create a simple pick-list.
}

program DEMIO7;

{$I GOLDFLAG.INC}

uses  DOS, CRT, GoldAttr, GoldHard, GoldFast, GoldWin, GoldIO, GoldIO2,
      GoldDate, GoldStr, GoldKey, GoldMisc;

var
     SelectedItem: integer;

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,YellowOnBlue);
   ClearLine(25,LightGrayOnBlue);
   WriteCenter(25,UseTint,' Copyright (c) 1995 TechnoJock Software Inc. ');
   WriteCenter(1,UseTint,' A Basic Pick List Window ');
   SelectedItem := 1;
end; {SetScreen}

procedure SetFields;
{}
var I : Integer;
begin
   CreateForms(1);
   ActivateForm(1);
   AllowEsc(true);
   {Add all the fields}
   SetFormWindow(24,5,56,18,1);
   WinSetTitle(FormWinNum,' Pick a Name ');
   WinSetType(FormWinNum,WMove);
   WinSetShowNum(FormWinNum,false);
   KwikAddField(1, 3,2);
   KwikAddField(2,5,11);
   KwikAddLastField(3, 18,11);
   {The List}
   ListField(1,27,8,SelectedItem); {field #1, 27 chars wide, 8 lines deep}
   ListAddItem(1,'Erica');         {add items to field 1}
   ListAddItem(1,'Theresa');
   ListAddItem(1,'Shirley');
   ListAddItem(1,'Donna');
   ListAddItem(1,'Allison');
   ListAddItem(1,'Evete');
   ListAddItem(1,'Mona');
   ListAddItem(1,'Hilary');
   ListAddItem(1,'Gabby');
   ListAddItem(1,'Anne');
   ListAddItem(1,'Bonnie');
   ListAddItem(1,'Joni');
   ListAddItem(1,'Albert');
   {Buttons}
   ButtonDefaultField(2,'   ~O~K   ',finished);  {OK selected if user presses Enter}
   ButtonField(3,' C~a~ncel ',escaped);
   SetHK(2,280);
   SetHK(3,286);
end; {SetFields}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   SetFields;
   MouseShow(true);
   ProcessInput(1);
   DisposeFields;
   DisposeForms;
   promptOK(' Result ','Selected item is '+inttostr(SelectedItem));
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
