{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMIO13.PAS
              Uses an IO form in a window to create a taggable
              pick-list with Tag buttons. (A varaint of DEMIO11)
}

program DEMIO13;

{$I GOLDFLAG.INC}

uses DOS, CRT, GoldAttr, GoldHard, GoldFast, GoldWin, GoldIO, GoldIO2,
               GoldDate, GoldStr, GoldKey, GoldMisc, GoldList, GoldLink;

var
   SelectedItem: integer;
   SourceList: SingleLL;
   ListFormat: ListCfg;
   EditAction: gAction;
   UnTabButtonOn: boolean;   {used to toggle the button description}
   ItemIsTagged: boolean;  {used to toggle the tag state}

procedure CheckTagButton;
{Checks to see whether the button description needs to be Tag or UnTag}
begin
   ItemIsTagged := SLLGetTagState(ListFormat.ActiveNode);
   if ItemIsTagged <> UnTabButtonOn then
   begin
      if ItemIsTagged then
         ButtonChangeSettings(2,' Un~T~ag ',Stop1)
      else
         ButtonChangeSettings(2,'  ~T~ag  ',Stop1);
      UnTabButtonOn := ItemIsTagged;
   end;
end; {CheckTagButton}

{$F+}
procedure HindHook(CurrentField:byte;var Refresh:byte);
{Check the "tag" button state, and updates the list description}
begin
   if CurrentField = 1 then
      CheckTagButton;
   {now update the comment}
   WriteAt(1,16,blueoncyan,Padcenter('The active pick is '+IntToStr(ListFormat.ActiveNode),75,' '));
   Refresh := RefreshAll;
end; {HindHook}
{$F-}

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(25,LightGrayOnBlue);
   WriteCenter(25,UseTint,' Copyright (c) 1995 TechnoJock Software Inc. ');
   SelectedItem := 1;
end; {SetScreen}

procedure ShutDown;
{}
begin
   PromptOK(' ERROR! ','Not enough memory to run program!');
   halt;
end; { ShutDown }

procedure FillTheList;
{}
var I: integer;
begin
   I := 0;
   InitSLLStr(SourceList);
   SLLSetActiveList(SourceList);
   inc(I,SLLAddStr('Erica'));
   inc(I,SLLAddStr('Theresa'));
   inc(I,SLLAddStr('Shirley'));
   inc(I,SLLAddStr('Donna'));
   inc(I,SLLAddStr('Allison'));
   inc(I,SLLAddStr('Evete'));
   inc(I,SLLAddStr('Mona'));
   inc(I,SLLAddStr('Hilary'));
   inc(I,SLLAddStr('Gabby'));
   inc(I,SLLAddStr('Anne'));
   inc(I,SLLAddStr('Bonnie'));
   inc(I,SLLAddStr('Joni'));
   inc(I,SLLAddStr('Albert'));
   inc(I,SLLAddStr('Sharon 1'));
   inc(I,SLLAddStr('Sharon 2'));
   inc(I,SLLAddStr('Gillian'));
   inc(I,SLLAddStr('Helen'));
   inc(I,SLLAddStr('Sereta'));
   inc(I,SLLAddStr('Jane'));
   inc(I,SLLAddStr('Juliet'));
   inc(I,SLLAddStr('Marianne'));
   inc(I,SLLAddStr('Carla'));
   inc(I,SLLAddStr('Stella'));
   inc(I,SLLAddStr('Billi'));
   inc(I,SLLAddStr('Suzy'));
   if I <> 0 then
      ShutDown;
end; {FillTheList}

procedure ConfiguretheListFormat;
{}
begin
   InitListCfg(ListFormat);
   ListSetTagging(ListFormat,true);
   ListSetTagColor(ListFormat,true);
end; {ConfiguretheListFormat}

procedure SetFields;
{}
var I : Integer;
begin
   CreateForms(1);
   ActivateForm(1);
   AllowEsc(true);
   {Add all the fields}
   SetFormWindow(2,2,79,23,6);
   WinSetTitle(FormWinNum,' Tag Your Favorites ');
   WinSetType(FormWinNum,WMove);
   WinSetShowNum(FormWinNum,false);
   WinDisplay(FormWinNum);
   WriteAT(1,16,blackoncyan,Replicate(75,'')+' ');
   KwikAddField(1, 1,2);
   KwikAddField(2, 6,19);
   KwikAddField(3, 18,19);
   KwikAddField(4, 33,19);
   KwikAddField(5, 49,19);
   KwikAddLastField(6, 62,19);
   AssignHindHook(HindHook);
   {The List}
   FillTheList;
   ConfiguretheListFormat;
   ListAssignSLL(ListFormat,SourceList);
   WrapListField(1,75,1,14,ListFormat);  {15 character columns, 3 columns wide, 4 rows deep}
   {Buttons}
   ButtonField(2,'  ~T~ag  ',Stop1);
   ButtonField(3,' Tag ~A~ll  ',Stop2);
   ButtonField(4,' ~U~ntag all ',Stop3);
   ButtonDefaultField(5,'   ~O~K   ',finished);  {OK selected if user presses Enter}
   ButtonField(6,' ~C~ancel ',escaped);
   SetHK(2,276); {Alt+T}
   SetHK(3,286); {Alt+A}
   SetHK(4,278); {Alt+U}
   SetHK(5,280); {Alt+O}
   SetHK(6,302); {Alt+C}
end; {SetFields}

procedure ReviewTaggedSelections;
{}
var I,ListCount: longint;
begin
   SLLSetActiveList(SourceList);
   ListCount := SourceList.TotalNodes;
   SLLDelAllStatus(TagBit,false);  {delete all items from the list that weren't tagged}
   if ListCount = SourceList.TotalNodes then
      PromptOK('','You tagged all the girls!')
   else if SourceList.TotalNodes = 0 then
      PromptOK('','You didn''t tag any girls!')
   else
   begin
      ListSetTagging(ListFormat,false);
      ListAssignSLL(ListFormat,SourceList);  {assign again cos the list size may have changed}
      RunList(ListFormat,'You tagged these girls!');
   end;
end; {ReviewTaggedSelections}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   UseCustomChars;
   SetFields;
   MouseShow(true);
   UnTabButtonOn := false;
   repeat
      DisplayAllFields;
      EditAction := EditForm(1);
      case EditAction of
         Stop1: begin  {toggle the tag state of the active item}
            ItemIsTagged := SLLGetTagState(ListFormat.ActiveNode);
            SLLSetBit(SLLNodePtr(ListFormat.ActiveNode),TagBit, not ItemIsTagged);
            SLLSetBit(SLLNodePtr(ListFormat.ActiveNode),ColBit, not ItemIsTagged);
         end;
         Stop2: begin
            SetTagAll(ListFormat,true);
         end;
         Stop3: begin
            SetTagAll(ListFormat,false);
         end;
      end; {case}
      CheckTagButton;
   until EditAction in [Finished,Escaped];
   DisposeFields;
   DisposeForms;
   ReviewTaggedSelections;
   SLLDestroy;               {dispose of the list 'cos IO won't do it!}
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
